;;; $8000..8686: Common to all enemy banks ;;;
{
; See bank $A0
}


;;; $8687..D744: Torizo ;;;
{
;;; $8687: Torizo palettes ;;;
{
; Orb projectile
$AA:8687             dw 3800,03FF,033B,0216,0113,6B1E,4A16,3591,20E9,1580,1580,1580,1580,1580,1580,1580 ; Sprite palette 3

; Bomb Torizo statue
$AA:86A7             dw 3800,02DF,01D7,00AC,5A73,41AD,2D08,1863,1486,0145,0145,0145,7FFF,0145,0145,0000 ; Sprite palette 7

; Initial Bomb Torizo
$AA:86C7             dw 3800,679F,5299,252E,14AA,5EFC,4657,35B2,2D70,5B7F,3DF8,2D0E,5F5F,5E1A,5D35,0C63 ; Sprite palette 1
$AA:86E7             dw 3800,4ABA,35B2,0847,0003,4215,2970,18CB,1089,463A,28B3,1809,6F7F,51FD,4113,0C63 ; Sprite palette 2

; Normal Torizo (Bomb Torizo after coming to life, Golden Torizo transitions to this from damage, the hatched Golden Torizo egg)
$AA:8707             dw 3800,56BA,41B2,1447,0403,4E15,3570,24CB,1868,6F7F,51F8,410E,031F,01DA,00F5,0C63 ; Sprite palette 1
$AA:8727             dw 3800,4215,2D0D,0002,0000,3970,20CB,0C26,0403,463A,28B3,1809,6F7F,51FD,4113,0C63 ; Sprite palette 2

; Initial Golden Torizo
$AA:8747             dw 3800,6AB5,49B0,1C45,0C01,5613,416D,2CC9,2066,5714,31CC,14E3,5630,3569,1883,0C66 ; Sprite palette 1
$AA:8767             dw 3800,5610,350B,0800,0000,416E,2CC8,1823,0C01,6A31,4CAA,2406,7F7B,75F4,4D10,0C63 ; Sprite palette 2

; Golden Torizo (after coming to life)
$AA:8787             dw 3800,4BBE,06B9,00A8,0000,173A,0276,01F2,014D,73E0,4F20,2A20,7FE0,5AA0,5920,0043 ; Sprite palette 1
$AA:87A7             dw 3800,3719,0214,0003,0000,0295,01D1,014D,00A8,4B40,25E0,00E0,6B40,4600,4480,0000 ; Sprite palette 2
}


;;; $87C7: Torizo hitbox - blank ;;;
{
$AA:87C7             dw 0000
}


;;; $87C9: Torizo spritemap - blank ;;;
{
$AA:87C9             dx 0001, 0100,00,4200
}


;;; $87D0: Torizo extended spritemap - blank ;;;
{
$AA:87D0             dw 0001, 0000,0000,87C9,87C7
}


;;; $87DA: Torizo hitboxes ;;;
{
; Unused
$AA:87DA             dx 0001, FFF5,FFD6,000A,0003,C977,C97C

; Stand up / sit down - facing left
$AA:87E8             dx 0001, FFF0,FFE5,0010,001B,C977,C9C2
$AA:87F6             dx 0001, FFF2,FFE5,000D,001B,C977,C9C2
$AA:8804             dx 0001, FFF3,FFDE,0009,0021,C977,C9C2
$AA:8812             dx 0001, FFF5,FFDA,000B,0027,C977,C9C2
$AA:8820             dx 0001, FFF1,FFD4,0008,002F,C977,C9C2
$AA:882E             dx 0001, FFEE,FFD5,0003,0018,C977,C9C2
$AA:883C             dx 0001, FFEF,FFD6,0005,000F,C977,C9C2

$AA:884A             dx 0001, FFF1,FFD9,0007,0015,C977,C97C
$AA:8858             dx 0000
$AA:885A             dx 0000
$AA:885C             dx 0001, FFF0,0027,FFFF,0037,C977,C9C1 ; Unused
$AA:886A             dx 0000
$AA:886C             dx 0001, FFE0,0029,FFF3,0040,C977,C9C1 ; Unused
$AA:887A             dx 0000
$AA:887C             dx 0001, FFD8,001C,FFEC,0030,C977,C9C1 ; Unused
$AA:888A             dx 0000
$AA:888C             dx 0001, FFC8,0009,FFEB,0014,C977,C9C1 ; Unused
$AA:889A             dx 0000
$AA:889C             dx 0001, FFD3,FFF3,FFE5,0003,C977,C9C1 ; Unused
$AA:88AA             dx 0000
$AA:88AC             dx 0001, FFE3,FFDB,FFF0,FFF1,C977,C9C1 ; Unused
$AA:88BA             dx 0000
$AA:88BC             dx 0000
$AA:88BE             dx 0001, FFEF,0028,0000,0039,C977,C9C1 ; Unused
$AA:88CC             dx 0000
$AA:88CE             dx 0001, FFE6,0021,FFF4,0032,C977,C9C1 ; Unused
$AA:88DC             dx 0000
$AA:88DE             dx 0001, FFDD,0018,FFEA,0025,C977,C9C1 ; Unused
$AA:88EC             dx 0000
$AA:88EE             dx 0001, FFCA,0008,FFE9,0012,C977,C9C1 ; Unused
$AA:88FC             dx 0000
$AA:88FE             dx 0001, FFD3,FFF3,FFE3,0000,C977,C9C1 ; Unused
$AA:890C             dx 0000
$AA:890E             dx 0001, FFE4,FFDA,FFEF,FFEE,C977,C9C1 ; Unused
$AA:891C             dx 0001, FFEE,FFDA,0007,0009,C977,C97C
$AA:892A             dx 0001, FFEE,FFDB,0007,0012,C977,C97C
$AA:8938             dx 0001, FFF5,FFD6,000A,0007,C977,C97C ; Unused

; Stand up / sit down - facing right
$AA:8946             dx 0001, FFF1,FFE5,000D,001B,C977,C9C2
$AA:8954             dx 0001, FFF3,FFE5,000D,001B,C977,C9C2
$AA:8962             dx 0001, FFF2,FFE0,000D,0021,C977,C9C2
$AA:8970             dx 0001, FFF2,FFDD,000B,0027,C977,C9C2
$AA:897E             dx 0001, FFFA,FFD6,000D,002F,C977,C9C2
$AA:898C             dx 0001, FFF9,FFD7,000B,002F,C977,C9C2
$AA:899A             dx 0001, FFF8,FFD7,0016,002F,C977,C9C2

$AA:89A8             dx 0001, FFF6,FFDA,000D,0017,C977,C97C
$AA:89B6             dx 0000
$AA:89B8             dx 0000
$AA:89BA             dx 0001, 0000,002B,0016,0040,C977,C9C1 ; Unused
$AA:89C8             dx 0000
$AA:89CA             dx 0001, 000A,0026,001F,003C,C977,C9C1 ; Unused
$AA:89D8             dx 0000
$AA:89DA             dx 0001, 0014,0018,0022,0025,C977,C9C1 ; Unused
$AA:89E8             dx 0000
$AA:89EA             dx 0001, 0015,0008,003B,0014,C977,C9C1 ; Unused
$AA:89F8             dx 0000
$AA:89FA             dx 0001, 0017,FFF9,002D,0004,C977,C9C1 ; Unused
$AA:8A08             dx 0000
$AA:8A0A             dx 0001, 000F,FFDB,001C,FFED,C977,C9C1 ; Unused
$AA:8A18             dx 0000
$AA:8A1A             dx 0000
$AA:8A1C             dx 0001, FFFF,0027,000F,003B,C977,C9C1 ; Unused
$AA:8A2A             dx 0000
$AA:8A2C             dx 0001, 0009,0023,001A,0034,C977,C9C1 ; Unused
$AA:8A3A             dx 0000
$AA:8A3C             dx 0001, 0016,0018,0023,0024,C977,C9C1 ; Unused
$AA:8A4A             dx 0000
$AA:8A4C             dx 0001, 0016,0007,0034,0012,C977,C9C1 ; Unused
$AA:8A5A             dx 0000
$AA:8A5C             dx 0001, 0018,FFF6,002C,0005,C977,C9C1 ; Unused
$AA:8A6A             dx 0000
$AA:8A6C             dx 0001, 000F,FFDA,001C,FFF1,C977,C9C1 ; Unused
$AA:8A7A             dx 0001, FFF8,FFDB,000F,000E,C977,C97C
$AA:8A88             dx 0001, FFF7,FFD8,0010,0019,C977,C97C
}


;;; $8A96: Torizo spritemaps ;;;
{
$AA:8A96             dx 0004, 000C,F4,23CB, 0004,F4,23CA, 81F4,F4,23C8, 81F4,04,23E8
$AA:8AAC             dx 0004, 01F8,04,23DB, 01F0,04,23DA, 8000,F4,23C6, 81F0,F4,23C4
$AA:8AC2             dx 0003, 81E8,FC,23C0, 8000,F4,23C6, 81F0,F4,23C4
$AA:8AD3             dx 0003, 81E8,FC,23C2, 8000,F4,23C6, 81F0,F4,23C4
$AA:8AE4             dx 0003, 81E8,FC,23E0, 8000,F4,23C6, 81F0,F4,23C4
$AA:8AF5             dx 0008, 01E0,F4,2372, 01E8,F4,2371, 01F0,0C,23F2, 01F0,04,23F3, 01F0,FC,23E3, 01E8,FC,23E2, 8000,F4,23C6, 81F0,F4,23C4
$AA:8B1F             dx 0013, 01F5,18,234C, 0003,18,634C, 01FC,00,635F, 01F8,D8,239F, 01F5,28,23DF, 01F5,20,23CF, 01F5,10,239E, 01F6,08,23DE, 01F7,00,23CE, 81F0,F0,23E6, 81F0,E0,23E4, 0000,D8,639F, 0003,28,63DF, 0003,20,63CF, 0003,10,639E, 0002,08,63DE, 0001,00,63CE, 8000,F0,63E6, 8000,E0,63E4
$AA:8B80             dx 001B, 0000,F8,63DC, 0000,F0,63CC, 01F8,F8,23DC, 01F8,F0,23CC, 0003,18,634C, 01F5,18,234C, 01F0,E8,23F4, 01F0,E0,23E4, 0000,E8,63DD, 0000,E0,63CD, 01F8,E8,23DD, 01F8,E0,23CD, 0008,E8,63F4, 0008,E0,63E4, 01FC,00,635F, 01F5,28,23DF, 01F5,20,23CF, 01F5,10,239E, 01F6,08,23DE, 01F7,00,23CE, 81F0,F0,23E6, 0003,28,63DF, 0003,20,63CF, 0003,10,639E, 0002,08,63DE, 0001,00,63CE, 8000,F0,63E6
$AA:8C09             dx 0001, 01FC,FC,6B70
$AA:8C10             dx 0001, 01FC,FC,6B63
$AA:8C17             dx 0001, 01FC,FC,6B67
$AA:8C1E             dx 0001, 01FC,FC,6B6A
$AA:8C25             dx 0001, 81F8,F8,6B2E ; Unused
$AA:8C2C             dx 0001, 81F8,F8,2304 ; Unused
$AA:8C33             dx 001A, 01E9,FA,23FB, 01E1,FA,23FA, 81FC,EE,2328, 81F8,FB,6308, 01F2,15,2362, 01EA,15,2361, 01E2,15,2360, 81E7,F7,E358, 81EF,FF,E347, 01F9,12,2394, 01F1,12,2393, 81F1,02,2373, 0005,16,23EF, 000D,16,23FC, 000D,0E,23FF, 81FD,06,23ED, 0007,E3,23CB, 01FF,E3,23CA, 81EF,E3,23C8, 81EF,F3,23E8, 8008,06,2342, 81F8,06,2340, 8008,F6,2322, 81F8,F6,2320, 8008,E6,2302, 81F8,E6,2300
$AA:8CB7             dx 001A, 81FD,F9,2306, 81FD,EC,2326, 01E3,03,638F, 01EB,03,638E, 01EF,04,634F, 01F7,04,634E, 01FF,04,634D, 01FB,10,2396, 01F3,10,2395, 81F3,00,2375, 0002,01,A3AE, 01FA,01,A3AD, 81FA,09,A3A6, 01FB,15,2362, 01F3,15,2361, 01EB,15,2360, 0006,E4,23CB, 01FE,E4,23CA, 81EE,E4,23C8, 81EE,F4,23E8, 8007,07,2342, 81F7,07,2340, 8007,F7,2322, 81F7,F7,2320, 8007,E7,2302, 81F7,E7,2300
$AA:8D3B             dx 001B, 81E7,0D,636C, 81FA,F4,2306, 81FA,E7,2326, 81EE,07,6358, 81F5,FF,6347, 01FB,16,2398, 01F3,16,2397, 81F3,06,2377, 0001,1B,2362, 01F9,1B,2361, 01F1,1B,2360, 0007,0B,A3EC, 01FF,0B,A3EB, 01F7,0B,A3EA, 0007,03,23EC, 01FF,03,23EB, 01F7,03,23EA, 0006,DE,23CB, 01FE,DE,23CA, 81EE,DE,23C8, 81EE,EE,23E8, 8007,01,2342, 81F7,01,2340, 8007,F1,2322, 81F7,F1,2320, 8007,E1,2302, 81F7,E1,2300
$AA:8DC4             dx 0019, 81FB,F1,2306, 81FB,E4,2326, 81E6,0A,636C, 81ED,05,6358, 81F4,FD,6347, 8002,FB,23A9, 0002,0B,23BB, 01FA,0B,23AF, 81FA,FB,23A8, 0006,D9,23CB, 01FE,D9,23CA, 81EE,D9,23C8, 81EE,E9,23E8, 8007,FC,2342, 81F7,FC,2340, 8007,EC,2322, 81F7,EC,2320, 8007,DC,2302, 81F7,DC,2300, 0001,1B,2398, 01F9,1B,2397, 81F9,0B,2377, 0008,21,2362, 0000,21,2361, 01F8,21,2360
$AA:8E43             dx 0019, 01FD,D3,23CB, 01F5,D3,23CA, 81E5,E3,23E8, 81E5,D3,23C8, 0001,0F,23AC, 01F9,0F,23AB, 81F9,FF,23A4, 0003,28,2362, 01FB,28,2361, 01F3,28,2360, 0002,21,2396, 01FA,21,2395, 81FA,11,2375, 01FB,0E,25AE, 01F3,0E,25AD, 81F3,FE,25A6, 81FD,15,258A, 81F5,0D,2579, 81FF,1F,25A2, 81FE,F7,2342, 81EE,F7,2340, 81FE,E7,2322, 81EE,E7,2320, 81FE,D7,2302, 81EE,D7,2300
$AA:8EC2             dx 001A, 01FD,D4,23CB, 01F5,D4,23CA, 81E5,E4,23E8, 81E5,D4,23C8, 01FC,0E,63AE, 0004,0E,63AD, 81FC,FE,63A6, 0013,28,2362, 000B,28,2361, 0003,28,2360, 000D,22,2398, 0005,22,2397, 8005,12,2377, 81F6,FC,25A9, 01F6,0C,25BB, 01EE,0C,25AF, 81EE,FC,25A8, 81F2,1F,25A2, 01EF,1F,2597, 81EF,0F,2577, 81FE,F8,2342, 81EE,F8,2340, 81FE,E8,2322, 81EE,E8,2320, 81FE,D8,2302, 81EE,D8,2300
$AA:8F46             dx 001C, 01FD,D5,23CB, 01F5,D5,23CA, 81E5,E5,23E8, 81E5,D5,23C8, 001A,28,2362, 0012,28,2361, 000A,28,2360, 01FD,10,63AE, 0005,10,63AD, 81FD,00,63A6, 800F,1C,238A, 8007,14,2379, 01EB,28,2562, 01E3,28,2561, 01DB,28,2560, 81F7,FE,25A9, 01F7,0E,25BB, 01EF,0E,25AF, 81EF,FE,25A8, 01EF,22,2594, 01E7,22,2593, 81E7,12,2573, 81FE,F9,2342, 81EE,F9,2340, 81FE,E9,2322, 81EE,E9,2320, 81FE,D9,2302, 81EE,D9,2300
$AA:8FD4             dx 0016, 01EB,28,2362, 01E3,28,2361, 01DB,28,2360, 81F7,FE,23A9, 01F7,0E,23BB, 01EF,0E,23AF, 81EF,FE,23A8, 01EF,22,2394, 01E7,22,2393, 81E7,12,2373, 01FC,0D,65AE, 0004,0D,65AD, 81FC,FD,65A6, 800D,16,258A, 8005,0E,2579, 8013,1F,25A0, 81FE,F9,2342, 81EE,F9,2340, 81FE,E9,2322, 81EE,E9,2320, 81FE,D9,2302, 81EE,D9,2300
$AA:9044             dx 0015, 01FB,0F,23AE, 01F3,0F,23AD, 81F3,FF,23A6, 01F0,28,2362, 01E8,28,2361, 01E0,28,2360, 01F4,23,2394, 01EC,23,2393, 81EC,13,2373, 8009,1E,25A0, 01FF,10,25AC, 01F7,10,25AB, 81F7,00,25A4, 8005,18,258A, 81FD,10,2579, 81FE,F8,2342, 81EE,F8,2340, 81FE,E8,2322, 81EE,E8,2320, 81FE,D8,2302, 81EE,D8,2300
$AA:90AF             dx 0015, 0001,0F,23AC, 01F9,0F,23AB, 81F9,FF,23A4, 0003,28,2362, 01FB,28,2361, 01F3,28,2360, 0002,21,2396, 01FA,21,2395, 81FA,11,2375, 01FB,0E,25AE, 01F3,0E,25AD, 81F3,FE,25A6, 81FD,15,258A, 81F5,0D,2579, 81FF,1F,25A2, 81FE,F7,2342, 81EE,F7,2340, 81FE,E7,2322, 81EE,E7,2320, 81FE,D7,2302, 81EE,D7,2300
$AA:911A             dx 0016, 01FC,0E,63AE, 0004,0E,63AD, 81FC,FE,63A6, 0013,28,2362, 000B,28,2361, 0003,28,2360, 000D,22,2398, 0005,22,2397, 8005,12,2377, 81F6,FC,25A9, 01F6,0C,25BB, 01EE,0C,25AF, 81EE,FC,25A8, 81F2,1F,25A2, 01EF,1F,2597, 81EF,0F,2577, 81FE,F8,2342, 81EE,F8,2340, 81FE,E8,2322, 81EE,E8,2320, 81FE,D8,2302, 81EE,D8,2300
$AA:918A             dx 0016, 01FC,0E,63AE, 0004,0E,63AD, 81FC,FE,63A6, 800D,17,238A, 8005,0F,2379, 8013,20,23A0, 01EB,28,2562, 01E3,28,2561, 01DB,28,2560, 81F7,FE,25A9, 01F7,0E,25BB, 01EF,0E,25AF, 81EF,FE,25A8, 01EF,22,2594, 01E7,22,2593, 81E7,12,2573, 81FE,F9,2342, 81EE,F9,2340, 81FE,E9,2322, 81EE,E9,2320, 81FE,D9,2302, 81EE,D9,2300
$AA:91FA             dx 0015, 800A,1D,23A0, 0000,0F,23AC, 01F8,0F,23AB, 81F8,FF,23A4, 8006,17,238A, 81FE,0F,2379, 01FD,0F,25AE, 01F5,0F,25AD, 81F5,FF,25A6, 01F2,28,2562, 01EA,28,2561, 01E2,28,2560, 01F6,23,2594, 01EE,23,2593, 81EE,13,2573, 81FE,F8,2342, 81EE,F8,2340, 81FE,E8,2322, 81EE,E8,2320, 81FE,D8,2302, 81EE,D8,2300
$AA:9265             dx 0015, 01FB,0E,23AE, 01F3,0E,23AD, 81F3,FE,23A6, 81FD,15,238A, 81F5,0D,2379, 81FF,1F,23A2, 0001,0F,25AC, 01F9,0F,25AB, 81F9,FF,25A4, 0003,28,2562, 01FB,28,2561, 01F3,28,2560, 0002,21,2596, 01FA,21,2595, 81FA,11,2575, 81FE,F7,2342, 81EE,F7,2340, 81FE,E7,2322, 81EE,E7,2320, 81FE,D7,2302, 81EE,D7,2300
$AA:92D0             dx 0016, 81F7,FC,23A9, 01F7,0C,23BB, 01EF,0C,23AF, 81EF,FC,23A8, 81F3,1F,23A2, 01F0,1F,2397, 81F0,0F,2377, 01FE,0E,65AE, 0006,0E,65AD, 81FE,FE,65A6, 0015,28,2562, 000D,28,2561, 0005,28,2560, 000F,22,2598, 0007,22,2597, 8007,12,2577, 81FE,F8,2342, 81EE,F8,2340, 81FE,E8,2322, 81EE,E8,2320, 81FE,D8,2302, 81EE,D8,2300
$AA:9340             dx 0007, 0010,25,637B, 0010,1D,636B, 8005,FB,230C, 0010,16,2364, 0010,0E,2354, 0010,06,2344, 81F8,F8,632A
$AA:9365             dx 0005, 81FA,23,236C, 8001,02,230A, 0002,1F,6366, 8002,0F,6345, 81F8,F8,2324
$AA:9380             dx 0005, 81F0,28,236C, 01F9,24,6366, 81F9,14,6345, 81FC,05,2308, 81F8,F8,6328
$AA:939B             dx 0005, 81E7,24,236C, 81F8,06,2306, 81EC,1B,6358, 81F4,13,6347, 81F8,F8,2326
$AA:93B6             dx 0005, 81DE,19,236C, 81F4,05,6308, 01E4,16,635C, 81EC,0E,634A, 81F8,F8,2328
$AA:93D1             dx 0007, 81EF,02,630A, 01CE,0B,638F, 01D6,0B,638E, 01DA,0B,634F, 01E2,0B,634E, 01EA,0B,634D, 81F8,F8,6324
$AA:93F6             dx 0005, 81D4,F6,E36E, 81EF,02,630A, 81DB,FA,E358, 81E3,02,E347, 81F8,F8,6324
$AA:9411             dx 0007, 01E6,DD,A37B, 01E6,E5,A36B, 81EA,F8,630E, 01E6,EB,E364, 01E6,F3,E354, 01E6,FB,E344, 81F8,F8,232A
$AA:9436             dx 0007, 000F,25,657B, 000F,1D,656B, 8005,FB,250C, 0010,16,2564, 0010,0E,2554, 0010,06,2544, 81F8,F8,652A
$AA:945B             dx 0005, 81FA,23,256C, 8001,02,250A, 0002,1F,6566, 8002,0F,6545, 81F8,F8,2524
$AA:9476             dx 0005, 81F0,28,256C, 01F9,24,6566, 81F9,14,6545, 81FC,05,2508, 81F8,F8,6528
$AA:9491             dx 0005, 81E6,23,256C, 81F8,06,2506, 81EC,1B,6558, 81F4,13,6547, 81F8,F8,2526
$AA:94AC             dx 0005, 81DC,19,256C, 81F4,05,6508, 01E4,16,655C, 81EC,0E,654A, 81F8,F8,2528
$AA:94C7             dx 0007, 81EF,02,650A, 01CB,0B,658F, 01D3,0B,658E, 01DA,0B,654F, 01E2,0B,654E, 01EA,0B,654D, 81F8,F8,6524
$AA:94EC             dx 0005, 81D3,F4,E56E, 81EF,02,650A, 81DB,FA,E558, 81E3,02,E547, 81F8,F8,6524
$AA:9507             dx 0007, 01E6,DD,A57B, 01E6,E5,A56B, 81EA,F8,650E, 01E6,EB,E564, 01E6,F3,E554, 01E6,FB,E544, 81F8,F8,252A
$AA:952C             dx 0018, 81EE,F3,2330, 81F9,FD,23A9, 01F9,0D,23BB, 01F1,0D,23AF, 81F1,FD,23A8, 81FA,15,238A, 81F2,0D,2379, 0005,20,2362, 01FD,20,2361, 01F5,20,2360, 81F5,FD,25A9, 01F5,0D,25BB, 01ED,0D,25AF, 81ED,FD,25A8, 81F6,15,258A, 81EE,0D,2579, 0001,20,2562, 01F9,20,2561, 01F1,20,2560, 81EE,E3,2310, 81FE,FB,2342, 81FE,EB,2322, 81FE,DB,2302, 81EE,DB,2300
$AA:95A6             dx 0013, 81EE,F2,2330, 01FC,0F,23AE, 01F4,0F,23AD, 81F4,FF,23A6, 8002,22,23A0, 81FD,19,238A, 81F5,11,2379, 81EE,FA,2340, 81EE,E2,2310, 81FE,FA,2342, 81FE,EA,2322, 81FE,DA,2302, 81EE,DA,2300, 01F8,10,65AC, 0000,10,65AB, 81F8,00,65A4, 8009,24,25A0, 8004,1B,258A, 81FC,13,2579
$AA:9607             dx 0015, 81EE,F2,2330, 8003,27,23A2, 8006,27,23A2, 01F8,10,23AB, 0000,10,23AC, 81F8,00,23A4, 81FD,13,2377, 0005,23,2398, 01FD,23,2397, 01FB,10,25AB, 0003,10,25AC, 81FB,00,25A4, 8000,13,2577, 0008,23,2598, 0000,23,2597, 81EE,FA,2340, 81EE,E2,2310, 81FE,FA,2342, 81FE,EA,2322, 81FE,DA,2302, 81EE,DA,2300
$AA:9672             dx 0018, 001A,28,2562, 0012,28,2561, 000A,28,2560, 01EB,28,2362, 01E3,28,2361, 01DB,28,2360, 81F7,FE,23A9, 01F7,0E,23BB, 01EF,0E,23AF, 81EF,FE,23A8, 01EF,22,2394, 01E7,22,2393, 81E7,12,2373, 01FD,10,65AE, 0005,10,65AD, 81FD,00,65A6, 800F,1C,258A, 8007,14,2579, 81FE,F9,2342, 81EE,F9,2340, 81FE,E9,2322, 81EE,E9,2320, 81FE,D9,2302, 81EE,D9,2300
$AA:96EC             dx 0018, 001A,28,2362, 0012,28,2361, 000A,28,2360, 01FD,10,63AE, 0005,10,63AD, 81FD,00,63A6, 800F,1C,238A, 8007,14,2379, 01EB,28,2562, 01E3,28,2561, 01DB,28,2560, 81F7,FE,25A9, 01F7,0E,25BB, 01EF,0E,25AF, 81EF,FE,25A8, 01EF,22,2594, 01E7,22,2593, 81E7,12,2573, 81FE,F9,2342, 81EE,F9,2340, 81FE,E9,2322, 81EE,E9,2320, 81FE,D9,2302, 81EE,D9,2300
$AA:9766             dx 0006, 8000,0C,2342, 81F0,0C,2340, 8000,FC,2322, 81F0,FC,2320, 8000,EC,2302, 81F0,EC,2300 ; Unused
$AA:9786             dx 0004, 01EC,F4,63CB, 01F4,F4,63CA, 81FC,F4,63C8, 81FC,04,63E8
$AA:979C             dx 0004, 0000,04,63DB, 0008,04,63DA, 81F0,F4,63C6, 8000,F4,63C4
$AA:97B2             dx 0003, 8008,FC,63C0, 81F0,F4,63C6, 8000,F4,63C4
$AA:97C3             dx 0003, 8008,FC,63C2, 81F0,F4,63C6, 8000,F4,63C4
$AA:97D4             dx 0003, 8008,FC,63E0, 81F0,F4,63C6, 8000,F4,63C4
$AA:97E5             dx 0008, 0018,F4,6372, 0010,F4,6371, 0008,0C,63F2, 0008,04,63F3, 0008,FC,63E3, 0010,FC,63E2, 81F0,F4,63C6, 8000,F4,63C4
$AA:980F             dx 0013, 01F5,10,234C, 0003,10,634C, 01FC,F8,635F, 01F8,D0,239F, 01F5,20,23DF, 01F5,18,23CF, 01F5,08,239E, 01F6,00,23DE, 01F7,F8,23CE, 81F0,E8,23E6, 81F0,D8,23E4, 0000,D0,639F, 0003,20,63DF, 0003,18,63CF, 0003,08,639E, 0002,00,63DE, 0001,F8,63CE, 8000,E8,63E6, 8000,D8,63E4 ; Unused
$AA:9870             dx 001B, 0000,F0,63DC, 0000,E8,63CC, 01F8,F0,23DC, 01F8,E8,23CC, 0003,10,634C, 01F5,10,234C, 01F0,E0,23F4, 01F0,D8,23E4, 0000,E0,63DD, 0000,D8,63CD, 01F8,E0,23DD, 01F8,D8,23CD, 0008,E0,63F4, 0008,D8,63E4, 01FC,F8,635F, 01F5,20,23DF, 01F5,18,23CF, 01F5,08,239E, 01F6,00,23DE, 01F7,F8,23CE, 81F0,E8,23E6, 0003,20,63DF, 0003,18,63CF, 0003,08,639E, 0002,00,63DE, 0001,F8,63CE, 8000,E8,63E6 ; Unused
$AA:98F9             dx 0001, 01FC,FC,6B70 ; Unused
$AA:9900             dx 0001, 01FC,FC,6B63 ; Unused
$AA:9907             dx 0001, 01FC,FC,6B67 ; Unused
$AA:990E             dx 0001, 01FC,FC,6B6A ; Unused
$AA:9915             dx 0001, 81F8,F8,672C ; Unused
$AA:991C             dx 0001, 81F8,F8,6B2E ; Unused
$AA:9923             dx 0001, 81F8,F8,6304 ; Unused
$AA:992A             dx 0006, 01F8,08,EB52, 0000,08,AB52, 01F8,F8,2B92, 01F8,F0,2B82, 0000,F8,6B92, 0000,F0,6B82 ; Unused
$AA:994A             dx 001A, 000F,FA,63FB, 0017,FA,63FA, 0017,FA,63FA, 81F4,EE,6328, 81F8,FB,2308, 0006,15,6362, 000E,15,6361, 0016,15,6360, 8009,F7,A358, 8001,FF,A347, 01FF,12,6394, 0007,12,6393, 81FF,02,6373, 01F3,16,63EF, 01EB,16,63FC, 01EB,0E,63FF, 81F3,06,63ED, 01F1,E3,63CB, 01F9,E3,63CA, 8001,E3,63C8, 8001,F3,63E8, 81E8,06,6342, 81F8,06,6340, 81E8,F6,6322, 81F8,F6,6320, 81E8,E6,6302
$AA:99CE             dx 81F8,E6,6300 ; Unused spritemap entry
$AA:99D3             dx 001A, 81F3,F9,6306, 81F3,EC,6326, 0015,03,238F, 000D,03,238E, 0009,04,234F, 0001,04,234E, 01F9,04,234D, 01FD,10,6396, 0005,10,6395, 81FD,00,6375, 01F6,01,E3AE, 01FE,01,E3AD, 81F6,09,E3A6, 01FD,15,6362, 0005,15,6361, 000D,15,6360, 01F2,E4,63CB, 01FA,E4,63CA, 8002,E4,63C8, 8002,F4,63E8, 81E9,07,6342, 81F9,07,6340, 81E9,F7,6322, 81F9,F7,6320, 81E9,E7,6302, 81F9,E7,6300
$AA:9A57             dx 001B, 8009,0D,236C, 81F6,F4,6306, 81F6,E7,6326, 8002,07,2358, 81FB,FF,2347, 01FD,16,6398, 0005,16,6397, 81FD,06,6377, 01F7,1B,6362, 01FF,1B,6361, 0007,1B,6360, 01F1,0B,E3EC, 01F9,0B,E3EB, 0001,0B,E3EA, 01F1,03,63EC, 01F9,03,63EB, 0001,03,63EA, 01F2,DE,63CB, 01FA,DE,63CA, 8002,DE,63C8, 8002,EE,63E8, 81E9,01,6342, 81F9,01,6340, 81E9,F1,6322, 81F9,F1,6320, 81E9,E1,6302, 81F9,E1,6300
$AA:9AE0             dx 0019, 81F5,F1,6306, 81F5,E4,6326, 800A,0A,236C, 8003,05,2358, 81FC,FD,2347, 81EE,FB,63A9, 01F6,0B,63BB, 01FE,0B,63AF, 81F6,FB,63A8, 01F2,D9,63CB, 01FA,D9,63CA, 8002,D9,63C8, 8002,E9,63E8, 81E9,FC,6342, 81F9,FC,6340, 81E9,EC,6322, 81F9,EC,6320, 81E9,DC,6302, 81F9,DC,6300, 01F7,1B,6398, 01FF,1B,6397, 81F7,0B,6377, 01F0,21,6362, 01F8,21,6361, 0000,21,6360
$AA:9B5F             dx 0019, 01FB,D3,63CB, 0003,D3,63CA, 800B,E3,63E8, 800B,D3,63C8, 01F7,0F,63AC, 01FF,0F,63AB, 81F7,FF,63A4, 01F5,28,6362, 01FD,28,6361, 0005,28,6360, 01F6,21,6396, 01FE,21,6395, 81F6,11,6375, 01FD,0E,65AE, 0005,0E,65AD, 81FD,FE,65A6, 81F3,15,658A, 81FB,0D,6579, 81F1,1F,65A2, 81F2,F7,6342, 8002,F7,6340, 81F2,E7,6322, 8002,E7,6320, 81F2,D7,6302, 8002,D7,6300
$AA:9BDE             dx 001A, 01FB,D4,63CB, 0003,D4,63CA, 800B,E4,63E8, 800B,D4,63C8, 01FC,0E,23AE, 01F4,0E,23AD, 81F4,FE,23A6, 01E5,28,6362, 01ED,28,6361, 01F5,28,6360, 01EB,22,6398, 01F3,22,6397, 81EB,12,6377, 81FA,FC,65A9, 0002,0C,65BB, 000A,0C,65AF, 8002,FC,65A8, 81FE,1F,65A2, 0009,1F,6597, 8001,0F,6577, 81F2,F8,6342, 8002,F8,6340, 81F2,E8,6322, 8002,E8,6320, 81F2,D8,6302, 8002,D8,6300
$AA:9C62             dx 001C, 01FB,D5,63CB, 0003,D5,63CA, 800B,E5,63E8, 800B,D5,63C8, 01DE,28,6362, 01E6,28,6361, 01EE,28,6360, 01FB,10,23AE, 01F3,10,23AD, 81F3,00,23A6, 81E1,1C,638A, 81E9,14,6379, 000D,28,6562, 0015,28,6561, 001D,28,6560, 81F9,FE,65A9, 0001,0E,65BB, 0009,0E,65AF, 8001,FE,65A8, 0009,22,6594, 0011,22,6593, 8009,12,6573, 81F2,F9,6342, 8002,F9,6340, 81F2,E9,6322, 8002,E9,6320, 81F2,D9,6302, 8002,D9,6300
$AA:9CF0             dx 0002, 01F8,FC,2B80, 0000,FC,6B80 ; Unused
$AA:9CFC             dx 0004, 01F8,00,2B90, 01F8,F8,2B80, 0000,00,6B90, 0000,F8,6B80 ; Unused
$AA:9D12             dx 0003, 81F8,F4,6B80, 01F8,04,2B99, 0000,04,6B99 ; Unused
$AA:9D23             dx 0003, 0000,06,6B80, 01F8,06,2B80, 81F8,F2,2B2E ; Unused
$AA:9D34             dx 0016, 000D,28,6362, 0015,28,6361, 001D,28,6360, 81F9,FE,63A9, 0001,0E,63BB, 0009,0E,63AF, 8001,FE,63A8, 0009,22,6394, 0011,22,6393, 8009,12,6373, 01FC,0D,25AE, 01F4,0D,25AD, 81F4,FD,25A6, 81E3,16,658A, 81EB,0E,6579, 81DD,1F,65A0, 81F2,F9,6342, 8002,F9,6340, 81F2,E9,6322, 8002,E9,6320, 81F2,D9,6302, 8002,D9,6300
$AA:9DA4             dx 0015, 01FD,0F,63AE, 0005,0F,63AD, 81FD,FF,63A6, 0008,28,6362, 0010,28,6361, 0018,28,6360, 0004,23,6394, 000C,23,6393, 8004,13,6373, 81E7,1E,65A0, 01F9,10,65AC, 0001,10,65AB, 81F9,00,65A4, 81EB,18,658A, 81F3,10,6579, 81F2,F8,6342, 8002,F8,6340, 81F2,E8,6322, 8002,E8,6320, 81F2,D8,6302, 8002,D8,6300
$AA:9E0F             dx 0015, 01F7,0F,63AC, 01FF,0F,63AB, 81F7,FF,63A4, 01F5,28,6362, 01FD,28,6361, 0005,28,6360, 01F6,21,6396, 01FE,21,6395, 81F6,11,6375, 01FD,0E,65AE, 0005,0E,65AD, 81FD,FE,65A6, 81F3,15,658A, 81FB,0D,6579, 81F1,1F,65A2, 81F2,F7,6342, 8002,F7,6340, 81F2,E7,6322, 8002,E7,6320, 81F2,D7,6302, 8002,D7,6300
$AA:9E7A             dx 0016, 01FC,0E,23AE, 01F4,0E,23AD, 81F4,FE,23A6, 01E5,28,6362, 01ED,28,6361, 01F5,28,6360, 01EB,22,6398, 01F3,22,6397, 81EB,12,6377, 81FA,FC,65A9, 0002,0C,65BB, 000A,0C,65AF, 8002,FC,65A8, 81FE,1F,65A2, 0009,1F,6597, 8001,0F,6577, 81F2,F8,6342, 8002,F8,6340, 81F2,E8,6322, 8002,E8,6320, 81F2,D8,6302, 8002,D8,6300
$AA:9EEA             dx 0016, 01FC,0E,23AE, 01F4,0E,23AD, 81F4,FE,23A6, 81E3,17,638A, 81EB,0F,6379, 81DD,20,63A0, 000D,28,6562, 0015,28,6561, 001D,28,6560, 81F9,FE,65A9, 0001,0E,65BB, 0009,0E,65AF, 8001,FE,65A8, 0009,22,6594, 0011,22,6593, 8009,12,6573, 81F2,F9,6342, 8002,F9,6340, 81F2,E9,6322, 8002,E9,6320, 81F2,D9,6302, 8002,D9,6300
$AA:9F5A             dx 0015, 81E6,1D,63A0, 01F8,0F,63AC, 0000,0F,63AB, 81F8,FF,63A4, 81EA,17,638A, 81F2,0F,6379, 01FB,0F,65AE, 0003,0F,65AD, 81FB,FF,65A6, 0006,28,6562, 000E,28,6561, 0016,28,6560, 0002,23,6594, 000A,23,6593, 8002,13,6573, 81F2,F8,6342, 8002,F8,6340, 81F2,E8,6322, 8002,E8,6320, 81F2,D8,6302, 8002,D8,6300
$AA:9FC5             dx 0015, 01FD,0E,63AE, 0005,0E,63AD, 81FD,FE,63A6, 81F3,15,638A, 81FB,0D,6379, 81F1,1F,63A2, 01F7,0F,65AC, 01FF,0F,65AB, 81F7,FF,65A4, 01F5,28,6562, 01FD,28,6561, 0005,28,6560, 01F6,21,6596, 01FE,21,6595, 81F6,11,6575, 81F2,F7,6342, 8002,F7,6340, 81F2,E7,6322, 8002,E7,6320, 81F2,D7,6302, 8002,D7,6300
$AA:A030             dx 0016, 81F9,FC,63A9, 0001,0C,63BB, 0009,0C,63AF, 8001,FC,63A8, 81FD,1F,63A2, 0008,1F,6397, 8000,0F,6377, 01FA,0E,25AE, 01F2,0E,25AD, 81F2,FE,25A6, 01E3,28,6562, 01EB,28,6561, 01F3,28,6560, 01E9,22,6598, 01F1,22,6597, 81E9,12,6577, 81F2,F8,6342, 8002,F8,6340, 81F2,E8,6322, 8002,E8,6320, 81F2,D8,6302, 8002,D8,6300
$AA:A0A0             dx 0007, 01E8,25,237B, 01E8,1D,236B, 81EB,FB,630C, 01E8,16,6364, 01E8,0E,6354, 01E8,06,6344, 81F8,F8,232A
$AA:A0C5             dx 0005, 81F6,23,636C, 81EF,02,630A, 01F6,1F,2366, 81EE,0F,2345, 81F8,F8,6324
$AA:A0E0             dx 0005, 8000,28,636C, 01FF,24,2366, 81F7,14,2345, 81F4,05,6308, 81F8,F8,2328
$AA:A0FB             dx 0005, 8009,24,636C, 81F8,06,6306, 8004,1B,2358, 81FC,13,2347, 81F8,F8,6326
$AA:A116             dx 0005, 8012,19,636C, 81FC,05,2308, 0014,16,235C, 8004,0E,234A, 81F8,F8,6328
$AA:A131             dx 0007, 8001,02,230A, 002A,0B,238F, 0022,0B,238E, 001E,0B,234F, 0016,0B,234E, 000E,0B,234D, 81F8,F8,2324
$AA:A156             dx 0005, 801C,F6,A36E, 8001,02,230A, 8015,FA,A358, 800D,02,A347, 81F8,F8,2324
$AA:A171             dx 0007, 0012,DD,E37B, 0012,E5,E36B, 8006,F8,230E, 0012,EB,A364, 0012,F3,A354, 0012,FB,A344, 81F8,F8,632A
$AA:A196             dx 0007, 01E9,25,257B, 01E9,1D,256B, 81EB,FB,650C, 01E8,16,6564, 01E8,0E,6554, 01E8,06,6544, 81F8,F8,252A
$AA:A1BB             dx 0005, 81F6,23,656C, 81EF,02,650A, 01F6,1F,2566, 81EE,0F,2545, 81F8,F8,6524
$AA:A1D6             dx 0005, 8000,28,656C, 01FF,24,2566, 81F7,14,2545, 81F4,05,6508, 81F8,F8,2528
$AA:A1F1             dx 0005, 800A,23,656C, 81F8,06,6506, 8004,1B,2558, 81FC,13,2547, 81F8,F8,6526
$AA:A20C             dx 0005, 8014,19,656C, 81FC,05,2508, 0014,16,255C, 8004,0E,254A, 81F8,F8,6528
$AA:A227             dx 0007, 8001,02,250A, 002D,0B,258F, 0025,0B,258E, 001E,0B,254F, 0016,0B,254E, 000E,0B,254D, 81F8,F8,2524
$AA:A24C             dx 0005, 801D,F4,A56E, 8001,02,250A, 8015,FA,A558, 800D,02,A547, 81F8,F8,2524
$AA:A267             dx 0007, 0012,DD,E57B, 0012,E5,E56B, 8006,F8,250E, 0012,EB,A564, 0012,F3,A554, 0012,FB,A544, 81F8,F8,652A
$AA:A28C             dx 0018, 8002,F3,6330, 81F7,FD,63A9, 01FF,0D,63BB, 0007,0D,63AF, 81FF,FD,63A8, 81F6,15,638A, 81FE,0D,6379, 01F3,20,6362, 01FB,20,6361, 0003,20,6360, 81FB,FD,65A9, 0003,0D,65BB, 000B,0D,65AF, 8003,FD,65A8, 81FA,15,658A, 8002,0D,6579, 01F7,20,6562, 01FF,20,6561, 0007,20,6560, 8002,E3,6310, 81F2,FB,6342, 81F2,EB,6322, 81F2,DB,6302, 8002,DB,6300
$AA:A306             dx 0013, 8002,F2,6330, 01FC,0F,63AE, 0004,0F,63AD, 81FC,FF,63A6, 81EE,22,63A0, 81F3,19,638A, 81FB,11,6379, 8002,FA,6340, 8002,E2,6310, 81F2,FA,6342, 81F2,EA,6322, 81F2,DA,6302, 8002,DA,6300, 0000,10,25AC, 01F8,10,25AB, 81F8,00,25A4, 81E7,24,65A0, 81EC,1B,658A, 81F4,13,6579
$AA:A367             dx 0015, 8002,F2,6330, 81ED,27,63A2, 81EA,27,63A2, 0000,10,63AB, 01F8,10,63AC, 81F8,00,63A4, 81F3,13,6377, 01F3,23,6398, 01FB,23,6397, 01FD,10,65AB, 01F5,10,65AC, 81F5,00,65A4, 81F0,13,6577, 01F0,23,6598, 01F8,23,6597, 8002,FA,6340, 8002,E2,6310, 81F2,FA,6342, 81F2,EA,6322, 81F2,DA,6302, 8002,DA,6300
$AA:A3D2             dx 0018, 01DE,28,6562, 01E6,28,6561, 01EE,28,6560, 000D,28,6362, 0015,28,6361, 001D,28,6360, 81F9,FE,63A9, 0001,0E,63BB, 0009,0E,63AF, 8001,FE,63A8, 0009,22,6394, 0011,22,6393, 8009,12,6373, 01FB,10,25AE, 01F3,10,25AD, 81F3,00,25A6, 81E1,1C,658A, 81E9,14,6579, 81F2,F9,6342, 8002,F9,6340, 81F2,E9,6322, 8002,E9,6320, 81F2,D9,6302, 8002,D9,6300
$AA:A44C             dx 0018, 01DE,28,6362, 01E6,28,6361, 01EE,28,6360, 01FB,10,23AE, 01F3,10,23AD, 81F3,00,23A6, 81E1,1C,638A, 81E9,14,6379, 000D,28,6562, 0015,28,6561, 001D,28,6560, 81F9,FE,65A9, 0001,0E,65BB, 0009,0E,65AF, 8001,FE,65A8, 0009,22,6594, 0011,22,6593, 8009,12,6573, 81F2,F9,6342, 8002,F9,6340, 81F2,E9,6322, 8002,E9,6320, 81F2,D9,6302, 8002,D9,6300
$AA:A4C6             dx 0006, 81F0,0C,6342, 8000,0C,6340, 81F0,FC,6322, 8000,FC,6320, 81F0,EC,6302, 8000,EC,6300 ; Unused
}


;;; $A4E6: Torizo extended spritemaps ;;;
{
; Unused
$AA:A4E6             dx 0001, 0000,0000,8B80,87DA

; Facing screen (turning / dodging)
$AA:A4F0             dx 0001, 0000,0000,8B1F,87C7

; Walking left - right leg moving
$AA:A4FA             dx 0004, FFF1,FFE2,8A96,87C7, FFFB,FFE8,9340,8858, 0000,0000,9672,892A, FFFB,FFE8,94AC,88DC
$AA:A51C             dx 0004, FFF1,FFE2,8A96,87C7, FFFB,FFE7,9365,8858, 0000,0000,8FD4,884A, FFFB,FFE7,9491,88CC
$AA:A53E             dx 0004, FFF1,FFE1,8A96,87C7, FFFB,FFE6,9380,885A, 0000,0000,9044,884A, FFFB,FFE6,9476,88BC
$AA:A560             dx 0004, FFF1,FFE0,8A96,87C7, FFFB,FFE7,939B,886A, 0000,0000,90AF,884A, FFFB,FFE7,945B,88BA
$AA:A582             dx 0004, FFF1,FFE0,8A96,87C7, FFFB,FFE8,93B6,887A, 0000,0000,911A,884A, FFFB,FFE8,9436,88BA

; Walking left - left leg moving
$AA:A5A4             dx 0004, FFF1,FFE2,8A96,87C7, FFFB,FFE8,93B6,887A, 0000,0000,96EC,892A, FFFB,FFE8,9436,88BA
$AA:A5C6             dx 0004, FFF1,FFE1,8A96,87C7, FFFB,FFE7,939B,886A, 0000,0000,918A,884A, FFFB,FFE7,945B,88BA
$AA:A5E8             dx 0004, FFF1,FFE1,8A96,87C7, FFFB,FFE6,9380,885A, 0000,0000,91FA,884A, FFFB,FFE6,9476,88BC
$AA:A60A             dx 0004, FFF1,FFE0,8A96,87C7, FFFB,FFE7,9365,8858, 0000,0000,9265,884A, FFFB,FFE7,9491,88CC
$AA:A62C             dx 0004, FFF1,FFE1,8A96,87C7, FFFB,FFE8,9340,8858, 0000,0000,92D0,884A, FFFB,FFE8,94AC,88DC

; Spewing chozo orbs / sonic booms / explosive swipe / caught super missile - facing left - right foot forward
$AA:A64E             dx 0003, FFF1,FFE1,8A96,87C7, FFFC,FFE7,9380,885A, 0000,0000,96EC,892A

; Spewing chozo orbs - facing left - right foot forward
$AA:A668             dx 0003, FFF7,FFE1,8AAC,87C7, FFFC,FFE7,939B,886A, 0000,0000,96EC,892A
$AA:A682             dx 0003, FFF7,FFE1,8AC2,87C7, FFFC,FFE7,93B6,887A, 0000,0000,96EC,892A
$AA:A69C             dx 0003, FFF7,FFE1,8AD3,87C7, FFFC,FFE7,93D1,888A, 0000,0000,96EC,892A
$AA:A6B6             dx 0003, FFFC,FFE7,93F6,889A, FFF7,FFE1,8AE4,87C7, 0000,0000,96EC,892A
$AA:A6D0             dx 0003, FFFC,FFE7,93F6,889A, FFF7,FFE1,8AF5,87C7, 0000,0000,96EC,892A

; Spewing chozo orbs / sonic booms / explosive swipe / caught super missile - facing left - left foot forward
$AA:A6EA             dx 0003, FFF1,FFE1,8A96,87C7, FFFC,FFE7,9365,8858, 0000,0000,9672,892A

; Spewing chozo orbs - facing left - left foot forward
$AA:A704             dx 0003, FFF7,FFE1,8AAC,87C7, FFFC,FFE7,939B,886A, 0000,0000,9672,892A
$AA:A71E             dx 0003, FFF7,FFE1,8AC2,87C7, FFFC,FFE7,93B6,887A, 0000,0000,9672,892A
$AA:A738             dx 0003, FFF7,FFE1,8AD3,87C7, FFFC,FFE7,93D1,888A, 0000,0000,9672,892A
$AA:A752             dx 0003, FFFC,FFE7,93F6,889A, FFF7,FFE1,8AE4,87C7, 0000,0000,9672,892A
$AA:A76C             dx 0003, FFFC,FFE7,93F6,889A, FFF7,FFE1,8AF5,87C7, 0000,0000,9672,892A

; Sonic booms / explosive swipe / caught super missile - facing left - right foot forward
$AA:A786             dx 0003, FFF1,FFE1,8A96,87C7, FFFC,FFE7,939B,886A, 0000,0000,96EC,892A
$AA:A7A0             dx 0004, FFF1,FFE1,8A96,87C7, FFFC,FFE7,939B,886A, 0000,0000,96EC,892A, FFFC,FFE7,94AC,88DC
$AA:A7C2             dx 0004, FFFC,FFE7,939B,886A, FFF1,FFE1,8A96,87C7, 0000,0000,96EC,892A, FFFC,FFE7,94C7,88EC
$AA:A7E4             dx 0004, FFFC,FFE7,939B,886A, FFF1,FFE1,8A96,87C7, 0000,0000,96EC,892A, FFFC,FFE7,94EC,88FC
$AA:A806             dx 0004, FFFC,FFE7,939B,886A, FFF1,FFE1,8A96,87C7, 0000,0000,96EC,892A, FFFC,FFE7,9507,890C
$AA:A828             dx 0004, FFF1,FFE1,8A96,87C7, FFFC,FFE7,939B,886A, 0000,0000,96EC,892A, FFFC,FFE7,945B,88BA

; Sonic booms / explosive swipe - facing left - right foot forward
$AA:A84A             dx 0004, FFF1,FFE1,8A96,87C7, FFFC,FFE7,93B6,887A, 0000,0000,96EC,892A, FFFC,FFE7,945B,88BA
$AA:A86C             dx 0004, FFF1,FFE1,8A96,87C7, FFFC,FFE7,93D1,888A, 0000,0000,96EC,892A, FFFC,FFE7,945B,88BA
$AA:A88E             dx 0004, FFFC,FFE7,93F6,889A, FFF1,FFE1,8A96,87C7, 0000,0000,96EC,892A, FFFC,FFE7,945B,88BA
$AA:A8B0             dx 0004, FFFC,FFE7,9411,88AA, FFF1,FFE1,8A96,87C7, 0000,0000,96EC,892A, FFFC,FFE7,945B,88BA

; Sonic booms / explosive swipe / caught super missile - facing left - left foot forward
$AA:A8D2             dx 0003, FFF1,FFE1,8A96,87C7, FFFC,FFE7,939B,886A, 0000,0000,9672,892A
$AA:A8EC             dx 0003, FFF1,FFE1,8A96,87C7, FFFC,FFE7,93B6,887A, 0000,0000,9672,892A
$AA:A906             dx 0003, FFFC,FFE7,93D1,888A, FFF1,FFE1,8A96,87C7, 0000,0000,9672,892A
$AA:A920             dx 0003, FFFC,FFE7,93F6,889A, FFF1,FFE1,8A96,87C7, 0000,0000,9672,892A
$AA:A93A             dx 0003, FFFC,FFE7,9411,88AA, FFF1,FFE1,8A96,87C7, 0000,0000,9672,892A
$AA:A954             dx 0004, FFF1,FFE1,8A96,87C7, FFFC,FFE7,9380,885A, 0000,0000,9672,892A, FFFC,FFE7,9491,88CC

; Sonic booms / explosive swipe - facing left - left foot forward
$AA:A976             dx 0004, FFF1,FFE1,8A96,87C7, FFFC,FFE7,9380,885A, 0000,0000,9672,892A, FFFC,FFE7,94AC,88DC
$AA:A998             dx 0004, FFF1,FFE1,8A96,87C7, FFFC,FFE7,9380,885A, 0000,0000,9672,892A, FFFC,FFE7,94C7,88EC
$AA:A9BA             dx 0004, FFFC,FFE7,9380,885A, FFF1,FFE1,8A96,87C7, 0000,0000,9672,892A, FFFC,FFE7,94EC,88FC
$AA:A9DC             dx 0004, FFFC,FFE7,9380,885A, FFF1,FFE1,8A96,87C7, 0000,0000,9672,892A, FFFC,FFE7,9507,890C

; Unused
$AA:A9FE             dx 0001, 0000,0008,8B1F,87DA
$AA:AA08             dx 0001, 0000,0008,8B80,87DA

; Stand up / sit down - facing left
$AA:AA12             dx 0001, 0000,0000,8C33,87E8
$AA:AA1C             dx 0001, 0000,0000,8CB7,87F6
$AA:AA26             dx 0001, 0000,0000,8D3B,8804
$AA:AA30             dx 0001, 0000,0000,8DC4,8812
$AA:AA3A             dx 0002, FFFB,FFE8,9380,885A, 0000,0000,8E43,8820
$AA:AA4C             dx 0002, FFFB,FFE8,939B,886A, 0000,0000,8EC2,882E
$AA:AA5E             dx 0002, FFFB,FFE8,939B,886A, 0000,0000,8F46,883C

; Unused
$AA:AA70             dx 0001, 0000,0000,8C09,87C7
$AA:AA7A             dx 0001, 0000,0000,8C10,87C7
$AA:AA84             dx 0001, 0000,0000,8C17,87C7
$AA:AA8E             dx 0001, 0000,0000,8C1E,87C7

; Walking right - left leg moving
$AA:AA98             dx 0004, 000F,FFE2,9786,87C7, 0005,FFE8,A0A0,89B6, 0000,0000,A3D2,8A88, 0005,FFE8,A20C,8A3A
$AA:AABA             dx 0004, 000F,FFE2,9786,87C7, 0005,FFE7,A0C5,89B6, 0000,0000,9D34,89A8, 0005,FFE7,A1F1,8A2A
$AA:AADC             dx 0004, 000F,FFE1,9786,87C7, 0005,FFE6,A0E0,89B8, 0000,0000,9DA4,89A8, 0005,FFE6,A1D6,8A1A
$AA:AAFE             dx 0004, 000F,FFE0,9786,87C7, 0005,FFE7,A0FB,89C8, 0000,0000,9E0F,89A8, 0005,FFE7,A1BB,8A18
$AA:AB20             dx 0004, 000F,FFE0,9786,87C7, 0005,FFE8,A116,89D8, 0000,0000,9E7A,89A8, 0005,FFE8,A196,8A18

; Walking right - right leg moving
$AA:AB42             dx 0004, 000F,FFE2,9786,87C7, 0005,FFE8,A116,89D8, 0000,0000,A44C,8A88, 0005,FFE8,A196,8A18
$AA:AB64             dx 0004, 000F,FFE1,9786,87C7, 0005,FFE7,A0FB,89C8, 0000,0000,9EEA,89A8, 0005,FFE7,A1BB,8A18
$AA:AB86             dx 0004, 000F,FFE1,9786,87C7, 0005,FFE6,A0E0,89B8, 0000,0000,9F5A,89A8, 0005,FFE6,A1D6,8A1A
$AA:ABA8             dx 0004, 000F,FFE0,9786,87C7, 0005,FFE7,A0C5,89B6, 0000,0000,9FC5,89A8, 0005,FFE7,A1F1,8A2A
$AA:ABCA             dx 0004, 000F,FFE1,9786,87C7, 0005,FFE8,A0A0,89B6, 0000,0000,A030,89A8, 0005,FFE8,A20C,8A3A

; Spewing chozo orbs / sonic booms / explosive swipe / caught super missile - facing right - left foot forward
$AA:ABEC             dx 0003, 000F,FFE1,9786,87C7, 0004,FFE7,A0E0,89B8, 0000,0000,A44C,8A88

; Spewing chozo orbs - facing right - left foot forward
$AA:AC06             dx 0003, 0009,FFE1,979C,87C7, 0004,FFE7,A0FB,89C8, 0000,0000,A44C,8A88
$AA:AC20             dx 0003, 0009,FFE1,97B2,87C7, 0004,FFE7,A116,89D8, 0000,0000,A44C,8A88
$AA:AC3A             dx 0003, 0009,FFE1,97C3,87C7, 0004,FFE7,A131,89E8, 0000,0000,A44C,8A88
$AA:AC54             dx 0003, 0004,FFE7,A156,89F8, 0009,FFE1,97D4,87C7, 0000,0000,A44C,8A88
$AA:AC6E             dx 0003, 0004,FFE7,A156,89F8, 0009,FFE1,97E5,87C7, 0000,0000,A44C,8A88

; Spewing chozo orbs / sonic booms / explosive swipe / caught super missile - facing right - right foot forward
$AA:AC88             dx 0003, 000F,FFE1,9786,87C7, 0004,FFE7,A0C5,89B6, 0000,0000,A3D2,8A88

; Spewing chozo orbs - facing right - right foot forward
$AA:ACA2             dx 0003, 0009,FFE1,979C,87C7, 0004,FFE7,A0FB,89C8, 0000,0000,A3D2,8A88
$AA:ACBC             dx 0003, 0009,FFE1,97B2,87C7, 0004,FFE7,A116,89D8, 0000,0000,A3D2,8A88
$AA:ACD6             dx 0003, 0009,FFE1,97C3,87C7, 0004,FFE7,A131,89E8, 0000,0000,A3D2,8A88
$AA:ACF0             dx 0003, 0004,FFE7,A156,89F8, 0009,FFE1,97D4,87C7, 0000,0000,A3D2,8A88
$AA:AD0A             dx 0003, 0004,FFE7,A156,89F8, 0009,FFE1,97E5,87C7, 0000,0000,A3D2,8A88

; Sonic booms / explosive swipe / caught super missile - facing right - left foot forward
$AA:AD24             dx 0003, 000F,FFE1,9786,87C7, 0004,FFE7,A0FB,89C8, 0000,0000,A44C,8A88
$AA:AD3E             dx 0004, 000F,FFE1,9786,87C7, 0004,FFE7,A0FB,89C8, 0000,0000,A44C,8A88, 0004,FFE7,A20C,8A3A
$AA:AD60             dx 0004, 0004,FFE7,A0FB,89C8, 000F,FFE1,9786,87C7, 0000,0000,A44C,8A88, 0004,FFE7,A227,8A4A
$AA:AD82             dx 0004, 0004,FFE7,A0FB,89C8, 000F,FFE1,9786,87C7, 0000,0000,A44C,8A88, 0004,FFE7,A24C,8A5A
$AA:ADA4             dx 0004, 0004,FFE7,A0FB,89C8, 000F,FFE1,9786,87C7, 0000,0000,A44C,8A88, 0004,FFE7,A267,8A6A
$AA:ADC6             dx 0004, 000F,FFE1,9786,87C7, 0004,FFE7,A0FB,89C8, 0000,0000,A44C,8A88, 0004,FFE7,A1BB,8A18

; Sonic booms / explosive swipe - facing right - left foot forward
$AA:ADE8             dx 0004, 000F,FFE1,9786,87C7, 0004,FFE7,A116,89D8, 0000,0000,A44C,8A88, 0004,FFE7,A1BB,8A18
$AA:AE0A             dx 0004, 000F,FFE1,9786,87C7, 0004,FFE7,A131,89E8, 0000,0000,A44C,8A88, 0004,FFE7,A1BB,8A18
$AA:AE2C             dx 0004, 0004,FFE7,A156,89F8, 000F,FFE1,9786,87C7, 0000,0000,A44C,8A88, 0004,FFE7,A1BB,8A18
$AA:AE4E             dx 0004, 0004,FFE7,A171,8A08, 000F,FFE1,9786,87C7, 0000,0000,A44C,8A88, 0004,FFE7,A1BB,8A18

; Sonic booms / explosive swipe / caught super missile - facing right - right foot forward
$AA:AE70             dx 0003, 000F,FFE1,9786,87C7, 0004,FFE7,A0FB,89C8, 0000,0000,A3D2,8A88
$AA:AE8A             dx 0003, 000F,FFE1,9786,87C7, 0004,FFE7,A116,89D8, 0000,0000,A3D2,8A88
$AA:AEA4             dx 0003, 0004,FFE7,A131,89E8, 000F,FFE1,9786,87C7, 0000,0000,A3D2,8A88
$AA:AEBE             dx 0003, 0004,FFE7,A156,89F8, 000F,FFE1,9786,87C7, 0000,0000,A3D2,8A88
$AA:AED8             dx 0003, 0004,FFE7,A171,8A08, 000F,FFE1,9786,87C7, 0000,0000,A3D2,8A88
$AA:AEF2             dx 0004, 000F,FFE1,9786,87C7, 0004,FFE7,A0E0,89B8, 0000,0000,A3D2,8A88, 0004,FFE7,A1F1,8A2A

; Sonic booms / explosive swipe - facing right - right foot forward
$AA:AF14             dx 0004, 000F,FFE1,9786,87C7, 0004,FFE7,A0E0,89B8, 0000,0000,A3D2,8A88, 0004,FFE7,A20C,8A3A
$AA:AF36             dx 0004, 000F,FFE1,9786,87C7, 0004,FFE7,A0E0,89B8, 0000,0000,A3D2,8A88, 0004,FFE7,A227,8A4A
$AA:AF58             dx 0004, 0004,FFE7,A0E0,89B8, 000F,FFE1,9786,87C7, 0000,0000,A3D2,8A88, 0004,FFE7,A24C,8A5A
$AA:AF7A             dx 0004, 0004,FFE7,A0E0,89B8, 000F,FFE1,9786,87C7, 0000,0000,A3D2,8A88, 0004,FFE7,A267,8A6A

; Stand up / sit down - facing right
$AA:AF9C             dx 0001, 0000,0000,994A,8946
$AA:AFA6             dx 0001, 0000,0000,99D3,8954
$AA:AFB0             dx 0001, 0000,0000,9A57,8962
$AA:AFBA             dx 0001, 0000,0000,9AE0,8970
$AA:AFC4             dx 0002, 0005,FFE8,A0E0,89B8, 0000,0000,9B5F,897E
$AA:AFD6             dx 0002, 0005,FFE8,A0FB,89C8, 0000,0000,9BDE,898C
$AA:AFE8             dx 0002, 0005,FFE8,A0FB,89C8, 0000,0000,9C62,899A

; Jumping / falling - facing left
$AA:AFFA             dx 0003, FFF0,FFE3,8A96,87C7, FFFC,FFEA,9380,885A, 0000,0000,952C,891C
$AA:B014             dx 0003, FFF0,FFE2,8A96,87C7, FFFC,FFE8,9365,8858, 0000,0000,95A6,891C
$AA:B02E             dx 0003, FFF0,FFE2,8A96,87C7, FFFD,FFE8,9340,8858, 0000,0000,9607,891C

; Jumping / falling - facing right
$AA:B048             dx 0003, 000F,FFE4,9786,87C7, 0004,FFEA,A0E0,89B8, 0000,0000,A28C,8A7A
$AA:B062             dx 0003, 000F,FFE3,9786,87C7, 0004,FFE8,A0C5,89B6, 0000,0000,A306,8A7A
$AA:B07C             dx 0003, 000F,FFE3,9786,87C7, 0003,FFE8,A0A0,89B6, 0000,0000,A367,8A7A
}


;;; $B096: Torizo music tracks ;;;
{
$AA:B096             dw 0006 ; Song 1 - pre-fight music. Music track to queue when Bomb Torizo is revealed
$AA:B098             dw 0005 ; Song 0 - fight music. Music track to queue when Bomb Torizo fight starts
$AA:B09A             dw 0003 ; Elevator. Music track to queue when torizo dies
}


;;; $B09C..C209: Instruction lists and instructions ;;;
{
;;; $B09C: Instruction - enemy function = [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:B09C B9 00 00    LDA $0000,y[$AA:B883]
$AA:B09F 9D B0 0F    STA $0FB0,x[$7E:0FB0]
$AA:B0A2 C8          INY
$AA:B0A3 C8          INY
$AA:B0A4 6B          RTL
}


;;; $B0A5: Blank tiles ;;;
{
$AA:B0A5             db 00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
}


;;; $B0E5: Instruction list - special callable - blow up Bomb Torizo's gut ;;;
{
; "special" because the usual link instruction isn't being used for returning
$AA:B0E5             dx B09C,C6AB,              ; Enemy function = RTS
                        C2C9,                   ; Set animation lock
                        C303,0000,              ; Spawn 5 Bomb Torizo low-health explosion enemy projectiles with parameter 0 and sleep for 28h i-frames
                        B11D,                   ; Mark Bomb Torizo gut blown up and spawn 6 Bomb Torizo low-health continuous drool enemy projectiles
                        814B,0040,AAB479,7300,  ; Transfer 40h bytes from $AA:B479        to VRAM $7300
                        814B,0040,AAB679,7400,  ; Transfer 40h bytes from $AA:B479 + 200h to VRAM $7400
                        814B,0020,AAB4B9,7E70,  ; Transfer 20h bytes from $AA:B479 + 40h  to VRAM $7E70
                        814B,0020,AAB6B9,7F70,  ; Transfer 20h bytes from $AA:B479 + 240h to VRAM $7F70
                        B09C,C6FF,              ; Enemy function = $C6FF (normal movement)
                        C2D1,                   ; Clear animation lock
                        C2FD                    ; Go to [enemy gut explosion link instruction]
}


;;; $B11D: Instruction - mark Bomb Torizo gut blown up and spawn 6 Bomb Torizo low-health continuous drool enemy projectiles ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:B11D BD B6 0F    LDA $0FB6,x[$7E:0FB6]  ;\
$AA:B120 09 00 80    ORA #$8000             ;} Mark torizo gut blown up
$AA:B123 9D B6 0F    STA $0FB6,x[$7E:0FB6]  ;/
$AA:B126 DA          PHX
$AA:B127 5A          PHY
$AA:B128 A0 5B A9    LDY #$A95B             ;\
$AA:B12B 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo low-health continuous drool enemy projectile
$AA:B12F A0 5B A9    LDY #$A95B             ;\
$AA:B132 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo low-health continuous drool enemy projectile
$AA:B136 A0 5B A9    LDY #$A95B             ;\
$AA:B139 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo low-health continuous drool enemy projectile
$AA:B13D A0 5B A9    LDY #$A95B             ;\
$AA:B140 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo low-health continuous drool enemy projectile
$AA:B144 A0 5B A9    LDY #$A95B             ;\
$AA:B147 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo low-health continuous drool enemy projectile
$AA:B14B A0 5B A9    LDY #$A95B             ;\
$AA:B14E 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo low-health continuous drool enemy projectile
$AA:B152 7A          PLY
$AA:B153 FA          PLX
$AA:B154 6B          RTL
}


;;; $B155: Instruction list - callable - blow up Bomb Torizo's face ;;;
{
$AA:B155             dx B09C,C6AB,              ; Enemy function = RTS
                        C2C9,                   ; Set animation lock
                        C303,0006,              ; Spawn 5 Bomb Torizo low-health explosion enemy projectiles with parameter 6 and sleep for 28h i-frames
                        B1BE,                   ; Mark Bomb Torizo face blown up
                        814B,0020,AAB4D9,7E50,  ; Transfer 20h bytes from $AA:B479 + 60h  to VRAM $7E50
                        814B,0020,AAB6D9,7F50,  ; Transfer 20h bytes from $AA:B479 + 260h to VRAM $7F50
                        814B,0040,AAB0A5,7C80,  ; Transfer 40h bytes from $AA:B0A5 to VRAM $7C80
                        814B,0040,AAB0A5,7CA0,  ; Transfer 40h bytes from $AA:B0A5 to VRAM $7CA0
                        813A,0001,              ; Wait 1 frame
                        814B,0040,AAB0A5,7D80,  ; Transfer 40h bytes from $AA:B0A5 to VRAM $7D80
                        814B,0040,AAB0A5,7DA0,  ; Transfer 40h bytes from $AA:B0A5 to VRAM $7DA0
                        814B,0040,AAB0A5,7E80,  ; Transfer 40h bytes from $AA:B0A5 to VRAM $7E80
                        814B,0040,AAB0A5,7F80,  ; Transfer 40h bytes from $AA:B0A5 to VRAM $7F80
                        814B,0020,AAB0A5,79F0,  ; Transfer 20h bytes from $AA:B0A5 to VRAM $79F0
                        B09C,C6FF,              ; Enemy function = $C6FF (normal movement)
                        C2D1,                   ; Clear animation lock
                        C2F7                    ; Return
}


;;; $B1BE: Instruction - mark Bomb Torizo face blown up ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:B1BE BD B6 0F    LDA $0FB6,x[$7E:0FB6]  ;\
$AA:B1C1 09 00 40    ORA #$4000             ;} Enemy behavioural properties |= 4000h
$AA:B1C4 9D B6 0F    STA $0FB6,x[$7E:0FB6]  ;/
$AA:B1C7 6B          RTL
}


;;; $B1C8: Instruction list - torizo death sequence ;;;
{
$AA:B1C8             dx B09C,C6AB,  ; Enemy function = RTS
                        C2C9,       ; Set animation lock
                        8123,0008   ; Timer = 8
$AA:B1D2             dx C32F,       ; Spawn torizo death explosion and sleep for 1 i-frame
                        813A,0006,  ; Wait 6 frames
                        8110,B1D2,  ; Decrement timer and go to $B1D2 if non-zero
                        B238,       ; Set up palette transition to black
                        8123,000E   ; Timer = Eh
$AA:B1E2             dx C32F,       ; Spawn torizo death explosion and sleep for 1 i-frame
                        B224,       ; Set enemy as visible
                        813A,0002,  ; Wait 2 frames
                        B22E,       ; Set enemy as invisible
                        813A,0002,  ; Wait 2 frames
                        C32F,       ; Spawn torizo death explosion and sleep for 1 i-frame
                        B224,       ; Set enemy as visible
                        813A,0002,  ; Wait 2 frames
                        B22E,       ; Set enemy as invisible
                        813A,0002,  ; Wait 2 frames
                        B224,       ; Set enemy as visible
                        813A,0002,  ; Wait 2 frames
                        B22E,       ; Set enemy as invisible
                        813A,0002,  ; Wait 2 frames
                        B224,       ; Set enemy as visible
                        813A,0002,  ; Wait 2 frames
                        B22E,       ; Set enemy as invisible
                        813A,0002,  ; Wait 2 frames
                        B271,       ; Advance gradual colour change
                        8110,B1E2,  ; Decrement timer and go to $B1E2 if non-zero
                        813A,0040,  ; Wait 40h frames
                        B24D,       ; Set boss bit, queue elevator music, spawn item drops
                        807C        ; Delete
}


;;; $B224: Instruction - set enemy as visible ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:B224 BD 86 0F    LDA $0F86,x[$7E:0F86]
$AA:B227 29 FF FE    AND #$FEFF
$AA:B22A 9D 86 0F    STA $0F86,x[$7E:0F86]
$AA:B22D 6B          RTL
}


;;; $B22E: Instruction - set enemy as invisible ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:B22E BD 86 0F    LDA $0F86,x[$7E:0F86]
$AA:B231 09 00 01    ORA #$0100
$AA:B234 9D 86 0F    STA $0F86,x[$7E:0F86]
$AA:B237 6B          RTL
}


;;; $B238: Instruction - set up palette transition to black ;;;
{
; Target sprite palettes 1/2 = 0
$AA:B238 DA          PHX
$AA:B239 A2 1E 00    LDX #$001E
$AA:B23C A9 00 00    LDA #$0000

$AA:B23F 9F 40 C3 7E STA $7EC340,x[$7E:C35E]
$AA:B243 9F 20 C3 7E STA $7EC320,x[$7E:C33E]
$AA:B247 CA          DEX
$AA:B248 CA          DEX
$AA:B249 10 F4       BPL $F4    [$B23F]
$AA:B24B FA          PLX
$AA:B24C 6B          RTL
}


;;; $B24D: Instruction - set boss bit, queue elevator music, spawn item drops ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:B24D A9 04 00    LDA #$0004             ;\
$AA:B250 22 A6 81 80 JSL $8081A6[$80:81A6]  ;} Set torizo boss bit
$AA:B254 AD 9A B0    LDA $B09A  [$AA:B09A]  ;\
$AA:B257 22 C1 8F 80 JSL $808FC1[$80:8FC1]  ;} Queue elevator music track
$AA:B25B 5A          PHY
$AA:B25C DA          PHX
$AA:B25D 08          PHP
$AA:B25E AD 9F 07    LDA $079F  [$7E:079F]  ;\
$AA:B261 D0 06       BNE $06    [$B269]     ;} If [area index] = Crateria:
$AA:B263 22 A4 BA A0 JSL $A0BAA4[$A0:BAA4]  ; Bomb Torizo death item drop routine
$AA:B267 80 04       BRA $04    [$B26D]
                                            ; Else ([area index] != Crateria):
$AA:B269 22 D7 BA A0 JSL $A0BAD7[$A0:BAD7]  ; Golden Torizo death item drop routine

$AA:B26D 28          PLP
$AA:B26E FA          PLX
$AA:B26F 7A          PLY
$AA:B270 6B          RTL
}


;;; $B271: Instruction - advance gradual colour change ;;;
{
$AA:B271 A9 00 06    LDA #$0600             ;\
$AA:B274 22 F7 DA 82 JSL $82DAF7[$82:DAF7]  ;} Advance gradual colour change of sprite palettes 1/2 - denominator = Ch
$AA:B278 6B          RTL
}


;;; $B279: Torizo tiles ;;;
{
; Torizo eyes opening / blinking
; Bomb Torizo gut blown up
; Bomb Torizo face blown up
; Golden Torizo releasing eggs

; |--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|
; | 4756744|347F4333| 4756744|347F4333| 4756744|347F4333| 4756744|347F4333|        |        |        |        |        |        |        |        |
; | 3667343|3337333F| 3667343|3337333F| 3667343|3337333F| 3667347|6737333F|        |        |        |        |        |        |        |        |
; |47277377|7763434F|47277377|7733434F|47277377|7733434F|4727776B|BBF7434F|        |        |        |        |        |        |        |        |
; |46273776|653634F |46273776|633634F |46273776|333634F |462736BE|EEBF64F |        |        |        |        |        |        |        |        |
; |32673766|17573FF |32673762|3EB73FF |3267376B|EEB73FF |32676BEC|CDEB7FF |        |        |        |        |        |        |        |        |
; |76737661|716734F |76737623|DDE734F |767376BD|CDE734F |76735BEC|CDEB74F |        |        |        |        |        |        |        |        |
; |72737657|16674F4 |7273763D|CE374F4 |727373EC|CDE74F4 |72735BED|DDEB4F4 |        |        |        |        |        |        |        |        |
; |65737635|6673F4  |657373EC|E373F4  |657373ED|DE73F4  |657363BE|EEB6F4  |        |        |        |        |        |        |        |        |
; |--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|
; |3777734B|BFF6744F|37444375|43443773|7666734B|BFF6744F|7666734B|BFF6744F|7666734B|BFF6744F|        |        |        |        |        |        |
; |333334BA|AF6F3414|33743475|47448675|377334BA|AF6F3414|377334BA|AF6F3414|377334BA|AF663414|        |        |        |        |        |        |
; |FFFBAFBB|BBFB7574|44349436|45743333|333FFFBB|BBFB7574|333FFFBB|BBFB7564|333FFFBB|BBFB7564|        |        |        |        |        |        |
; |FFFF9BBB|ABBF6673|3443AB36|43453655|FFFFFBA9|9ABF6673|FFFFFBA9|9ABF6673|FFFFFBA9|ABBF6673|        |        |        |        |        |        |
; |33FBA33B|9BF6F733|349ABA37|43477573|333BAA99|ABA6F733|333BBA99|ABA6F733|333BFA99|ABA6F733|        |        |        |        |        |        |
; |3BABB333|BBBFB333|743BAA33|47443175|33BAA9AB|BABFB333|3FF3BBAA|BABFB333|3FFFFFBA|BABFB333|        |        |        |        |        |        |
; | ABB3333|ABBBB3FF|44A9BBBB|44573633| 33BBBB9|9ABBB3F1| 3FFFBBB|A9BBB3F1| 3FFFFFB|A9ABB3F1|        |        |        |        |        |        |
; | A3AB333|B3AAB7FF|49AB9ABB|44447737| 33FBA99|9BAAB71F|  3FFFBA|9BBAB71F|  F3FFFF|BABAB716|        |        |        |        |        |        |
; |--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|
; | 939B333|333BF7F4|344BABBB|43444337|  3FFBA9|BBABF7F4|   3FFFB|BBABF7F4|   3FFFF|FBABF7F4|        |        |        |        |        |        |
; |  BABAB3|333B77F3|24A9AABB|43344765|   FFFBB|99AB77F3|    3FFF|BA9B77F3|    3FFF|FF9B77F3|        |        |        |        |        |        |
; |  B3B3B3|333B773F|234B9ABB|64333337|   3FFBB|A9BA773F|     3FF|B7BA773F|     3FF|FFBA773F|        |        |        |        |        |        |
; |  A AFBB|FBBAB3FF|3739BABB|13673333|    3FFB|AABAB3FF|     3FF|FBAAB3FF|      3F|FFBAB3FF|        |        |        |        |        |        |
; |    93AB|BBB9B3FF| 444BAAB|66434773|     3FF|BBA9B3FF|      3F|FFA9B3FF|      3F|FFB9B3FF|        |        |        |        |        |        |
; |      AB|BBABF3FF|47444BAA|41343373|      33|BAABF3FF|       F|FB7BF3FF|       3|FFBBF3FF|        |        |        |        |        |        |
; |      93|AB97F3FF|22749A3B|43673777|       3|3BB7F3FF|       3|F377F3FF|       3|FB77F3FF|        |        |        |        |        |        |
; |        |333F3FFF|22247494|74361773|       F|333F3FFF|       F|333F3FFF|       F|333F3FFF|        |        |        |        |        |        |
; |--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|--------|

$AA:B279             db 34,2C,4D,7D,5F,7F,1E,7F,9C,FF,B9,FE,BB,FD,7B,BE,7F,00,3A,00,DB,00,D7,00,37,00,EE,00,AF,00,ED,00,
                        B7,B7,FF,FF,D5,F5,6A,BA,FE,5E,DA,BA,94,74,38,F8,78,10,11,01,EB,01,D6,02,76,06,B6,02,7E,04,EC,08,
                        34,2C,4D,7D,5F,7F,1E,7F,9C,FF,B9,FF,BB,FE,7C,BE,7F,00,3A,00,DB,00,D7,00,36,00,EC,00,AD,01,EB,03,
                        B7,B7,FF,FF,F5,F5,6A,FA,BE,FE,DA,3A,34,74,78,F8,78,10,11,01,CB,01,96,02,56,66,F6,E2,DE,C4,AC,88,
                        34,2C,4D,7D,5F,7F,1E,7F,9D,FF,BB,FE,BC,FE,7D,BE,7F,00,3A,00,DB,00,D7,00,36,01,ED,03,AB,03,EB,03,
                        B7,B7,FF,FF,F5,F5,EA,FA,3E,FE,5A,3A,54,34,B8,78,78,10,11,01,CB,01,16,02,D6,E6,F6,E2,FE,E4,EC,C8,
                        34,2C,4D,7D,5D,7F,1A,7F,94,FE,BC,F6,BD,F6,76,BF,7F,00,3B,00,DE,01,D5,03,3B,07,EB,07,AB,07,E9,03,
                        B7,B7,7F,FF,F5,F5,32,FA,5E,3E,5A,3A,D4,34,28,F8,78,10,D1,01,3B,E1,DE,F2,EE,F6,EE,F2,EE,F4,DC,E8,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        FD,FD,FA,FB,F7,FF,FF,F7,F7,FF,DF,FF,3F,7F,2F,7F,7A,01,04,03,E4,FF,F0,FF,20,39,00,78,00,70,00,58,
                        E9,F9,5A,F8,FE,FA,73,FF,EF,7F,FF,FF,7F,FF,CF,FF,7F,E1,75,D0,2F,F0,1E,F0,3C,E8,10,F8,03,FB,07,BB,
                        C7,C6,EB,EA,2A,23,96,9F,AB,9F,B3,BF,1F,2F,5B,37,7B,00,37,00,D5,08,61,0C,41,3C,C0,1C,C0,3F,80,7F,
                        4F,4F,43,46,6F,2F,5B,4C,5F,5B,4F,4A,3B,1F,0F,0F,B6,00,F7,08,F0,00,B7,00,BE,00,F3,00,F4,00,FD,00,
                        8D,FD,FA,FB,FF,FF,FD,FE,F3,FC,E5,FB,7F,7E,7B,7C,FA,01,64,03,1C,1F,F8,FF,00,1F,00,3F,00,1F,10,1F,
                        E9,F9,5A,F8,FE,FA,B3,7F,4F,FF,BF,FF,BF,7E,CF,7D,7F,E1,75,D0,2F,F0,1E,F0,1C,E8,10,F8,02,FA,05,F9,
                        8D,FD,FA,FB,FF,FF,FD,FE,FB,FC,FC,FF,7F,7F,3E,3F,FA,01,64,03,1C,1F,F8,FF,00,1F,60,6F,38,3F,1C,1F,
                        E9,F9,5A,F8,FC,FA,B3,7F,4F,FF,BF,FF,7F,BE,EF,7D,7F,E1,75,D0,2F,F0,1E,F0,1C,E8,10,F8,02,FA,05,F9,
                        8D,FD,FA,FB,FF,FF,FD,FE,FB,FC,FE,FF,7F,7F,3F,3F,FA,01,64,03,1C,1F,F8,FF,08,1F,7C,7F,3E,3F,2F,2F,
                        E9,F9,4A,F8,FC,FA,73,FF,4F,FF,BF,FF,5F,BE,AE,FD,7F,E1,75,C0,2F,F0,1E,F0,1C,E8,10,F8,02,FA,05,F8,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        7F,2F,2B,3F,3F,3F,07,2F,0D,07,01,03,03,01,00,00,00,58,00,3E,00,2A,04,2F,00,0B,00,03,00,02,00,00,
                        FE,FE,FF,FF,FF,FF,EF,FF,FF,EF,DF,FF,7F,DF,FF,FF,0F,1A,0E,12,0D,11,83,FB,03,FB,0B,FB,1B,EB,17,17,
                        97,9F,13,AF,5B,D7,FB,EF,09,0F,44,47,2B,E7,0A,E8,60,1F,40,3F,20,1F,40,1F,70,0F,F8,07,30,0D,1D,02,
                        47,47,65,66,3F,BF,DF,7F,17,D7,6F,2F,5F,7F,AF,B7,B9,00,9F,00,C1,00,30,00,EE,00,92,00,B7,00,D6,00,
                        3D,3E,1F,1F,1F,1F,0F,0F,07,07,03,03,01,01,01,01,18,1F,1C,1F,0C,0F,06,07,03,03,00,00,00,00,01,01,
                        DE,FE,DF,3F,6F,BF,2F,FF,DF,EF,9F,FF,FF,FF,FF,FF,0F,FA,0E,F2,0D,F1,03,FB,03,FB,0B,FB,1B,6B,17,17,
                        1F,1F,0F,0F,07,07,07,07,03,03,01,01,01,01,01,01,0E,0F,07,07,03,03,03,03,01,01,01,01,00,00,01,01,
                        DE,FE,BF,DF,EF,FF,CF,FF,DF,EF,FF,FF,FF,FF,FF,FF,0F,FA,0E,F2,4D,B1,83,FB,C3,FB,AB,DB,BB,8B,17,17,
                        1F,1F,0F,0F,07,07,03,03,03,03,01,01,01,01,01,01,0F,0F,07,07,03,03,01,01,01,01,00,00,00,00,01,01,
                        DE,FE,FF,DF,EF,FF,EF,FF,FF,EF,FF,FF,FF,FF,FF,FF,8F,FA,CE,F2,CD,F1,C3,FB,C3,FB,CB,FB,BB,CB,17,17,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,
                        00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00
}


;;; $B879: Instruction list - Bomb Torizo - initial ;;;
{
$AA:B879             dx C3A0,                   ; Set stepped left with right foot state
                        C2C9,                   ; Set animation lock
                        0001,87D0,
                        B09C,C6C6,              ; Enemy function = $C6C6 (wake enemy when Bomb Torizo chozo finishes crumbling)
                        812F,                   ; Sleep
                        B09C,C6BF,              ; Enemy function = $C6BF (simple movement)
                        0030,AA12,
                        814B,0040,AAB279,7D80,  ; Transfer 40h bytes from $AA:B279       to VRAM $7D80
                        0020,AA12,
                        814B,0040,AAB2B9,7D80,  ; Transfer 40h bytes from $AA:B279 + 40h to VRAM $7D80
                        0010,AA12,
                        814B,0040,AAB2F9,7D80,  ; Transfer 40h bytes from $AA:B279 + 80h to VRAM $7D80
                        0008,AA12,
                        814B,0040,AAB339,7D80,  ; Transfer 40h bytes from $AA:B279 + C0h to VRAM $7D80
                        0020,AA12,
                        8123,0002               ; Timer = 2
$AA:B8C7             dx 0004,AA12,
                        814B,0040,AAB279,7D80,  ; Transfer 40h bytes from $AA:B279       to VRAM $7D80
                        0004,AA12,
                        814B,0040,AAB2B9,7D80,  ; Transfer 40h bytes from $AA:B279 + 40h to VRAM $7D80
                        0004,AA12,
                        814B,0040,AAB2F9,7D80,  ; Transfer 40h bytes from $AA:B279 + 80h to VRAM $7D80
                        0004,AA12,
                        814B,0040,AAB339,7D80,  ; Transfer 40h bytes from $AA:B279 + C0h to VRAM $7D80
                        8110,B8C7,              ; Decrement timer and go to $B8C7 if non-zero
                        0030,AA12,
                        C3CC,0000,              ; Standing up movement - index 0
                        0010,AA1C,
                        C3CC,0002,              ; Standing up movement - index 2
                        0008,AA26,
                        C3CC,0004,              ; Standing up movement - index 4
                        0008,AA30,
                        C3CC,0006,              ; Standing up movement - index 6
                        0008,AA3A,
                        C3CC,0008,              ; Standing up movement - index 8
                        0008,AA4C,
                        C3CC,000A,              ; Standing up movement - index Ah
                        B94D,                   ; Set up palette transition to normal torizo
                        8123,0010               ; Timer = 10h
$AA:B935             dx 0004,AA5E,
                        B271,                   ; Advance gradual colour change
                        8110,B935,              ; Decrement timer and go to $B935 if non-zero
                        C2C8,                   ; NOP
                        C2D1,                   ; Clear animation lock
                        B951,                   ; Start fight music and Bomb Torizo belly palette FX
                        0010,AA5E,
                        80ED,B9B6               ; Go to $B9B6 (walking left - left leg moving)
}


;;; $B94D: Instruction - set up palette transition to normal torizo ;;;
{
$AA:B94D 20 68 C2    JSR $C268  [$AA:C268]  ; Load normal torizo target palettes
$AA:B950 6B          RTL
}


;;; $B951: Instruction - start fight music and Bomb Torizo belly palette FX ;;;
{
$AA:B951 AD 98 B0    LDA $B098  [$AA:B098]  ;\
$AA:B954 22 C1 8F 80 JSL $808FC1[$80:8FC1]  ;} Queue song 0 music track
$AA:B958 5A          PHY
$AA:B959 A0 59 F7    LDY #$F759             ;\
$AA:B95C 22 E9 C4 8D JSL $8DC4E9[$8D:C4E9]  ;} Spawn Bomb Torizo belly palette FX
$AA:B960 7A          PLY
$AA:B961 6B          RTL
}


;;; $B962..BD8F: Instruction lists - facing left ;;;
{
;;; $B962: Instruction list - turning left ;;;
{
$AA:B962             dx B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        C36D,       ; Set torizo turning around flag
                        0018,A4F0
}


;;; $B96C: Instruction list - walking left - right leg moving ;;;
{
$AA:B96C             dx C377,       ; Set stepped left with left foot state
                        B09C,C6FF,  ; Enemy function = $C6FF (normal movement)
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C35B,       ; Spawn low-health initial drool if health is low
                        C618,       ; Queue torizo footsteps sound effect
                        000A,A4FA,
                        C567,BBDE,  ; Call $BBDE (explosive swipe) if Samus is less than 38h pixels in front of torizo
                        C58B,BC96,  ; Go to $BC96 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0002,  ; Bomb Torizo walking movement - normal - index 2
                        0006,A51C,
                        C58B,BC96,  ; Go to $BC96 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0004,  ; Bomb Torizo walking movement - normal - index 4
                        0006,A53E,
                        C58B,BC96,  ; Go to $BC96 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0006,  ; Bomb Torizo walking movement - normal - index 6
                        0006,A560,
                        C58B,BC96,  ; Go to $BC96 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0008,  ; Bomb Torizo walking movement - normal - index 8
                        0006,A582,
                        C470,000A   ; Bomb Torizo walking movement - normal - index Ah
}


;;; $B9B6: Instruction list - walking left - left leg moving ;;;
{
$AA:B9B6             dx C3A0,       ; Set stepped left with right foot state
                        B09C,C6FF,  ; Enemy function = $C6FF (normal movement)
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C35B,       ; Spawn low-health initial drool if health is low
                        C618,       ; Queue torizo footsteps sound effect
                        000A,A5A4,
                        C567,BB5C,  ; Call $BB5C (explosive swipe) if Samus is less than 38h pixels in front of torizo
                        C58B,BCD2,  ; Go to $BCD2 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,000C,  ; Bomb Torizo walking movement - normal - index Ch
                        0006,A5C6,
                        C58B,BCD2,  ; Go to $BCD2 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,000E,  ; Bomb Torizo walking movement - normal - index Eh
                        0006,A5E8,
                        C58B,BCD2,  ; Go to $BCD2 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0010,  ; Bomb Torizo walking movement - normal - index 10h
                        0006,A60A,
                        C58B,BCD2,  ; Go to $BCD2 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0012,  ; Bomb Torizo walking movement - normal - index 12h
                        0006,A62C,
                        C470,0000,  ; Bomb Torizo walking movement - normal - index 0
                        80ED,B96C   ; Go to $B96C (walking left - right leg moving)
}


;;; $BA04: Instruction list - callable - spewing chozo orbs - facing left - right foot forward ;;;
{
$AA:BA04             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        0010,A64E,
                        0008,A668,
                        0008,A682,
                        0008,A69C,
                        0008,A6B6,
                        0010,A6D0,
                        C610,       ; Queue shot torizo sound effect
                        8123,0003   ; Timer = 3
$AA:BA26             dx C5CB,       ; Spawn Bomb Torizo's chozo orbs
                        813A,0010,  ; Wait 10h frames
                        8110,BA26,  ; Decrement timer and go to $BA26 if non-zero
                        0008,A6B6,
                        0008,A69C,
                        0008,A682,
                        0048,A668,
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BA46: Instruction list - callable - spewing chozo orbs - facing left - left foot forward ;;;
{
$AA:BA46             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        0010,A6EA,
                        0008,A704,
                        0008,A71E,
                        0008,A738,
                        0008,A752,
                        0010,A76C,
                        C610,       ; Queue shot torizo sound effect
                        8123,0003   ; Timer = 3
$AA:BA68             dx C5CB,       ; Spawn Bomb Torizo's chozo orbs
                        813A,0010,  ; Wait 10h frames
                        8110,BA68,  ; Decrement timer and go to $BA68 if non-zero
                        0008,A752,
                        0008,A738,
                        0008,A71E,
                        0048,A704,
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BA88: Instruction list - callable - sonic booms - facing left - right foot forward ;;;
{
$AA:BA88             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        8123,0004   ; Timer = 4
$AA:BA90             dx 0006,A64E,
                        0006,A786,
                        0006,A7A0,
                        0006,A7C2,
                        0006,A7E4,
                        0006,A806,
                        0002,A7E4,
                        0002,A7C2,
                        C5E3,0000,  ; Spawn Bomb Torizo sonic boom with parameter 0
                        0002,A7A0,
                        0018,A786,
                        0006,A64E,
                        0006,A828,
                        0006,A84A,
                        0006,A86C,
                        0006,A88E,
                        0006,A8B0,
                        0002,A88E,
                        0002,A86C,
                        C5E3,0001,  ; Spawn Bomb Torizo sonic boom with parameter 1
                        0002,A84A,
                        0038,A828,
                        8110,BA90,  ; Decrement timer and go to $BA90 if non-zero
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BAF2: Instruction list - callable - sonic booms - facing left - left foot forward ;;;
{
$AA:BAF2             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        8123,0004   ; Timer = 4
$AA:BAFA             dx 0006,A6EA,
                        0006,A8D2,
                        0006,A8EC,
                        0006,A906,
                        0006,A920,
                        0006,A93A,
                        0002,A920,
                        0002,A906,
                        C5E3,0000,  ; Spawn Bomb Torizo sonic boom with parameter 0
                        0002,A8EC,
                        0018,A8D2,
                        0006,A6EA,
                        0006,A954,
                        0006,A976,
                        0006,A998,
                        0006,A9BA,
                        0006,A9DC,
                        0002,A9BA,
                        0002,A998,
                        C5E3,0001,  ; Spawn Bomb Torizo sonic boom with parameter 1
                        0002,A976,
                        0038,A954,
                        8110,BAFA,  ; Decrement timer and go to $BAFA if non-zero
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BB5C: Instruction list - callable - explosive swipe - facing left - right foot forward ;;;
{
$AA:BB5C             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        0003,A64E,
                        0003,A786,
                        0003,A7A0,
                        0003,A7C2,
                        0003,A7E4,
                        C601,0000,  ; Spawn Bomb Torizo explosive swipe with parameter 0
                        0003,A806,
                        C601,0002,  ; Spawn Bomb Torizo explosive swipe with parameter 2
                        0001,A7E4,
                        C601,0004,  ; Spawn Bomb Torizo explosive swipe with parameter 4
                        0001,A7C2,
                        C601,0006,  ; Spawn Bomb Torizo explosive swipe with parameter 6
                        0001,A7A0,
                        C601,0008,  ; Spawn Bomb Torizo explosive swipe with parameter 8
                        0001,A786,
                        C601,000A,  ; Spawn Bomb Torizo explosive swipe with parameter Ah
                        0003,A64E,
                        0003,A828,
                        0003,A84A,
                        0003,A86C,
                        0003,A88E,
                        C601,000C,  ; Spawn Bomb Torizo explosive swipe with parameter Ch
                        0003,A8B0,
                        C601,000E,  ; Spawn Bomb Torizo explosive swipe with parameter Eh
                        0001,A88E,
                        C601,0010,  ; Spawn Bomb Torizo explosive swipe with parameter 10h
                        0001,A86C,
                        C601,0012,  ; Spawn Bomb Torizo explosive swipe with parameter 12h
                        0001,A84A,
                        0010,A828,
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BBDE: Instruction list - callable - explosive swipe - facing left - left foot forward ;;;
{
$AA:BBDE             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        0003,A6EA,
                        0003,A8D2,
                        0003,A8EC,
                        0003,A906,
                        0003,A920,
                        C601,0000,  ; Spawn Bomb Torizo explosive swipe with parameter 0
                        0003,A93A,
                        C601,0002,  ; Spawn Bomb Torizo explosive swipe with parameter 2
                        0001,A920,
                        C601,0004,  ; Spawn Bomb Torizo explosive swipe with parameter 4
                        0001,A906,
                        C601,0006,  ; Spawn Bomb Torizo explosive swipe with parameter 6
                        0001,A8EC,
                        C601,0008,  ; Spawn Bomb Torizo explosive swipe with parameter 8
                        0001,A8D2,
                        C601,000A,  ; Spawn Bomb Torizo explosive swipe with parameter Ah
                        0003,A6EA,
                        0003,A954,
                        0003,A976,
                        0003,A998,
                        0003,A9BA,
                        C601,000C,  ; Spawn Bomb Torizo explosive swipe with parameter Ch
                        0003,A9DC,
                        C601,000E,  ; Spawn Bomb Torizo explosive swipe with parameter Eh
                        0001,A9BA,
                        C601,0010,  ; Spawn Bomb Torizo explosive swipe with parameter 10h
                        0001,A998,
                        C601,0012,  ; Spawn Bomb Torizo explosive swipe with parameter 12h
                        0001,A976,
                        0010,A954,
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BC60: Instruction list - jumping forwards - facing left ;;;
{
$AA:BC60             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,BC78,      ; Enemy link instruction = $BC78 (falling - facing left)
                        0005,AFFA,
                        0005,B014
$AA:BC70             dx 0001,B02E,
                        C55A,BC70       ; Go to $BC70 if rising
}


;;; $BC78: Instruction list - falling - facing left ;;;
{
$AA:BC78             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,BC88       ; Enemy link instruction = $BC88
$AA:BC80             dx 0005,B014,
                        80ED,BC80       ; Go to $BC80
$AA:BC88             dx C618,           ; Queue torizo footsteps sound effect
                        C34A,           ; Spawn torizo landing dust clouds
                        C2D9,BD52,D259, ; Go to $BD52 (faceless - walking left - left leg moving) if face blown up, else go to $D259 (Golden Torizo - walking left - left leg moving) if Golden Torizo
                        80ED,B9B6       ; Go to $B9B6 (walking left - left leg moving)
}


;;; $BC96: Instruction list - jumping backwards - facing left - landing left foot forward ;;;
{
$AA:BC96             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,BCAE,      ; Enemy link instruction = $BCAE
                        0005,AFFA,
                        0005,B014
$AA:BCA6             dx 0001,B02E,
                        C55A,BCA6       ; Go to $BCA6 if rising
$AA:BCAE             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,BCBE       ; Enemy link instruction = $BCBE
$AA:BCB6             dx 0005,B014,
                        80ED,BCB6       ; Go to $BCB6
$AA:BCBE             dx C618,           ; Queue torizo footsteps sound effect
                        C34A,           ; Spawn torizo landing dust clouds
                        C2D9,BD18,CDAF, ; Go to $BD18 (faceless - walking left - right leg moving) if face blown up, else go to $CDAF (Golden Torizo - landed from backwards jump - facing left - left foot forward) if Golden Torizo
                        C5A4,BA46,BAF2, ; Call $BA46 (spewing orbs) or $BAF2 (sonic booms) for Bomb Torizo attack
                        80ED,B96C       ; Go to $B96C (walking left - right leg moving)
}


;;; $BCD2: Instruction list - jumping backwards - facing left - landing right foot forward ;;;
{
$AA:BCD2             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,BCEA,      ; Enemy link instruction = $BCEA
                        0005,AFFA,
                        0005,B014
$AA:BCE2             dx 0001,B02E,
                        C55A,BCE2       ; Go to $BCE2 if rising
$AA:BCEA             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,BCFA       ; Enemy link instruction = $BCFA
$AA:BCF2             dx 0005,B014,
                        80ED,BCF2       ; Go to $BCF2
$AA:BCFA             dx C618,           ; Queue torizo footsteps sound effect
                        C34A,           ; Spawn torizo landing dust clouds
                        C2D9,BD52,CDB9, ; Go to $BD52 (faceless - walking left - left leg moving) if face blown up, else go to $CDB9 (Golden Torizo - landed from backwards jump - facing left - right foot forward) if Golden Torizo
                        C5A4,BA04,BA88, ; Call $BA04 (spewing orbs) or $BA88 (sonic booms) for Bomb Torizo attack
                        80ED,B9B6       ; Go to $B9B6 (walking left - left leg moving)
}


;;; $BD0E: Instruction list - faceless - turning left ;;;
{
$AA:BD0E             dx B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        C36D,       ; Set torizo turning around flag
                        0008,A4F0
}


;;; $BD18: Instruction list - faceless - walking left - right leg moving ;;;
{
$AA:BD18             dx C377,       ; Set stepped left with left foot state
                        B09C,C6FF,  ; Enemy function = $C6FF (normal movement)
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C35B,       ; Spawn low-health initial drool if health is low
                        C618,       ; Queue torizo footsteps sound effect
                        0001,A4FA,
                        C567,BBDE,  ; Call $BBDE (explosive swipe) if Samus is less than 38h pixels in front of torizo
                        C4E5,0002,  ; Bomb Torizo walking movement - faceless - index 2
                        0005,A51C,
                        C4E5,0004,  ; Bomb Torizo walking movement - faceless - index 4
                        0005,A53E,
                        C4E5,0006,  ; Bomb Torizo walking movement - faceless - index 6
                        0005,A560,
                        C4E5,0008,  ; Bomb Torizo walking movement - faceless - index 8
                        0005,A582,
                        C4E5,000A   ; Bomb Torizo walking movement - faceless - index Ah
}


;;; $BD52: Instruction list - faceless - walking left - left leg moving ;;;
{
$AA:BD52             dx C3A0,       ; Set stepped left with right foot state
                        B09C,C6FF,  ; Enemy function = $C6FF (normal movement)
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C35B,       ; Spawn low-health initial drool if health is low
                        C618,       ; Queue torizo footsteps sound effect
                        0001,A5A4,
                        C567,BB5C,  ; Call $BB5C (explosive swipe) if Samus is less than 38h pixels in front of torizo
                        C4E5,000C,  ; Bomb Torizo walking movement - faceless - index Ch
                        0005,A5C6,
                        C4E5,000E,  ; Bomb Torizo walking movement - faceless - index Eh
                        0005,A5E8,
                        C4E5,0010,  ; Bomb Torizo walking movement - faceless - index 10h
                        0005,A60A,
                        C4E5,0012,  ; Bomb Torizo walking movement - faceless - index 12h
                        0005,A62C,
                        C4E5,0000,  ; Bomb Torizo walking movement - faceless - index 0
                        80ED,BD18   ; Go to $BD18 (right leg moving)
}
}


;;; $BD90..C209: Instruction lists - facing right ;;;
{
;;; $BD90: Unused. Instruction list - stand up - facing right ;;;
{
$AA:BD90             dx C3B6,       ; Set stepped right with left foot state
                        0001,87D0,
                        B09C,C6C6,  ; Enemy function = $C6C6 (wake enemy when Bomb Torizo chozo finishes crumbling)
                        812F,       ; Sleep
                        B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        0020,AF9C,
                        C3CC,0010,  ; Standing up movement - index 10h
                        0010,AFA6,
                        C3CC,0012,  ; Standing up movement - index 12h
                        0008,AFB0,
                        C3CC,0014,  ; Standing up movement - index 14h
                        0008,AFBA,
                        C3CC,0016,  ; Standing up movement - index 16h
                        0008,AFC4,
                        C3CC,0018,  ; Standing up movement - index 18h
                        0008,AFD6,
                        C3CC,001A,  ; Standing up movement - index 1Ah
                        0008,AFE8,
                        80ED,BE30   ; Go to $BE30 (walking right - right leg moving)
}


;;; $BDD8: Instruction list - turning right ;;;
{
$AA:BDD8             dx B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        C36D,       ; Set torizo turning around flag
                        0018,A4F0
}


;;; $BDE2: Instruction list - walking right - left leg moving ;;;
{
$AA:BDE2             dx C38A,       ; Set stepped right with right foot state
                        B09C,C6FF,  ; Enemy function = $C6FF (normal movement)
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C35B,       ; Spawn low-health initial drool if health is low
                        C618,       ; Queue torizo footsteps sound effect
                        000A,AA98,
                        C567,C058,  ; Call $C058 (explosive swipe) if Samus is less than 38h pixels in front of torizo
                        C58B,C110,  ; Go to $C110 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0016,  ; Bomb Torizo walking movement - normal - index 16h
                        0006,AABA,
                        C58B,C110,  ; Go to $C110 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0018,  ; Bomb Torizo walking movement - normal - index 18h
                        0006,AADC,
                        C58B,C110,  ; Go to $C110 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,001A,  ; Bomb Torizo walking movement - normal - index 1Ah
                        0006,AAFE,
                        C58B,C110,  ; Go to $C110 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,001C,  ; Bomb Torizo walking movement - normal - index 1Ch
                        0006,AB20,
                        C58B,C110,  ; Go to $C110 (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,001E   ; Bomb Torizo walking movement - normal - index 1Eh
}


;;; $BE30: Instruction list - walking right - right leg moving ;;;
{
$AA:BE30             dx C3B6,       ; Set stepped right with left foot state
                        B09C,C6FF,  ; Enemy function = $C6FF (normal movement)
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C35B,       ; Spawn low-health initial drool if health is low
                        C618,       ; Queue torizo footsteps sound effect
                        000A,AB42,
                        C567,BFD6,  ; Call $BFD6 (explosive swipe) if Samus is less than 38h pixels in front of torizo
                        C58B,C14C,  ; Go to $C14C (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0020,  ; Bomb Torizo walking movement - normal - index 20h
                        0006,AB64,
                        C58B,C14C,  ; Go to $C14C (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0022,  ; Bomb Torizo walking movement - normal - index 22h
                        0006,AB86,
                        C58B,C14C,  ; Go to $C14C (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0024,  ; Bomb Torizo walking movement - normal - index 24h
                        0006,ABA8,
                        C58B,C14C,  ; Go to $C14C (jumping backwards) and jump backwards if Samus is less 20h pixels in front of Bomb Torizo
                        C470,0026,  ; Bomb Torizo walking movement - normal - index 26h
                        0006,ABCA,
                        C470,0014,  ; Bomb Torizo walking movement - normal - index 14h
                        80ED,BDE2   ; Go to $BDE2 (left leg moving)
}


;;; $BE7E: Instruction list - callable - spewing chozo orbs - facing right - left foot forward ;;;
{
$AA:BE7E             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        0010,ABEC,
                        0008,AC06,
                        0008,AC20,
                        0008,AC3A,
                        0008,AC54,
                        0010,AC6E,
                        C610,       ; Queue shot torizo sound effect
                        8123,0003   ; Timer = 3
$AA:BEA0             dx C5CB,       ; Spawn Bomb Torizo's chozo orbs
                        813A,0010,  ; Wait 10h frames
                        8110,BEA0,  ; Decrement timer and go to $BEA0 if non-zero
                        0008,AC54,
                        0008,AC3A,
                        0008,AC20,
                        0048,AC06,
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BEC0: Instruction list - callable - spewing chozo orbs - facing right - right foot forward ;;;
{
$AA:BEC0             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        0010,AC88,
                        0008,ACA2,
                        0008,ACBC,
                        0008,ACD6,
                        0008,ACF0,
                        0010,AD0A,
                        C610,       ; Queue shot torizo sound effect
                        8123,0003   ; Timer = 3
$AA:BEE2             dx C5CB,       ; Spawn Bomb Torizo's chozo orbs
                        813A,0010,  ; Wait 10h frames
                        8110,BEE2,  ; Decrement timer and go to $BEE2 if non-zero
                        0008,ACF0,
                        0008,ACD6,
                        0008,ACBC,
                        0048,ACA2,
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BF02: Instruction list - callable - sonic booms - facing right - left foot forward ;;;
{
$AA:BF02             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        8123,0004   ; Timer = 4
$AA:BF0A             dx 0006,ABEC,
                        0006,AD24,
                        0006,AD3E,
                        0006,AD60,
                        0006,AD82,
                        0006,ADA4,
                        0002,AD82,
                        0002,AD60,
                        C5E3,0000,  ; Spawn Bomb Torizo sonic boom with parameter 0
                        0002,AD3E,
                        0018,AD24,
                        0006,ABEC,
                        0006,ADC6,
                        0006,ADE8,
                        0006,AE0A,
                        0006,AE2C,
                        0006,AE4E,
                        0002,AE2C,
                        0002,AE0A,
                        C5E3,0001,  ; Spawn Bomb Torizo sonic boom with parameter 1
                        0002,ADE8,
                        0038,ADC6,
                        8110,BF0A,  ; Decrement timer and go to $BF0A if non-zero
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BF6C: Instruction list - callable - sonic booms - facing right - right foot forward ;;;
{
$AA:BF6C             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        8123,0004   ; Timer = 4
$AA:BF74             dx 0006,AC88,
                        0006,AE70,
                        0006,AE8A,
                        0006,AEA4,
                        0006,AEBE,
                        0006,AED8,
                        0002,AEBE,
                        0002,AEA4,
                        C5E3,0000,  ; Spawn Bomb Torizo sonic boom with parameter 0
                        0002,AE8A,
                        0018,AE70,
                        0006,AC88,
                        0006,AEF2,
                        0006,AF14,
                        0006,AF36,
                        0006,AF58,
                        0006,AF7A,
                        0002,AF58,
                        0002,AF36,
                        C5E3,0001,  ; Spawn Bomb Torizo sonic boom with parameter 1
                        0002,AF14,
                        0038,AEF2,
                        8110,BF74,  ; Decrement timer and go to $BF74 if non-zero
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $BFD6: Instruction list - callable - explosive swipe - facing right - left foot forward ;;;
{
$AA:BFD6             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        0003,ABEC,
                        0003,AD24,
                        0003,AD3E,
                        0003,AD60,
                        0003,AD82,
                        C601,0000,  ; Spawn Bomb Torizo explosive swipe with parameter 0
                        0003,ADA4,
                        C601,0002,  ; Spawn Bomb Torizo explosive swipe with parameter 2
                        0001,AD82,
                        C601,0004,  ; Spawn Bomb Torizo explosive swipe with parameter 4
                        0001,AD60,
                        C601,0006,  ; Spawn Bomb Torizo explosive swipe with parameter 6
                        0001,AD3E,
                        C601,0008,  ; Spawn Bomb Torizo explosive swipe with parameter 8
                        0001,AD24,
                        C601,000A,  ; Spawn Bomb Torizo explosive swipe with parameter Ah
                        0003,ABEC,
                        0003,ADC6,
                        0003,ADE8,
                        0003,AE0A,
                        0003,AE2C,
                        C601,000C,  ; Spawn Bomb Torizo explosive swipe with parameter Ch
                        0003,AE4E,
                        C601,000E,  ; Spawn Bomb Torizo explosive swipe with parameter Eh
                        0001,AE2C,
                        C601,0010,  ; Spawn Bomb Torizo explosive swipe with parameter 10h
                        0001,AE0A,
                        C601,0012,  ; Spawn Bomb Torizo explosive swipe with parameter 12h
                        0001,ADE8,
                        0010,ADC6,
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $C058: Instruction list - callable - explosive swipe - facing right - right foot forward ;;;
{
$AA:C058             dx 806B,C828,  ; Enemy movement function = $C828 (attacking)
                        0003,AC88,
                        0003,AE70,
                        0003,AE8A,
                        0003,AEA4,
                        0003,AEBE,
                        C601,0000,  ; Spawn Bomb Torizo explosive swipe with parameter 0
                        0003,AED8,
                        C601,0002,  ; Spawn Bomb Torizo explosive swipe with parameter 2
                        0001,AEBE,
                        C601,0004,  ; Spawn Bomb Torizo explosive swipe with parameter 4
                        0001,AEA4,
                        C601,0006,  ; Spawn Bomb Torizo explosive swipe with parameter 6
                        0001,AE8A,
                        C601,0008,  ; Spawn Bomb Torizo explosive swipe with parameter 8
                        0001,AE70,
                        C601,000A,  ; Spawn Bomb Torizo explosive swipe with parameter Ah
                        0003,AC88,
                        0003,AEF2,
                        0003,AF14,
                        0003,AF36,
                        0003,AF58,
                        C601,000C,  ; Spawn Bomb Torizo explosive swipe with parameter Ch
                        0003,AF7A,
                        C601,000E,  ; Spawn Bomb Torizo explosive swipe with parameter Eh
                        0001,AF58,
                        C601,0010,  ; Spawn Bomb Torizo explosive swipe with parameter 10h
                        0001,AF36,
                        C601,0012,  ; Spawn Bomb Torizo explosive swipe with parameter 12h
                        0001,AF14,
                        0010,AEF2,
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C2F7        ; Return
}


;;; $C0DA: Instruction list - jumping forwards - facing right ;;;
{
$AA:C0DA             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,C0F2,      ; Enemy link instruction = $C0F2 (falling - facing right)
                        0005,B048,
                        0005,B062
$AA:C0EA             dx 0001,B07C,
                        C55A,C0EA       ; Go to $C0EA if rising
}


;;; $C0F2: Instruction list - falling - facing right ;;;
{
$AA:C0F2             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,C102       ; Enemy link instruction = $C102
$AA:C0FA             dx 0005,B062,
                        80ED,C0FA       ; Go to $C0FA
$AA:C102             dx C618,           ; Queue torizo footsteps sound effect
                        C34A,           ; Spawn torizo landing dust clouds
                        C2D9,C1CC,D315, ; Go to $C1CC (faceless - walking right - right leg moving) if face blown up, else go to $D315 (Golden Torizo - walking right - right leg moving) if Golden Torizo
                        80ED,BE30       ; Go to $BE30 (walking right - right leg moving)
}


;;; $C110: Instruction list - jumping backwards - facing right - landing right foot forward ;;;
{
$AA:C110             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,C128,      ; Enemy link instruction = $C128
                        0005,B048,
                        0005,B062
$AA:C120             dx 0001,B07C,
                        C55A,C120       ; Go to $C120 if rising
$AA:C128             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,C138       ; Enemy link instruction = $C138
$AA:C130             dx 0005,B062,
                        80ED,C130       ; Go to $C130
$AA:C138             dx C618,           ; Queue torizo footsteps sound effect
                        C34A,           ; Spawn torizo landing dust clouds
                        C2D9,C192,CDC3, ; Go to $C192 (faceless - walking right - left leg moving) if face blown up, else go to $CDC3 (Golden Torizo - landed from backwards jump - facing right - right foot forward) if Golden Torizo
                        C5A4,BEC0,BF6C, ; Call $BEC0 (spewing orbs) or $BF6C (sonic booms) for Bomb Torizo attack
                        80ED,BDE2       ; Go to $BDE2 (walking right - left leg moving)
}


;;; $C14C: Instruction list - jumping backwards - facing right - landing left foot forward ;;;
{
$AA:C14C             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,C164,      ; Enemy link instruction = $C164
                        0005,B048,
                        0005,B062
$AA:C15C             dx 0001,B07C,
                        C55A,C15C       ; Go to $C15C if rising
$AA:C164             dx 806B,C82C,      ; Enemy movement function = $C82C (jumping/falling)
                        C2ED,C174       ; Enemy link instruction = $C174
$AA:C16C             dx 0005,B062,
                        80ED,C16C       ; Go to $C16C
$AA:C174             dx C618,           ; Queue torizo footsteps sound effect
                        C34A,           ; Spawn torizo landing dust clouds
                        C2D9,C1CC,CDCD, ; Go to $C1CC (faceless - walking right - right leg moving) if face blown up, else go to $CDCD (Golden Torizo - landed from backwards jump - facing right - left foot forward) if Golden Torizo
                        C5A4,BE7E,BF02, ; Call $BE7E (spewing orbs) or $BF02 (sonic booms) for Bomb Torizo attack
                        80ED,BE30       ; Go to $BE30 (walking right - right leg moving)
}


;;; $C188: Instruction list - faceless - turning right ;;;
{
$AA:C188             dx B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        C36D,       ; Set torizo turning around flag
                        0008,A4F0
}


;;; $C192: Instruction list - faceless - walking right - left leg moving ;;;
{
$AA:C192             dx C38A,       ; Set stepped right with right foot state
                        B09C,C6FF,  ; Enemy function = $C6FF (normal movement)
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C35B,       ; Spawn low-health initial drool if health is low
                        C618,       ; Queue torizo footsteps sound effect
                        0001,AA98,
                        C567,C058,  ; Call $C058 (explosive swipe) if Samus is less than 38h pixels in front of torizo
                        C4E5,0016,  ; Bomb Torizo walking movement - faceless - index 16h
                        0005,AABA,
                        C4E5,0018,  ; Bomb Torizo walking movement - faceless - index 18h
                        0005,AADC,
                        C4E5,001A,  ; Bomb Torizo walking movement - faceless - index 1Ah
                        0005,AAFE,
                        C4E5,001C,  ; Bomb Torizo walking movement - faceless - index 1Ch
                        0005,AB20,
                        C4E5,001E   ; Bomb Torizo walking movement - faceless - index 1Eh
}


;;; $C1CC: Instruction list - faceless - walking right - right leg moving ;;;
{
$AA:C1CC             dx C3B6,       ; Set stepped right with left foot state
                        B09C,C6FF,  ; Enemy function = $C6FF (normal movement)
                        806B,C752,  ; Enemy movement function = $C752 (walking)
                        C35B,       ; Spawn low-health initial drool if health is low
                        C618,       ; Queue torizo footsteps sound effect
                        0001,AB42,
                        C567,BFD6,  ; Call $BFD6 (explosive swipe) if Samus is less than 38h pixels in front of torizo
                        C4E5,0020,  ; Bomb Torizo walking movement - faceless - index 20h
                        0005,AB64,
                        C4E5,0022,  ; Bomb Torizo walking movement - faceless - index 22h
                        0005,AB86,
                        C4E5,0024,  ; Bomb Torizo walking movement - faceless - index 24h
                        0005,ABA8,
                        C4E5,0026,  ; Bomb Torizo walking movement - faceless - index 26h
                        0005,ABCA,
                        C4E5,0014,  ; Bomb Torizo walking movement - faceless - index 14h
                        80ED,C192   ; Go to $C192 (left leg moving)
}
}
}


;;; $C20A: Make torizo jump forwards ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C20A BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C20D 30 05       BMI $05    [$C214]     ;} If torizo is facing left:
$AA:C20F A9 00 FE    LDA #$FE00             ; Enemy X velocity = -200h
$AA:C212 80 03       BRA $03    [$C217]
                                            ; Else (torizo is facing right):
$AA:C214 A9 00 02    LDA #$0200             ; Enemy X velocity = 200h

$AA:C217 9D A8 0F    STA $0FA8,x[$7E:0FA8]
$AA:C21A A9 40 FA    LDA #$FA40             ;\
$AA:C21D 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;} Enemy Y velocity = -5C0h
$AA:C220 A9 28 00    LDA #$0028             ;\
$AA:C223 9D AC 0F    STA $0FAC,x[$7E:0FAC]  ;} Enemy Y acceleration = 28h
$AA:C226 A9 01 00    LDA #$0001             ;\
$AA:C229 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:C22C 60          RTS
}


;;; $C22D: Make torizo jump backwards ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C22D BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C230 30 05       BMI $05    [$C237]     ;} If torizo is facing left:
$AA:C232 A9 00 03    LDA #$0300             ; Enemy X velocity = 300h
$AA:C235 80 03       BRA $03    [$C23A]
                                            ; Else (torizo is facing right):
$AA:C237 A9 00 FD    LDA #$FD00             ; Enemy X velocity = -300h

$AA:C23A 9D A8 0F    STA $0FA8,x[$7E:0FA8]
$AA:C23D A9 80 FB    LDA #$FB80             ;\
$AA:C240 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;} Enemy Y velocity = -480h
$AA:C243 A9 28 00    LDA #$0028             ;\
$AA:C246 9D AC 0F    STA $0FAC,x[$7E:0FAC]  ;} Enemy Y acceleration = 28h
$AA:C249 A9 01 00    LDA #$0001             ;\
$AA:C24C 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:C24F 60          RTS
}


;;; $C250: Load initial Bomb Torizo palettes ;;;
{
$AA:C250 DA          PHX
$AA:C251 A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:C254 BD E7 86    LDA $86E7,x[$AA:8705]  ;|
$AA:C257 9F 40 C3 7E STA $7EC340,x[$7E:C35E];|
$AA:C25B BD C7 86    LDA $86C7,x[$AA:86E5]  ;} Target sprite palette 2 = [$86E7..8706]
$AA:C25E 9F 20 C3 7E STA $7EC320,x[$7E:C33E];} Target sprite palette 1 = [$86C7..E6]
$AA:C262 CA          DEX                    ;|
$AA:C263 CA          DEX                    ;|
$AA:C264 10 EE       BPL $EE    [$C254]     ;/
$AA:C266 FA          PLX
$AA:C267 60          RTS
}


;;; $C268: Load normal torizo target palettes ;;;
{
$AA:C268 DA          PHX
$AA:C269 A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:C26C BD 27 87    LDA $8727,x[$AA:8745]  ;|
$AA:C26F 9F 40 C3 7E STA $7EC340,x[$7E:C35E];|
$AA:C273 BD 07 87    LDA $8707,x[$AA:8725]  ;} Target sprite palette 2 = [$8727..46]
$AA:C276 9F 20 C3 7E STA $7EC320,x[$7E:C33E];} Target sprite palette 1 = [$8707..26]
$AA:C27A CA          DEX                    ;|
$AA:C27B CA          DEX                    ;|
$AA:C27C 10 EE       BPL $EE    [$C26C]     ;/
$AA:C27E FA          PLX
$AA:C27F 60          RTS
}


;;; $C280: Load initial Golden Torizo palettes ;;;
{
$AA:C280 DA          PHX
$AA:C281 A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:C284 BD 67 87    LDA $8767,x[$AA:8785]  ;|
$AA:C287 9F 40 C3 7E STA $7EC340,x[$7E:C35E];|
$AA:C28B BD 47 87    LDA $8747,x[$AA:8765]  ;} Target sprite palette 2 = [$8767..86]
$AA:C28E 9F 20 C3 7E STA $7EC320,x[$7E:C33E];} Target sprite palette 1 = [$8747..66]
$AA:C292 CA          DEX                    ;|
$AA:C293 CA          DEX                    ;|
$AA:C294 10 EE       BPL $EE    [$C284]     ;/
$AA:C296 FA          PLX
$AA:C297 60          RTS
}


;;; $C298: Load Golden Torizo palettes ;;;
{
$AA:C298 DA          PHX
$AA:C299 A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:C29C BD A7 87    LDA $87A7,x[$AA:87C5]  ;|
$AA:C29F 9F 40 C3 7E STA $7EC340,x[$7E:C35E];|
$AA:C2A3 BD 87 87    LDA $8787,x[$AA:87A5]  ;} Target sprite palette 2 = [$87A7..C6]
$AA:C2A6 9F 20 C3 7E STA $7EC320,x[$7E:C33E];} Target sprite palette 1 = [$8787..A6]
$AA:C2AA CA          DEX                    ;|
$AA:C2AB CA          DEX                    ;|
$AA:C2AC 10 EE       BPL $EE    [$C29C]     ;/
$AA:C2AE FA          PLX
$AA:C2AF 60          RTS
}


;;; $C2B0: Load normal torizo palettes ;;;
{
$AA:C2B0 DA          PHX
$AA:C2B1 A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:C2B4 BD 27 87    LDA $8727,x[$AA:8745]  ;|
$AA:C2B7 9F 40 C1 7E STA $7EC140,x[$7E:C15E];|
$AA:C2BB BD 07 87    LDA $8707,x[$AA:8725]  ;} Sprite palette 2 = [$8727..46]
$AA:C2BE 9F 20 C1 7E STA $7EC120,x[$7E:C13E];} Sprite palette 1 = [$8707..26]
$AA:C2C2 CA          DEX                    ;|
$AA:C2C3 CA          DEX                    ;|
$AA:C2C4 10 EE       BPL $EE    [$C2B4]     ;/
$AA:C2C6 FA          PLX
$AA:C2C7 60          RTS
}


;;; $C2C8..C61F: Instructions ;;;
{
;;; $C2C8: RTL. Instruction - NOP ;;;
{
$AA:C2C8 6B          RTL
}


;;; $C2C9: Instruction - set animation lock ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C2C9 A9 77 77    LDA #$7777
$AA:C2CC 9F 08 78 7E STA $7E7808,x[$7E:7808]
$AA:C2D0 6B          RTL
}


;;; $C2D1: Instruction - clear animation lock ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C2D1 A9 00 00    LDA #$0000
$AA:C2D4 9F 08 78 7E STA $7E7808,x[$7E:7808]
$AA:C2D8 6B          RTL
}


;;; $C2D9: Instruction - go to [[Y]] if face blown up, else go to [[Y] + 2] if Golden Torizo ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C2D9 3C B6 0F    BIT $0FB6,x[$7E:0FB6]  ;\
$AA:C2DC 70 0A       BVS $0A    [$C2E8]     ;} If torizo face not blown up:
$AA:C2DE C8          INY                    ;\
$AA:C2DF C8          INY                    ;} Y += 2
$AA:C2E0 AD 9F 07    LDA $079F  [$7E:079F]  ;\
$AA:C2E3 D0 03       BNE $03    [$C2E8]     ;} If [area index] = Crateria:
$AA:C2E5 C8          INY                    ;\
$AA:C2E6 C8          INY                    ;} Y += 2
$AA:C2E7 6B          RTL                    ; Return

$AA:C2E8 B9 00 00    LDA $0000,y[$AA:C17C]  ;\
$AA:C2EB A8          TAY                    ;} Y = [[Y]]
$AA:C2EC 6B          RTL
}


;;; $C2ED: Instruction - enemy link instruction = [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C2ED B9 00 00    LDA $0000,y[$AA:BCD8]
$AA:C2F0 9F 00 78 7E STA $7E7800,x[$7E:7800]
$AA:C2F4 C8          INY
$AA:C2F5 C8          INY
$AA:C2F6 6B          RTL
}


;;; $C2F7: Instruction - return ;;;
{
;; Parameters:
;;     X: Enemy index
;; Returns:
;;     Y: Pointer to next instruction
$AA:C2F7 BF 00 78 7E LDA $7E7800,x[$7E:7800]
$AA:C2FB A8          TAY
$AA:C2FC 6B          RTL
}


;;; $C2FD: Instruction - go to [enemy gut explosion link instruction] ;;;
{
;; Parameters:
;;     X: Enemy index
;; Returns:
;;     Y: Pointer to next instruction
$AA:C2FD BF 02 78 7E LDA $7E7802,x[$7E:7802]
$AA:C301 A8          TAY
$AA:C302 6B          RTL
}


;;; $C303: Instruction - spawn 5 Bomb Torizo low-health explosions with parameter [[Y]] and sleep for 28h i-frames ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
$AA:C303 5A          PHY                    ; Save Y
$AA:C304 B9 00 00    LDA $0000,y[$AA:B0ED]  ; A = [[Y]]
$AA:C307 48          PHA
$AA:C308 A0 05 00    LDY #$0005             ; Y = 5

; LOOP
$AA:C30B 5A          PHY                    ;\
$AA:C30C A3 03       LDA $03,s  [$7E:1FEE]  ;|
$AA:C30E A0 A1 A9    LDY #$A9A1             ;} Spawn Bomb Torizo low-health explosion enemy projectile with parameter [A]
$AA:C311 22 97 80 86 JSL $868097[$86:8097]  ;|
$AA:C315 7A          PLY                    ;/
$AA:C316 88          DEY                    ; Decrement Y
$AA:C317 10 F2       BPL $F2    [$C30B]     ; If [Y] >= 0: go to LOOP
$AA:C319 68          PLA
$AA:C31A 7A          PLY                    ; Restore Y
$AA:C31B C8          INY                    ;\
$AA:C31C C8          INY                    ;|
$AA:C31D 98          TYA                    ;} Enemy instruction list pointer = [Y] + 2
$AA:C31E 9D 92 0F    STA $0F92,x[$7E:0F92]  ;/
$AA:C321 A9 28 00    LDA #$0028             ;\
$AA:C324 9D 9C 0F    STA $0F9C,x[$7E:0F9C]  ;} Enemy flash timer = 28h
$AA:C327 9D 94 0F    STA $0F94,x[$7E:0F94]  ; Enemy instruction timer = 28h
$AA:C32A 68          PLA                    ;\
$AA:C32B F4 AE C2    PEA $C2AE              ;} Terminate processing enemy instructions
$AA:C32E 6B          RTL
}


;;; $C32F: Instruction - spawn torizo death explosion and sleep for 1 i-frame ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C32F 5A          PHY                    ;\
$AA:C330 A0 AF A9    LDY #$A9AF             ;|
$AA:C333 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn torizo death explosion enemy projectile
$AA:C337 7A          PLY                    ;/
$AA:C338 98          TYA                    ;\
$AA:C339 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = [Y]
$AA:C33C A9 01 00    LDA #$0001             ;\
$AA:C33F 9D 9C 0F    STA $0F9C,x[$7E:0F9C]  ;} Enemy flash timer = 1
$AA:C342 9D 94 0F    STA $0F94,x[$7E:0F94]  ; Enemy instruction timer = 1
$AA:C345 68          PLA                    ;\
$AA:C346 F4 AE C2    PEA $C2AE              ;} Terminate processing enemy instructions
$AA:C349 6B          RTL
}


;;; $C34A: Instruction - spawn torizo landing dust clouds ;;;
{
$AA:C34A 5A          PHY
$AA:C34B A0 E5 AF    LDY #$AFE5             ;\
$AA:C34E 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Torizo landing dust cloud - right foot enemy projectile
$AA:C352 A0 F3 AF    LDY #$AFF3             ;\
$AA:C355 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Torizo landing dust cloud - left foot enemy projectile
$AA:C359 7A          PLY
$AA:C35A 6B          RTL
}


;;; $C35B: Instruction - spawn low-health initial drool if health is low ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C35B BD 8C 0F    LDA $0F8C,x[$7E:0F8C]  ;\
$AA:C35E C9 5E 01    CMP #$015E             ;} If [enemy health] < 350:
$AA:C361 B0 09       BCS $09    [$C36C]     ;/
$AA:C363 5A          PHY                    ;\
$AA:C364 A0 69 A9    LDY #$A969             ;|
$AA:C367 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo low-health initial drool enemy projectile
$AA:C36B 7A          PLY                    ;/

$AA:C36C 6B          RTL
}


;;; $C36D: Instruction - set torizo turning around flag ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C36D BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C370 09 00 40    ORA #$4000             ;} Enemy graphical properties |= 4000h
$AA:C373 9D B4 0F    STA $0FB4,x[$7E:0FB4]  ;/
$AA:C376 6B          RTL
}


;;; $C377: Instruction - set stepped left with left foot state ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C377 BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C37A 29 FF 1F    AND #$1FFF             ;} Set torizo as not turning around, facing left, foreground foot forward
$AA:C37D 9D B4 0F    STA $0FB4,x[$7E:0FB4]  ;/
$AA:C380 BF 12 78 7E LDA $7E7812,x[$7E:7812];\
$AA:C384 1A          INC A                  ;} Increment enemy step counter
$AA:C385 9F 12 78 7E STA $7E7812,x[$7E:7812];/
$AA:C389 6B          RTL
}


;;; $C38A: Instruction - set stepped right with right foot state ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C38A BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C38D 29 FF 1F    AND #$1FFF             ;|
$AA:C390 09 00 80    ORA #$8000             ;} Set torizo as not turning around, facing right, foreground foot forward
$AA:C393 9D B4 0F    STA $0FB4,x[$7E:0FB4]  ;/
$AA:C396 BF 12 78 7E LDA $7E7812,x[$7E:7812];\
$AA:C39A 1A          INC A                  ;} Increment enemy step counter
$AA:C39B 9F 12 78 7E STA $7E7812,x[$7E:7812];/
$AA:C39F 6B          RTL
}


;;; $C3A0: Instruction - set stepped left with right foot state ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C3A0 BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C3A3 29 FF 1F    AND #$1FFF             ;|
$AA:C3A6 09 00 20    ORA #$2000             ;} Set torizo as not turning around, facing left, background foot forward
$AA:C3A9 9D B4 0F    STA $0FB4,x[$7E:0FB4]  ;/
$AA:C3AC BF 12 78 7E LDA $7E7812,x[$7E:7812];\
$AA:C3B0 1A          INC A                  ;} Increment enemy step counter
$AA:C3B1 9F 12 78 7E STA $7E7812,x[$7E:7812];/
$AA:C3B5 6B          RTL
}


;;; $C3B6: Instruction - set stepped right with left foot state ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C3B6 BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C3B9 29 FF 1F    AND #$1FFF             ;|
$AA:C3BC 09 00 A0    ORA #$A000             ;} Set torizo as not turning around, facing right, background foot forward
$AA:C3BF 9D B4 0F    STA $0FB4,x[$7E:0FB4]  ;/
$AA:C3C2 BF 12 78 7E LDA $7E7812,x[$7E:7812];\
$AA:C3C6 1A          INC A                  ;} Increment enemy step counter
$AA:C3C7 9F 12 78 7E STA $7E7812,x[$7E:7812];/
$AA:C3CB 6B          RTL
}


;;; $C3CC: Instruction - standing up movement - index [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C3CC 5A          PHY
$AA:C3CD B9 00 00    LDA $0000,y[$AA:B905]  ;\
$AA:C3D0 A8          TAY                    ;|
$AA:C3D1 BD 7A 0F    LDA $0F7A,x[$7E:0F7A]  ;|
$AA:C3D4 18          CLC                    ;} Enemy X position += [$C3EE + [[Y]]]
$AA:C3D5 79 EE C3    ADC $C3EE,y[$AA:C3EE]  ;|
$AA:C3D8 9D 7A 0F    STA $0F7A,x[$7E:0F7A]  ;/
$AA:C3DB 98          TYA                    ;\
$AA:C3DC 29 0F 00    AND #$000F             ;|
$AA:C3DF A8          TAY                    ;|
$AA:C3E0 BD 7E 0F    LDA $0F7E,x[$7E:0F7E]  ;} Enemy Y position += [$C40E + [[Y]] % 10h]
$AA:C3E3 18          CLC                    ;|
$AA:C3E4 79 0E C4    ADC $C40E,y[$AA:C40E]  ;|
$AA:C3E7 9D 7E 0F    STA $0F7E,x[$7E:0F7E]  ;/
$AA:C3EA 7A          PLY
$AA:C3EB C8          INY                    ;\
$AA:C3EC C8          INY                    ;} Y += 2
$AA:C3ED 6B          RTL

; X velocities
$AA:C3EE             dw FFF7,FFFA,FFF9,0005,FFF0,FFF9, 0000,0000, ; 0..Ah: Facing left
                        0009,0006,0007,FFFB,0010,0007, 0000,0000  ; 10h..1Ah: Facing right

; Y velocities
$AA:C40E             dw 0000,FFFA,FFFA,FFF9,0000,0000, 0000,0000
}


;;; $C41E: Instruction - sitting down movement - index [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C41E 5A          PHY
$AA:C41F B9 00 00    LDA $0000,y[$AA:C9F6]  ;\
$AA:C422 A8          TAY                    ;|
$AA:C423 BD 7A 0F    LDA $0F7A,x[$7E:0F7A]  ;|
$AA:C426 38          SEC                    ;} Enemy X position -= [$C440 + [[Y]]]
$AA:C427 F9 40 C4    SBC $C440,y[$AA:C444]  ;|
$AA:C42A 9D 7A 0F    STA $0F7A,x[$7E:0F7A]  ;/
$AA:C42D 98          TYA                    ;\
$AA:C42E 29 0F 00    AND #$000F             ;|
$AA:C431 A8          TAY                    ;|
$AA:C432 BD 7E 0F    LDA $0F7E,x[$7E:0F7E]  ;} Enemy Y position -= [$C460 + [[Y]] % 10h]
$AA:C435 38          SEC                    ;|
$AA:C436 F9 60 C4    SBC $C460,y[$AA:C464]  ;|
$AA:C439 9D 7E 0F    STA $0F7E,x[$7E:0F7E]  ;/
$AA:C43C 7A          PLY
$AA:C43D C8          INY                    ;\
$AA:C43E C8          INY                    ;} Y += 2
$AA:C43F 6B          RTL

; Negated X velocities
$AA:C440             dw FFF7,FFFA,FFF9,0005,FFF0,FFF9, 0000,0000, ; 0..Ah: Facing left
                        0009,0006,0007,FFFB,0010,0007, 0000,0000  ; 10h..1Ah: Facing right

; Negated Y velocities
$AA:C460             dw 0000,FFFA,FFFA,FFF9,0000,0000, 0000,0000
}


;;; $C470: Instruction - Bomb Torizo walking movement - normal - index [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C470 5A          PHY
$AA:C471 64 12       STZ $12    [$7E:0012]
$AA:C473 B9 00 00    LDA $0000,y[$AA:B9D2]  ;\
$AA:C476 A8          TAY                    ;|
$AA:C477 B9 BD C4    LDA $C4BD,y[$AA:C4C9]  ;} Enemy X velocity = [$C4BD + [[Y]]]
$AA:C47A 85 14       STA $14    [$7E:0014]  ;|
$AA:C47C 9D A8 0F    STA $0FA8,x[$7E:0FA8]  ;/
$AA:C47F 22 AB C6 A0 JSL $A0C6AB[$A0:C6AB]  ; Move enemy right by [enemy X velocity]
$AA:C483 7A          PLY
$AA:C484 90 14       BCC $14    [$C49A]     ; If not collided with wall: go to BRANCH_NO_COLLISION
$AA:C486 A9 00 00    LDA #$0000             ;\
$AA:C489 9F 06 78 7E STA $7E7806,x          ;} Enemy turn around timer = 0
$AA:C48D BD B4 0F    LDA $0FB4,x            ;\
$AA:C490 30 04       BMI $04    [$C496]     ;} If torizo is facing left:
$AA:C492 A0 D8 BD    LDY #$BDD8             ; Y = $BDD8 (turning right)
$AA:C495 6B          RTL                    ; Return

$AA:C496 A0 62 B9    LDY #$B962             ; Y = $B962 (turning left)
$AA:C499 6B          RTL                    ; Return

; BRANCH_NO_COLLISION
$AA:C49A 22 AD C8 A0 JSL $A0C8AD[$A0:C8AD]  ; Align enemy Y position with non-square slope
$AA:C49E AD F6 0A    LDA $0AF6  [$7E:0AF6]  ;\
$AA:C4A1 38          SEC                    ;|
$AA:C4A2 FD 7A 0F    SBC $0F7A,x[$7E:0F7A]  ;} If torizo is facing Samus:
$AA:C4A5 5D B4 0F    EOR $0FB4,x[$7E:0FB4]  ;|
$AA:C4A8 10 03       BPL $03    [$C4AD]     ;/
$AA:C4AA C8          INY                    ;\
$AA:C4AB C8          INY                    ;} Y += 2
$AA:C4AC 6B          RTL                    ; Return

$AA:C4AD BF 06 78 7E LDA $7E7806,x          ;\
$AA:C4B1 D0 07       BNE $07    [$C4BA]     ;} If [enemy turn around timer] = 0:
$AA:C4B3 A9 48 00    LDA #$0048             ;\
$AA:C4B6 9F 06 78 7E STA $7E7806,x          ;} Enemy turn around timer = 48h

$AA:C4BA C8          INY                    ;\
$AA:C4BB C8          INY                    ;} Y += 2
$AA:C4BC 6B          RTL

; X velocities
$AA:C4BD             dw FFFB, 0000, FFFB, FFED, FFF0, FFF9, 0000, FFF9, FFEF, FFEE, ; 0..12h: Moving left
                        0005, 0000, 0005, 0013, 0010, 0007, 0000, 0007, 0011, 0012  ; 14h..26h: Moving right
}


;;; $C4E5: Instruction - Bomb Torizo walking movement - faceless - index [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C4E5 5A          PHY
$AA:C4E6 64 12       STZ $12    [$7E:0012]
$AA:C4E8 B9 00 00    LDA $0000,y[$AA:C1AA]  ;\
$AA:C4EB A8          TAY                    ;|
$AA:C4EC B9 32 C5    LDA $C532,y[$AA:C548]  ;} Enemy X velocity = [$C532 + [[Y]]]
$AA:C4EF 85 14       STA $14    [$7E:0014]  ;|
$AA:C4F1 9D A8 0F    STA $0FA8,x[$7E:0FA8]  ;/
$AA:C4F4 22 AB C6 A0 JSL $A0C6AB[$A0:C6AB]  ; Move enemy right by [enemy X velocity]
$AA:C4F8 7A          PLY
$AA:C4F9 90 14       BCC $14    [$C50F]     ; If not collided with wall: go to BRANCH_NO_COLLISION
$AA:C4FB A9 00 00    LDA #$0000             ;\
$AA:C4FE 9F 06 78 7E STA $7E7806,x[$7E:7806];} Enemy turn around timer = 0
$AA:C502 BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C505 30 04       BMI $04    [$C50B]     ;} If torizo is facing left:
$AA:C507 A0 88 C1    LDY #$C188             ; Y = $C188 (faceless - turning right)
$AA:C50A 6B          RTL                    ; Return

$AA:C50B A0 0E BD    LDY #$BD0E             ; Y = $BD0E (faceless - turning left)
$AA:C50E 6B          RTL                    ; Return

; BRANCH_NO_COLLISION
$AA:C50F 22 AD C8 A0 JSL $A0C8AD[$A0:C8AD]  ; Align enemy Y position with non-square slope
$AA:C513 AD F6 0A    LDA $0AF6  [$7E:0AF6]  ;\
$AA:C516 38          SEC                    ;|
$AA:C517 FD 7A 0F    SBC $0F7A,x[$7E:0F7A]  ;} If torizo is facing Samus:
$AA:C51A 5D B4 0F    EOR $0FB4,x[$7E:0FB4]  ;|
$AA:C51D 10 03       BPL $03    [$C522]     ;/
$AA:C51F C8          INY                    ;\
$AA:C520 C8          INY                    ;} Y += 2
$AA:C521 6B          RTL                    ; Return

$AA:C522 BF 06 78 7E LDA $7E7806,x[$7E:7806];\
$AA:C526 D0 07       BNE $07    [$C52F]     ;} If [enemy turn around timer] = 0:
$AA:C528 A9 48 00    LDA #$0048             ;\
$AA:C52B 9F 06 78 7E STA $7E7806,x[$7E:7806];} Enemy turn around timer = 48h

$AA:C52F C8          INY                    ;\
$AA:C530 C8          INY                    ;} Y += 2
$AA:C531 6B          RTL

; X velocities
$AA:C532             dw FFFB, 0000, FFFB, FFED, FFF0, FFF9, 0000, FFF9, FFEF, FFEE, 0005, 0000, 0005, 0013, 0010, 0007,
                        0000, 0007, 0011, 0012
}


;;; $C55A: Instruction - go to [[Y]] if rising ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C55A BD AA 0F    LDA $0FAA,x[$7E:0FAA]  ;\
$AA:C55D 30 03       BMI $03    [$C562]     ;} If [enemy Y velocity] >= 0:
$AA:C55F C8          INY                    ;\
$AA:C560 C8          INY                    ;} Y += 2
$AA:C561 6B          RTL                    ; Return

$AA:C562 B9 00 00    LDA $0000,y[$AA:BCE8]  ;\
$AA:C565 A8          TAY                    ;} Y = [[Y]]
$AA:C566 6B          RTL
}


;;; $C567: Instruction - call [[Y]] if Samus is less than 38h pixels in front of torizo ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C567 A9 38 00    LDA #$0038             ;\
$AA:C56A 22 9B BB A0 JSL $A0BB9B[$A0:BB9B]  ;} If X distance between enemy and Samus is less than 38h: go to BRANCH_NEAR
$AA:C56E 90 03       BCC $03    [$C573]     ;/

; BRANCH_NO_GO_TO
$AA:C570 C8          INY                    ;\
$AA:C571 C8          INY                    ;} Y += 2
$AA:C572 6B          RTL                    ; Return

; BRANCH_NEAR
$AA:C573 AD F6 0A    LDA $0AF6  [$7E:0AF6]  ;\
$AA:C576 38          SEC                    ;|
$AA:C577 FD 7A 0F    SBC $0F7A,x[$7E:0F7A]  ;} If torizo is facing away from Samus: go to BRANCH_NO_GO_TO
$AA:C57A 5D B4 0F    EOR $0FB4,x[$7E:0FB4]  ;|
$AA:C57D 10 F1       BPL $F1    [$C570]     ;/
$AA:C57F 98          TYA                    ;\
$AA:C580 1A          INC A                  ;|
$AA:C581 1A          INC A                  ;} Enemy link instruction = [Y] + 2
$AA:C582 9F 00 78 7E STA $7E7800,x[$7E:7800];/
$AA:C586 B9 00 00    LDA $0000,y[$AA:B980]  ;\
$AA:C589 A8          TAY                    ;} Y = [[Y]]
$AA:C58A 6B          RTL
}


;;; $C58B: Instruction - go to [[Y]] and jump backwards if Samus is less 20h pixels in front of Bomb Torizo ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C58B A9 20 00    LDA #$0020             ;\
$AA:C58E 22 9B BB A0 JSL $A0BB9B[$A0:BB9B]  ;} If X distance between enemy and Samus is less than 20h:
$AA:C592 B0 0D       BCS $0D    [$C5A1]     ;/
$AA:C594 20 A7 D3    JSR $D3A7  [$AA:D3A7]  ;\
$AA:C597 30 08       BMI $08    [$C5A1]     ;} If torizo is facing Samus:
$AA:C599 20 2D C2    JSR $C22D  [$AA:C22D]  ; Make torizo jump backwards
$AA:C59C B9 00 00    LDA $0000,y[$AA:B9CE]  ;\
$AA:C59F A8          TAY                    ;} Y = [[Y]]
$AA:C5A0 6B          RTL

$AA:C5A1 C8          INY                    ;\
$AA:C5A2 C8          INY                    ;} Y += 2
$AA:C5A3 6B          RTL
}


;;; $C5A4: Instruction - call [[Y]] or [[Y] + 2] for Bomb Torizo attack ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C5A4 98          TYA                    ;\
$AA:C5A5 1A          INC A                  ;|
$AA:C5A6 1A          INC A                  ;|
$AA:C5A7 1A          INC A                  ;} Enemy link instruction = [Y] + 4
$AA:C5A8 1A          INC A                  ;|
$AA:C5A9 9F 00 78 7E STA $7E7800,x[$7E:7800];/
$AA:C5AD AD C6 09    LDA $09C6  [$7E:09C6]  ;\
$AA:C5B0 C9 05 00    CMP #$0005             ;} If [Samus missiles] < 5: go to BRANCH_SPEW_ORBS
$AA:C5B3 90 0C       BCC $0C    [$C5C1]     ;/
$AA:C5B5 AD F6 0A    LDA $0AF6  [$7E:0AF6]  ;\
$AA:C5B8 4A          LSR A                  ;|
$AA:C5B9 6D B6 05    ADC $05B6  [$7E:05B6]  ;} If [Samus X position] / 2 + [frame counter] & 8 = 0: go to BRANCH_SONIC_BOOMS
$AA:C5BC 89 08 00    BIT #$0008             ;|
$AA:C5BF F0 05       BEQ $05    [$C5C6]     ;/

; BRANCH_SPEW_ORBS
$AA:C5C1 B9 00 00    LDA $0000,y[$AA:BD06]  ; Y = [[Y]]
$AA:C5C4 80 03       BRA $03    [$C5C9]     ; Return

; BRANCH_SONIC_BOOMS
$AA:C5C6 B9 02 00    LDA $0002,y            ; Y = [[Y] + 2]

$AA:C5C9 A8          TAY
$AA:C5CA 6B          RTL
}


;;; $C5CB: Instruction - spawn Bomb Torizo's chozo orbs ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C5CB 5A          PHY
$AA:C5CC A0 5E AD    LDY #$AD5E             ;\
$AA:C5CF 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo's chozo orbs enemy projectile
$AA:C5D3 A0 5E AD    LDY #$AD5E             ;\
$AA:C5D6 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo's chozo orbs enemy projectile
$AA:C5DA A0 5E AD    LDY #$AD5E             ;\
$AA:C5DD 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo's chozo orbs enemy projectile
$AA:C5E1 7A          PLY
$AA:C5E2 6B          RTL
}


;;; $C5E3: Instruction - spawn Bomb Torizo sonic boom with parameter [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C5E3 5A          PHY
$AA:C5E4 B9 00 00    LDA $0000,y
$AA:C5E7 A0 A8 AE    LDY #$AEA8             ;\
$AA:C5EA 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo sonic boom enemy projectile
$AA:C5EE 7A          PLY
$AA:C5EF C8          INY
$AA:C5F0 C8          INY
$AA:C5F1 6B          RTL
}


;;; $C5F2: Instruction - spawn Golden Torizo sonic boom with parameter [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C5F2 5A          PHY
$AA:C5F3 B9 00 00    LDA $0000,y[$AA:CD05]
$AA:C5F6 A0 B6 AE    LDY #$AEB6             ;\
$AA:C5F9 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Golden Torizo sonic boom enemy projectile
$AA:C5FD 7A          PLY
$AA:C5FE C8          INY
$AA:C5FF C8          INY
$AA:C600 6B          RTL
}


;;; $C601: Instruction - spawn Bomb Torizo explosive swipe with parameter [[Y]] ;;;
{
;; Parameters:
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:C601 5A          PHY
$AA:C602 B9 00 00    LDA $0000,y[$AA:BBF8]  ; A = [[Y]]
$AA:C605 A0 85 A9    LDY #$A985             ;\
$AA:C608 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Bomb Torizo explosive swipe enemy projectile
$AA:C60C 7A          PLY
$AA:C60D C8          INY                    ;\
$AA:C60E C8          INY                    ;} Y += 2
$AA:C60F 6B          RTL
}


;;; $C610: Instruction - queue shot torizo sound effect ;;;
{
$AA:C610 A9 27 00    LDA #$0027             ;\
$AA:C613 22 CB 90 80 JSL $8090CB[$80:90CB]  ;} Queue sound 27h, sound library 2, max queued sounds allowed = 6 (shot torizo)
$AA:C617 6B          RTL
}


;;; $C618: Instruction - queue torizo footsteps sound effect ;;;
{
$AA:C618 A9 4B 00    LDA #$004B             ;\
$AA:C61B 22 CB 90 80 JSL $8090CB[$80:90CB]  ;} Queue sound 4Bh, sound library 2, max queued sounds allowed = 6 (chozo / torizo footsteps)
$AA:C61F 6B          RTL
}
}


;;; $C620: Handle low-health initial drool ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C620 AD 9F 07    LDA $079F  [$7E:079F]  ;\
$AA:C623 F0 03       BEQ $03    [$C628]     ;} If [area index] != Crateria:
$AA:C625 4C 42 C6    JMP $C642  [$AA:C642]  ; Return

$AA:C628 AD E5 05    LDA $05E5  [$7E:05E5]  ;\
$AA:C62B 29 42 81    AND #$8142             ;} If [random number] & 8142h = 0: (1/16 chance)
$AA:C62E D0 11       BNE $11    [$C641]     ;/
$AA:C630 BD 8C 0F    LDA $0F8C,x[$7E:0F8C]  ;\
$AA:C633 F0 0C       BEQ $0C    [$C641]     ;|
$AA:C635 C9 5E 01    CMP #$015E             ;} If 0 < [enemy health] < 350:
$AA:C638 B0 07       BCS $07    [$C641]     ;/
$AA:C63A A0 69 A9    LDY #$A969             ;\
$AA:C63D 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Bomb Torizo low-health initial drool enemy projectile

$AA:C641 60          RTS

$AA:C642 60          RTS
}


;;; $C643: Handle falling ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C643 64 12       STZ $12    [$7E:0012]  ;\
$AA:C645 64 14       STZ $14    [$7E:0014]  ;|
$AA:C647 BD AA 0F    LDA $0FAA,x[$7E:0FAA]  ;|
$AA:C64A 10 02       BPL $02    [$C64E]     ;|
$AA:C64C C6 14       DEC $14    [$7E:0014]  ;} Move enemy down by [enemy Y velocity] / 100h
                                            ;|
$AA:C64E 85 13       STA $13    [$7E:0013]  ;|
$AA:C650 22 86 C7 A0 JSL $A0C786[$A0:C786]  ;/
$AA:C654 B0 0B       BCS $0B    [$C661]     ; If not collided with block:
$AA:C656 BD AA 0F    LDA $0FAA,x[$7E:0FAA]  ;\
$AA:C659 18          CLC                    ;|
$AA:C65A 69 28 00    ADC #$0028             ;} Enemy Y velocity += 28h
$AA:C65D 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;/
$AA:C660 60          RTS                    ; Return

$AA:C661 BD AA 0F    LDA $0FAA,x[$7E:0FAA]  ;\
$AA:C664 30 17       BMI $17    [$C67D]     ;} If [enemy Y velocity] >= 0:
$AA:C666 C9 00 01    CMP #$0100             ;\
$AA:C669 F0 12       BEQ $12    [$C67D]     ;} If [enemy Y velocity] != 100h (initial Y velocity):
$AA:C66B A9 04 00    LDA #$0004             ;\
$AA:C66E 8D 3E 18    STA $183E  [$7E:183E]  ;} Earthquake type = BG1 only, 2 pixel displacement, vertical
$AA:C671 A9 20 00    LDA #$0020             ;\
$AA:C674 8D 40 18    STA $1840  [$7E:1840]  ;} Earthquake timer = 20h
$AA:C677 A9 00 01    LDA #$0100             ;\
$AA:C67A 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;} Enemy Y velocity = 100h

$AA:C67D 60          RTS
}


;;; $C67E: Hurt AI - enemy $EEFF/$EF3F (Bomb Torizo) ;;;
{
$AA:C67E AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:C681 20 20 C6    JSR $C620  [$AA:C620]  ; Handle low-health initial drool
$AA:C684 BD 9C 0F    LDA $0F9C,x[$7E:0F9C]  ;\
$AA:C687 4A          LSR A                  ;} If [enemy flash timer] % 2 = 0:
$AA:C688 B0 05       BCS $05    [$C68F]     ;/
$AA:C68A 20 B0 C2    JSR $C2B0  [$AA:C2B0]  ; Load normal torizo palettes
$AA:C68D 80 14       BRA $14    [$C6A3]     ; Return

$AA:C68F DA          PHX                    ;\
$AA:C690 A2 1E 00    LDX #$001E             ;|
                                            ;|
$AA:C693 A9 FF 7F    LDA #$7FFF             ;|
$AA:C696 9F 40 C1 7E STA $7EC140,x[$7E:C15E];|
$AA:C69A 9F 20 C1 7E STA $7EC120,x[$7E:C13E];} Sprite palette 1/2 = 7FFFh
$AA:C69E CA          DEX                    ;|
$AA:C69F CA          DEX                    ;|
$AA:C6A0 10 F1       BPL $F1    [$C693]     ;|
$AA:C6A2 FA          PLX                    ;/

$AA:C6A3 6B          RTL
}


;;; $C6A4: Main AI - enemy $EEFF/$EF3F (Bomb Torizo) ;;;
{
$AA:C6A4 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:C6A7 FC B0 0F    JSR ($0FB0,x)[$AA:C6BF]; Execute [enemy function]
$AA:C6AA 6B          RTL
}


;;; $C6AB: RTS ;;;
{
$AA:C6AB 60          RTS
}


;;; $C6AC: Unused ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C6AC 20 43 C6    JSR $C643  [$AA:C643]  ; Handle falling
$AA:C6AF A9 00 06    LDA #$0600             ;\
$AA:C6B2 22 F7 DA 82 JSL $82DAF7[$82:DAF7]  ;} Advance gradual colour change of sprite palettes 1/2 - denominator = Ch
$AA:C6B6 B0 06       BCS $06    [$C6BE]     ; If not reached target colour:
$AA:C6B8 A9 AB C6    LDA #$C6AB             ;\
$AA:C6BB 9D B0 0F    STA $0FB0,x            ;} Enemy function = RTS

$AA:C6BE 60          RTS
}


;;; $C6BF: Torizo function - simple movement ;;;
{
;; Parameters:
;;     X: Enemy index

; Used for
;     Bomb Torizo after statue finishes crumbling and before walking starts
;     Golden Torizo when falling from ceiling
;     Turning
$AA:C6BF 20 20 C6    JSR $C620  [$AA:C620]  ; Handle low-health initial drool
$AA:C6C2 20 43 C6    JSR $C643  [$AA:C643]  ; Handle falling
$AA:C6C5 60          RTS
}


;;; $C6C6: Torizo function - wake enemy when Bomb Torizo chozo finishes crumbling ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C6C6 BD 86 0F    LDA $0F86,x[$7E:0F86]  ;\
$AA:C6C9 09 00 04    ORA #$0400             ;} Set enemy as intangible
$AA:C6CC 9D 86 0F    STA $0F86,x[$7E:0F86]  ;/
$AA:C6CF DA          PHX
$AA:C6D0 A2 4E 00    LDX #$004E             ; X = 4Eh (PLM index)

$AA:C6D3 BD 37 1C    LDA $1C37,x[$7E:1C85]  ;\
$AA:C6D6 C9 EA D6    CMP #$D6EA             ;} If [PLM ID] = $D6EA (Bomb Torizo's crumbling chozo): return
$AA:C6D9 F0 22       BEQ $22    [$C6FD]     ;/
$AA:C6DB CA          DEX                    ;\
$AA:C6DC CA          DEX                    ;} X -= 2
$AA:C6DD 10 F4       BPL $F4    [$C6D3]     ; If [X] >= 0: go to LOOP
$AA:C6DF FA          PLX
$AA:C6E0 AD 96 B0    LDA $B096  [$AA:B096]  ;\
$AA:C6E3 22 C1 8F 80 JSL $808FC1[$80:8FC1]  ;} Queue song 1 music track
$AA:C6E7 BD 86 0F    LDA $0F86,x[$7E:0F86]  ;\
$AA:C6EA 29 FF FB    AND #$FBFF             ;} Set enemy as tangible
$AA:C6ED 9D 86 0F    STA $0F86,x[$7E:0F86]  ;/
$AA:C6F0 FE 92 0F    INC $0F92,x[$7E:0F92]  ;\
$AA:C6F3 FE 92 0F    INC $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer += 2
$AA:C6F6 A9 01 00    LDA #$0001             ;\
$AA:C6F9 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:C6FC 60          RTS

$AA:C6FD FA          PLX
$AA:C6FE 60          RTS
}


;;; $C6FF: Torizo function - normal movement ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C6FF 20 20 C6    JSR $C620  [$AA:C620]  ; Handle low-health initial drool
$AA:C702 3C B6 0F    BIT $0FB6,x[$7E:0FB6]  ;\
$AA:C705 30 1C       BMI $1C    [$C723]     ;} If torizo gut not blown up:
$AA:C707 BD 8C 0F    LDA $0F8C,x[$7E:0F8C]  ;\
$AA:C70A C9 5E 01    CMP #$015E             ;} If [enemy health] < 350:
$AA:C70D B0 14       BCS $14    [$C723]     ;/
$AA:C70F BD 92 0F    LDA $0F92,x[$7E:0F92]  ;\
$AA:C712 9F 02 78 7E STA $7E7802,x[$7E:7802];} Enemy gut explosion link instruction = [enemy instruction list pointer]
$AA:C716 A9 E5 B0    LDA #$B0E5             ;\
$AA:C719 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = $B0E5 (blow up Bomb Torizo's gut)
$AA:C71C A9 01 00    LDA #$0001             ;\
$AA:C71F 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:C722 60          RTS                    ; Return

$AA:C723 3C B6 0F    BIT $0FB6,x[$7E:0FB6]  ;\
$AA:C726 70 26       BVS $26    [$C74E]     ;} If torizo face blown up: go to BRANCH_NO_CHANGE
$AA:C728 BD 8C 0F    LDA $0F8C,x[$7E:0F8C]  ;\
$AA:C72B C9 64 00    CMP #$0064             ;} If [enemy health] >= 100: go to BRANCH_NO_CHANGE
$AA:C72E B0 1E       BCS $1E    [$C74E]     ;/
$AA:C730 BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:C733 30 05       BMI $05    [$C73A]     ;} If torizo is facing left:
$AA:C735 A9 88 C1    LDA #$C188             ; Enemy link instruction = $C188 (faceless - turning right)
$AA:C738 80 03       BRA $03    [$C73D]
                                            ; Else (torizo is facing right):
$AA:C73A A9 0E BD    LDA #$BD0E             ; Enemy link instruction = $BD0E (faceless - turning left)

$AA:C73D 9F 00 78 7E STA $7E7800,x[$7E:7800]
$AA:C741 A9 55 B1    LDA #$B155             ;\
$AA:C744 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = $B155 (blow up Bomb Torizo's face)
$AA:C747 A9 01 00    LDA #$0001             ;\
$AA:C74A 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:C74D 60          RTS                    ; Return

; BRANCH_NO_CHANGE
$AA:C74E FC B2 0F    JSR ($0FB2,x)[$AA:C752]; Execute [enemy movement function]
$AA:C751 60          RTS
}


;;; $C752: Torizo movement function - walking ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C752 3C B6 0F    BIT $0FB6,x[$7E:0FB6]  ;\
$AA:C755 50 03       BVC $03    [$C75A]     ;} If torizo face blown up:
$AA:C757 4C C1 C7    JMP $C7C1  [$AA:C7C1]  ; Go to BRANCH_FACELESS

$AA:C75A BF 06 78 7E LDA $7E7806,x[$7E:7806];\
$AA:C75E F0 25       BEQ $25    [$C785]     ;} If [enemy turn around timer] = 0: go to BRANCH_NOT_TURNING
$AA:C760 3A          DEC A                  ;\
$AA:C761 9F 06 78 7E STA $7E7806,x          ;} Decrement enemy turn around timer
$AA:C765 D0 1E       BNE $1E    [$C785]     ; If [enemy turn around timer] != 0: go to BRANCH_NOT_TURNING
$AA:C767 A9 00 00    LDA #$0000             ;\
$AA:C76A 9F 06 78 7E STA $7E7806,x          ;} >_<;
$AA:C76E BD B4 0F    LDA $0FB4,x            ;\
$AA:C771 30 05       BMI $05    [$C778]     ;} If torizo is facing left:
$AA:C773 A9 D8 BD    LDA #$BDD8             ; Enemy instruction list pointer = $BDD8 (turning right)
$AA:C776 80 03       BRA $03    [$C77B]
                                            ; Else (torizo is facing right):
$AA:C778 A9 62 B9    LDA #$B962             ; Enemy instruction list pointer = $B962 (turning left)

$AA:C77B 9D 92 0F    STA $0F92,x
$AA:C77E A9 01 00    LDA #$0001             ;\
$AA:C781 9D 94 0F    STA $0F94,x            ;} Enemy instruction timer = 1
$AA:C784 60          RTS                    ; Return

; BRANCH_NOT_TURNING
$AA:C785 64 12       STZ $12    [$7E:0012]  ;\
$AA:C787 BD A8 0F    LDA $0FA8,x[$7E:0FA8]  ;|
$AA:C78A 10 04       BPL $04    [$C790]     ;|
$AA:C78C 49 FF FF    EOR #$FFFF             ;|
$AA:C78F 1A          INC A                  ;|
                                            ;|
$AA:C790 1A          INC A                  ;} $14.$12 = min(Fh, |[enemy X velocity]| + 1)
$AA:C791 C9 10 00    CMP #$0010             ;|
$AA:C794 90 03       BCC $03    [$C799]     ;|
$AA:C796 A9 0F 00    LDA #$000F             ;|
                                            ;|
$AA:C799 85 14       STA $14    [$7E:0014]  ;/
$AA:C79B 22 86 C7 A0 JSL $A0C786[$A0:C786]  ; Move enemy down by [$14].[$12]
$AA:C79F B0 1F       BCS $1F    [$C7C0]     ; If collided with block: return
$AA:C7A1 BD B4 0F    LDA $0FB4,x            ;\
$AA:C7A4 30 05       BMI $05    [$C7AB]     ;} If torizo is facing left:
$AA:C7A6 A9 78 BC    LDA #$BC78             ; Enemy instruction list pointer = $BC78 (falling - facing left)
$AA:C7A9 80 03       BRA $03    [$C7AE]
                                            ; Else (torizo is facing right):
$AA:C7AB A9 F2 C0    LDA #$C0F2             ; Enemy instruction list pointer = $C0F2 (falling - facing right)

$AA:C7AE 9D 92 0F    STA $0F92,x
$AA:C7B1 A9 01 00    LDA #$0001             ;\
$AA:C7B4 9D 94 0F    STA $0F94,x            ;} Enemy instruction timer = 1
$AA:C7B7 A9 00 01    LDA #$0100             ;\
$AA:C7BA 9D AA 0F    STA $0FAA,x            ;} Enemy Y velocity = 100h
$AA:C7BD 9E A8 0F    STZ $0FA8,x            ; Enemy X velocity = 0

$AA:C7C0 60          RTS                    ; Return

; BRANCH_FACELESS
$AA:C7C1 BF 06 78 7E LDA $7E7806,x[$7E:7806];\
$AA:C7C5 F0 25       BEQ $25    [$C7EC]     ;} If [enemy turn around timer] = 0: go to BRANCH_FACELESS_NOT_TURNING
$AA:C7C7 3A          DEC A                  ;\
$AA:C7C8 9F 06 78 7E STA $7E7806,x[$7E:7806];} Decrement enemy turn around timer
$AA:C7CC D0 1E       BNE $1E    [$C7EC]     ; If [enemy turn around timer] != 0: go to BRANCH_FACELESS_NOT_TURNING
$AA:C7CE A9 00 00    LDA #$0000             ;\
$AA:C7D1 9F 06 78 7E STA $7E7806,x          ;} >_<;
$AA:C7D5 BD B4 0F    LDA $0FB4,x            ;\
$AA:C7D8 30 05       BMI $05    [$C7DF]     ;} If torizo is facing left:
$AA:C7DA A9 88 C1    LDA #$C188             ; Enemy instruction list pointer = $C188 (faceless - turning right)
$AA:C7DD 80 03       BRA $03    [$C7E2]
                                            ; Else (torizo is facing right):
$AA:C7DF A9 0E BD    LDA #$BD0E             ; Enemy instruction list pointer = $BD0E (faceless - turning left)

$AA:C7E2 9D 92 0F    STA $0F92,x
$AA:C7E5 A9 01 00    LDA #$0001             ;\
$AA:C7E8 9D 94 0F    STA $0F94,x            ;} Enemy instruction timer = 1
$AA:C7EB 60          RTS                    ; Return

; BRANCH_FACELESS_NOT_TURNING
$AA:C7EC 64 12       STZ $12    [$7E:0012]  ;\
$AA:C7EE BD A8 0F    LDA $0FA8,x[$7E:0FA8]  ;|
$AA:C7F1 10 04       BPL $04    [$C7F7]     ;|
$AA:C7F3 49 FF FF    EOR #$FFFF             ;|
$AA:C7F6 1A          INC A                  ;|
                                            ;|
$AA:C7F7 1A          INC A                  ;} $14.$12 = min(Fh, |[enemy X velocity]| + 1)
$AA:C7F8 C9 10 00    CMP #$0010             ;|
$AA:C7FB 90 03       BCC $03    [$C800]     ;|
$AA:C7FD A9 0F 00    LDA #$000F             ;|
                                            ;|
$AA:C800 85 14       STA $14    [$7E:0014]  ;/
$AA:C802 22 86 C7 A0 JSL $A0C786[$A0:C786]  ; Move enemy down by [$14].[$12]
$AA:C806 B0 1F       BCS $1F    [$C827]     ; If collided with block: return
$AA:C808 BD B4 0F    LDA $0FB4,x            ;\
$AA:C80B 30 05       BMI $05    [$C812]     ;} If torizo is facing left:
$AA:C80D A9 78 BC    LDA #$BC78             ; Enemy instruction list pointer = $BC78 (falling - facing left)
$AA:C810 80 03       BRA $03    [$C815]
                                            ; Else (torizo is facing right):
$AA:C812 A9 F2 C0    LDA #$C0F2             ; Enemy instruction list pointer = $C0F2 (falling - facing right)

$AA:C815 9D 92 0F    STA $0F92,x
$AA:C818 A9 01 00    LDA #$0001             ;\
$AA:C81B 9D 94 0F    STA $0F94,x            ;} Enemy instruction timer = 1
$AA:C81E A9 00 01    LDA #$0100             ;\
$AA:C821 9D AA 0F    STA $0FAA,x            ;} Enemy Y velocity = 100h
$AA:C824 9E A8 0F    STZ $0FA8,x            ; Enemy X velocity = 0

$AA:C827 60          RTS
}


;;; $C828: Torizo movement function - attacking ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C828 20 43 C6    JSR $C643  [$AA:C643]  ; Handle falling
$AA:C82B 60          RTS
}


;;; $C82C: Torizo movement function - jumping/falling ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:C82C 64 12       STZ $12    [$7E:0012]  ;\
$AA:C82E 64 14       STZ $14    [$7E:0014]  ;|
$AA:C830 BD A8 0F    LDA $0FA8,x[$7E:0FA8]  ;|
$AA:C833 10 02       BPL $02    [$C837]     ;} $14.$12 = [enemy X velocity] / 100h
$AA:C835 C6 14       DEC $14    [$7E:0014]  ;|
                                            ;|
$AA:C837 85 13       STA $13    [$7E:0013]  ;/
$AA:C839 22 AB C6 A0 JSL $A0C6AB[$A0:C6AB]  ; Move enemy right by [$14].[$12]
$AA:C83D 22 AD C8 A0 JSL $A0C8AD[$A0:C8AD]  ; Align enemy Y position with non-square slope
$AA:C841 64 12       STZ $12    [$7E:0012]  ;\
$AA:C843 64 14       STZ $14    [$7E:0014]  ;|
$AA:C845 BD AA 0F    LDA $0FAA,x[$7E:0FAA]  ;|
$AA:C848 10 02       BPL $02    [$C84C]     ;} $14.$12 = [enemy Y velocity] / 100h
$AA:C84A C6 14       DEC $14    [$7E:0014]  ;|
                                            ;|
$AA:C84C 85 13       STA $13    [$7E:0013]  ;/
$AA:C84E 22 86 C7 A0 JSL $A0C786[$A0:C786]  ; Move enemy down by [$14].[$12]
$AA:C852 B0 0B       BCS $0B    [$C85F]     ; If not collided with block:
$AA:C854 BD AA 0F    LDA $0FAA,x[$7E:0FAA]  ;\
$AA:C857 18          CLC                    ;|
$AA:C858 7D AC 0F    ADC $0FAC,x[$7E:0FAC]  ;} Enemy Y velocity += [enemy Y acceleration]
$AA:C85B 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;/
$AA:C85E 60          RTS                    ; Return

$AA:C85F BF 00 78 7E LDA $7E7800,x[$7E:7800];\
$AA:C863 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = [enemy link instruction]
$AA:C866 A9 01 00    LDA #$0001             ;\
$AA:C869 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:C86C A9 00 01    LDA #$0100             ;\
$AA:C86F 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;} Enemy Y velocity = 100h
$AA:C872 A9 04 00    LDA #$0004             ;\
$AA:C875 8D 3E 18    STA $183E  [$7E:183E]  ;} Earthquake type = BG1 only, 2 pixel displacement, vertical
$AA:C878 A9 20 00    LDA #$0020             ;\
$AA:C87B 8D 40 18    STA $1840  [$7E:1840]  ;} Earthquake timer = 20h
$AA:C87E 60          RTS
}


;;; $C87F: Initialisation AI - enemy $EEFF/$EF3F/$EF7F/$EFBF (torizos) ;;;
{
; $AA:C91E is the GT code
; The torizo orb enemies ($EF3F/$EFBF) are never spawned, they're only used for drop chances (see torizo chozo orb shot instruction list $86:AB68)
$AA:C87F A9 04 00    LDA #$0004             ;\
$AA:C882 22 DC 81 80 JSL $8081DC[$80:81DC]  ;} If area torizo is dead:
$AA:C886 90 0D       BCC $0D    [$C895]     ;/
$AA:C888 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:C88B BD 86 0F    LDA $0F86,x            ;\
$AA:C88E 09 00 02    ORA #$0200             ;} Mark enemy for deletion
$AA:C891 9D 86 0F    STA $0F86,x            ;/
$AA:C894 6B          RTL                    ; Return

$AA:C895 AC 9F 07    LDY $079F  [$7E:079F]  ; Y = [area index] (0 = Crateria, 2 = Norfair)
$AA:C898 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:C89B BD 86 0F    LDA $0F86,x[$7E:0F86]  ;\
$AA:C89E 19 6B C9    ORA $C96B,y[$AA:C96B]  ;} Set enemy to process instructions and process whilst off-screen
$AA:C8A1 9D 86 0F    STA $0F86,x[$7E:0F86]  ;/
$AA:C8A4 BD 88 0F    LDA $0F88,x[$7E:0F88]  ;\
$AA:C8A7 09 04 00    ORA #$0004             ;} Enable enemy extended spritemap format
$AA:C8AA 9D 88 0F    STA $0F88,x[$7E:0F88]  ;/
$AA:C8AD B9 6F C9    LDA $C96F,y[$AA:C96F]  ;\
$AA:C8B0 9D 82 0F    STA $0F82,x[$7E:0F82]  ;} Enemy X radius = 12h
$AA:C8B3 B9 73 C9    LDA $C973,y[$AA:C973]  ;\
$AA:C8B6 9D 84 0F    STA $0F84,x[$7E:0F84]  ;} Enemy Y radius = [$C973 + [Y]]
$AA:C8B9 A9 BF C6    LDA #$C6BF             ;\
$AA:C8BC 9D B0 0F    STA $0FB0,x[$7E:0FB0]  ;} Enemy function = $C6BF (simple movement)
$AA:C8BF A9 01 00    LDA #$0001             ;\
$AA:C8C2 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:C8C5 9E 90 0F    STZ $0F90,x[$7E:0F90]  ; Enemy timer = 0
$AA:C8C8 9E 96 0F    STZ $0F96,x[$7E:0F96]  ; Enemy palette index = 0
$AA:C8CB A9 5E C9    LDA #$C95E             ;\
$AA:C8CE 9D B2 0F    STA $0FB2,x[$7E:0FB2]  ;} Enemy movement function = RTS
$AA:C8D1 B9 67 C9    LDA $C967,y[$AA:C967]  ;\
$AA:C8D4 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = [$C967 + [Y]]
$AA:C8D7 A9 D0 87    LDA #$87D0             ;\
$AA:C8DA 9D 8E 0F    STA $0F8E,x[$7E:0F8E]  ;} Enemy spritemap pointer = $87D0 (no effect)
$AA:C8DD B9 5F C9    LDA $C95F,y[$AA:C95F]  ;\
$AA:C8E0 9D 7A 0F    STA $0F7A,x[$7E:0F7A]  ;} Enemy X position = [$C95F + [Y]]
$AA:C8E3 B9 63 C9    LDA $C963,y[$AA:C963]  ;\
$AA:C8E6 9D 7E 0F    STA $0F7E,x[$7E:0F7E]  ;} Enemy Y position = [$C963 + [Y]]
$AA:C8E9 9E A8 0F    STZ $0FA8,x[$7E:0FA8]  ; Enemy X velocity = 0
$AA:C8EC A9 00 01    LDA #$0100             ;\
$AA:C8EF 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;} Enemy Y velocity = 100h
$AA:C8F2 A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:C8F5 BD A7 86    LDA $86A7,x[$AA:86C5]  ;|
$AA:C8F8 9F E0 C3 7E STA $7EC3E0,x[$7E:C3FE];|
$AA:C8FC BD 87 86    LDA $8687,x[$AA:86A5]  ;} Target sprite palette 7 = [$86A7..C6] (Bomb Torizo statue)
$AA:C8FF 9F 60 C3 7E STA $7EC360,x[$7E:C37E];} Target sprite palette 3 = [$8687..A6] (orb projectile)
$AA:C903 CA          DEX                    ;|
$AA:C904 CA          DEX                    ;|
$AA:C905 10 EE       BPL $EE    [$C8F5]     ;/
$AA:C907 AD 9F 07    LDA $079F  [$7E:079F]  ;\
$AA:C90A D0 08       BNE $08    [$C914]     ;} If [area index] = Crateria:
$AA:C90C 20 50 C2    JSR $C250  [$AA:C250]  ; Load initial Bomb Torizo palettes
$AA:C90F 22 32 DD 88 JSL $88DD32[$88:DD32]  ; Spawn Bomb Torizo haze
$AA:C913 6B          RTL                    ; Return

$AA:C914 20 80 C2    JSR $C280  [$AA:C280]  ; Load initial Golden Torizo palettes
$AA:C917 A5 8B       LDA $8B    [$7E:008B]  ;\
$AA:C919 C9 C0 C0    CMP #$C0C0             ;} If pressing exactly BYAX:
$AA:C91C D0 3F       BNE $3F    [$C95D]     ;/
$AA:C91E A9 BC 02    LDA #$02BC             ;\
$AA:C921 8D C2 09    STA $09C2  [$7E:09C2]  ;} Samus health = Samus max health = 700
$AA:C924 8D C4 09    STA $09C4  [$7E:09C4]  ;/
$AA:C927 A9 2C 01    LDA #$012C             ;\
$AA:C92A 8D D4 09    STA $09D4  [$7E:09D4]  ;} Samus reserve health = Samus max reserve health = 300
$AA:C92D 8D D6 09    STA $09D6  [$7E:09D6]  ;/
$AA:C930 A9 64 00    LDA #$0064             ;\
$AA:C933 8D C6 09    STA $09C6  [$7E:09C6]  ;} Samus missiles = Samus max missiles = 100
$AA:C936 8D C8 09    STA $09C8  [$7E:09C8]  ;/
$AA:C939 A9 14 00    LDA #$0014             ;\
$AA:C93C 8D CA 09    STA $09CA  [$7E:09CA]  ;} Samus super missiles = Samus max super missiles = 20
$AA:C93F 8D CC 09    STA $09CC  [$7E:09CC]  ;/
$AA:C942 A9 14 00    LDA #$0014             ;\
$AA:C945 8D CE 09    STA $09CE  [$7E:09CE]  ;} Samus power bombs = Samus max power bombs = 20
$AA:C948 8D D0 09    STA $09D0  [$7E:09D0]  ;/
$AA:C94B A9 37 F3    LDA #$F337             ;\
$AA:C94E 8D A2 09    STA $09A2  [$7E:09A2]  ;} Equipped items = collected items = everything but screw attack + unused bitset 10h
$AA:C951 8D A4 09    STA $09A4  [$7E:09A4]  ;/
$AA:C954 A9 0F 10    LDA #$100F             ;\
$AA:C957 8D A6 09    STA $09A6  [$7E:09A6]  ;} Equipped beams = collected beams = everything
$AA:C95A 8D A8 09    STA $09A8  [$7E:09A8]  ;/

$AA:C95D 6B          RTL

$AA:C95E 60          RTS

; Initial values
;                        _________ Crateria
;                       |      ___ Norfair
;                       |     |
$AA:C95F             dw 00DB, 01A8 ; X position
$AA:C963             dw 00B3, 0090 ; Y position
$AA:C967             dw B879, C9CB ; Instruction list pointer
$AA:C96B             dw 2800, 2800 ; Properties. 2000h = process instructions, 800h = process whilst off-screen
$AA:C96F             dw 0012, 0012 ; X radius
$AA:C973             dw 0030, 0029 ; Y radius
}


;;; $C977: Enemy touch - enemy $EEFF/$EF3F/$EF7F/$EFBF (torizos) ;;;
{
$AA:C977 22 97 A4 A0 JSL $A0A497[$A0:A497]  ; Normal enemy touch AI - no death check
$AA:C97B 6B          RTL
}


;;; $C97C: Enemy shot - torizo - normal ;;;
{
$AA:C97C AD 9F 07    LDA $079F  [$7E:079F]  ;\
$AA:C97F F0 03       BEQ $03    [$C984]     ;} If [area index] != Crateria:
$AA:C981 4C 67 D6    JMP $D667  [$AA:D667]  ; Go to Golden Torizo shot reaction - normal

$AA:C984 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:C987 BD 9C 0F    LDA $0F9C,x[$7E:0F9C]  ;\
$AA:C98A 1F 08 78 7E ORA $7E7808,x[$7E:7808];} If [enemy flash timer] != 0 or [enemy animation lock flag] != 0: return
$AA:C98E D0 30       BNE $30    [$C9C0]     ;/
$AA:C990 22 A7 A6 A0 JSL $A0A6A7[$A0:A6A7]  ; Normal enemy shot AI - no death check, no enemy shot graphic
$AA:C994 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:C997 BD 8C 0F    LDA $0F8C,x[$7E:0F8C]  ;\
$AA:C99A D0 24       BNE $24    [$C9C0]     ;} If [enemy health] != 0: return
$AA:C99C A9 AB C6    LDA #$C6AB             ;\
$AA:C99F 9D B0 0F    STA $0FB0,x[$7E:0FB0]  ;} Enemy function = RTS
$AA:C9A2 A9 C8 B1    LDA #$B1C8             ;\
$AA:C9A5 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = $B1C8 (torizo death sequence)
$AA:C9A8 A9 01 00    LDA #$0001             ;\
$AA:C9AB 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:C9AE BD B6 0F    LDA $0FB6,x[$7E:0FB6]  ;\
$AA:C9B1 09 00 C0    ORA #$C000             ;} Mark torizo gut and face blown up
$AA:C9B4 9D B6 0F    STA $0FB6,x[$7E:0FB6]  ;/
$AA:C9B7 BD 86 0F    LDA $0F86,x[$7E:0F86]  ;\
$AA:C9BA 09 00 04    ORA #$0400             ;} Set enemy as intangible
$AA:C9BD 9D 86 0F    STA $0F86,x[$7E:0F86]  ;/

$AA:C9C0 6B          RTL
}


;;; $C9C1: RTL ;;;
{
$AA:C9C1 6B          RTL
}


;;; $C9C2: Enemy shot - torizo - stand up / sit down ;;;
{
$AA:C9C2 AD 9F 07    LDA $079F  [$7E:079F]  ;\
$AA:C9C5 F0 03       BEQ $03    [$C9CA]     ;} If [area index] != Crateria:
$AA:C9C7 4C 58 D6    JMP $D658  [$AA:D658]  ; Go to Golden Torizo shot reaction - stand up / sit down

$AA:C9CA 6B          RTL
}


;;; $C9CB..D368: Instruction lists and instructions ;;;
{
;;; $C9CB: Instruction list - Golden Torizo - initial ;;;
{
$AA:C9CB             dx 814B,0600,AFE200,6D00,  ; Transfer 600h bytes from $AF:E200 to VRAM $6D00
                        C3A0,                   ; Set stepped left with right foot state
                        C2C9,                   ; Set animation lock
                        B09C,D5C2,              ; Enemy function = $D5C2 (wake enemy if Samus is below and right of target position)
                        0001,AA30,
                        812F,                   ; Sleep
                        B09C,C6BF               ; Enemy function = $C6BF (simple movement)
$AA:C9E6             dx 0001,AA30,
                        CACE,C9E6,              ; Go to $C9E6 if not hit ground
                        C618,                   ; Queue torizo footsteps sound effect
                        0003,AA30,
                        C41E,0004,              ; Sitting down movement - index 4
                        0004,AA26,
                        C41E,0002,              ; Sitting down movement - index 2
                        0005,AA1C,
                        C41E,0000,              ; Sitting down movement - index 0
                        B09C,C6AB,              ; Enemy function = RTS
                        0030,AA12,
                        814B,0040,AAB279,7D80,  ; Transfer 40h bytes from $AA:B279       to VRAM $7D80
                        0020,AA12,                                            
                        814B,0040,AAB2B9,7D80,  ; Transfer 40h bytes from $AA:B279 + 40h to VRAM $7D80
                        0010,AA12,                                            
                        814B,0040,AAB2F9,7D80,  ; Transfer 40h bytes from $AA:B279 + 80h to VRAM $7D80
                        0008,AA12,                                            
                        814B,0040,AAB339,7D80,  ; Transfer 40h bytes from $AA:B279 + C0h to VRAM $7D80
                        0020,AA12,
                        8123,0002               ; Timer = 2
$AA:CA48             dx 0004,AA12,
                        814B,0040,AAB279,7D80,  ; Transfer 40h bytes from $AA:B279       to VRAM $7D80
                        0004,AA12,                                            
                        814B,0040,AAB2B9,7D80,  ; Transfer 40h bytes from $AA:B279 + 40h to VRAM $7D80
                        0004,AA12,                                            
                        814B,0040,AAB2F9,7D80,  ; Transfer 40h bytes from $AA:B279 + 80h to VRAM $7D80
                        0004,AA12,                                            
                        814B,0040,AAB339,7D80,  ; Transfer 40h bytes from $AA:B279 + C0h to VRAM $7D80
                        8110,CA48,              ; Decrement timer and go to $CA48 if non-zero
                        0020,AA12,
                        C3CC,0000,              ; Standing up movement - index 0
                        000C,AA1C,
                        C3CC,0002,              ; Standing up movement - index 2
                        0008,AA26,
                        C3CC,0004,              ; Standing up movement - index 4
                        0008,AA30,
                        C3CC,0006,              ; Standing up movement - index 6
                        0008,AA3A,
                        C3CC,0008,              ; Standing up movement - index 8
                        0008,AA4C,
                        C3CC,000A,              ; Standing up movement - index Ah
                        CADE,                   ; Load Golden Torizo palettes
                        8123,0010               ; Timer = 10h
$AA:CAB6             dx 0004,AA5E,
                        B271,                   ; Advance gradual colour change
                        8110,CAB6,              ; Decrement timer and go to $CAB6 if non-zero
                        C2C8,                   ; NOP
                        C2D1,                   ; Clear animation lock
                        CAE2,                   ; Start fight music and Golden Torizo belly palette FX
                        0010,AA5E,
                        80ED,D259               ; Go to $D259 (Golden Torizo - walking left - left leg moving)
}


;;; $CACE: Instruction - go to [[Y]] if not hit ground ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:CACE BD 7E 0F    LDA $0F7E,x[$7E:0F7E]  ;\
$AA:CAD1 C9 77 01    CMP #$0177             ;} If [enemy Y position] != 177h:
$AA:CAD4 F0 05       BEQ $05    [$CADB]     ;/
$AA:CAD6 B9 00 00    LDA $0000,y[$AA:C9EC]  ;\
$AA:CAD9 A8          TAY                    ;} Y = [[Y]]
$AA:CADA 6B          RTL                    ; Return

$AA:CADB C8          INY                    ;\
$AA:CADC C8          INY                    ;} Y += 2
$AA:CADD 6B          RTL
}


;;; $CADE: Instruction - load Golden Torizo palettes ;;;
{
$AA:CADE 20 98 C2    JSR $C298  [$AA:C298]  ; Load Golden Torizo palettes
$AA:CAE1 6B          RTL
}


;;; $CAE2: Instruction - start fight music and Golden Torizo belly palette FX ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:CAE2 A9 05 00    LDA #$0005             ;\
$AA:CAE5 22 C1 8F 80 JSL $808FC1[$80:8FC1]  ;} Queue song 0 music track
$AA:CAE9 A9 12 00    LDA #$0012             ;\
$AA:CAEC 9D 82 0F    STA $0F82,x[$7E:0F82]  ;} Enemy X radius = 12h
$AA:CAEF A9 30 00    LDA #$0030             ;\
$AA:CAF2 9D 84 0F    STA $0F84,x[$7E:0F84]  ;} Enemy Y radius = 30h
$AA:CAF5 5A          PHY                    ;\
$AA:CAF6 A0 5D F7    LDY #$F75D             ;|
$AA:CAF9 22 E9 C4 8D JSL $8DC4E9[$8D:C4E9]  ;} Spawn Golden Torizo belly palette FX
$AA:CAFD 7A          PLY                    ;/
$AA:CAFE 6B          RTL
}


;;; $CAFF: Instruction list - callable - Golden Torizo - spewing chozo orbs - facing left - right foot forward ;;;
{
$AA:CAFF             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        0006,A64E,
                        0003,A668,
                        0003,A682,
                        0003,A69C,
                        0003,A6B6,
                        0006,A6D0,
                        8123,0006   ; Timer = 6
$AA:CB1F             dx C610,       ; Queue shot torizo sound effect
                        D4F3,       ; Spawn Golden Torizo's chozo orbs
                        813A,0006,  ; Wait 6 frames
                        8110,CB1F,  ; Decrement timer and go to $CB1F if non-zero
                        0003,A6B6,
                        0003,A69C,
                        0003,A682,
                        0003,A668,
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C2F7        ; Return
}


;;; $CB41: Instruction list - callable - Golden Torizo - spewing chozo orbs - facing left - left foot forward ;;;
{
$AA:CB41             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        0006,A6EA,
                        0003,A704,
                        0003,A71E,
                        0003,A738,
                        0003,A752,
                        0006,A76C,
                        8123,0006   ; Timer = 6
$AA:CB61             dx C610,       ; Queue shot torizo sound effect
                        D4F3,       ; Spawn Golden Torizo's chozo orbs
                        813A,0006,  ; Wait 6 frames
                        8110,CB61,  ; Decrement timer and go to $CB61 if non-zero
                        0003,A752,
                        0003,A738,
                        0003,A71E,
                        0003,A704,
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C2F7        ; Return
}


;;; $CB83: Instruction list - callable - Golden Torizo - sonic booms - facing left - right foot forward ;;;
{
$AA:CB83             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        8123,0004   ; Timer = 4
$AA:CB8B             dx 0003,A64E,
                        0003,A786,
                        0003,A7A0,
                        0003,A7C2,
                        0003,A7E4,
                        0003,A806,
                        0001,A7E4,
                        0001,A7C2,
                        C5F2,0000,  ; Spawn Golden Torizo sonic boom with parameter 0
                        0001,A7A0,
                        0004,A786,
                        0003,A64E,
                        0003,A828,
                        0003,A84A,
                        0003,A86C,
                        0003,A88E,
                        0003,A8B0,
                        0001,A88E,
                        0001,A86C,
                        C5F2,0001,  ; Spawn Golden Torizo sonic boom with parameter 1
                        0001,A84A,
                        0004,A828,
                        8110,CB8B,  ; Decrement timer and go to $CB8B if non-zero
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C2F7        ; Return
}


;;; $CBED: Instruction list - callable - Golden Torizo - sonic booms - facing left - left foot forward ;;;
{
$AA:CBED             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        8123,0004   ; Timer = 4
$AA:CBF5             dx 0003,A6EA,
                        0003,A8D2,
                        0003,A8EC,
                        0003,A906,
                        0003,A920,
                        0003,A93A,
                        0001,A920,
                        0001,A906,
                        C5F2,0000,  ; Spawn Golden Torizo sonic boom with parameter 0
                        0001,A8EC,
                        0004,A8D2,
                        0003,A6EA,
                        0003,A954,
                        0003,A976,
                        0003,A998,
                        0003,A9BA,
                        0003,A9DC,
                        0001,A9BA,
                        0001,A998,
                        C5F2,0001,  ; Spawn Golden Torizo sonic boom with parameter 1
                        0001,A976,
                        0004,A954,
                        8110,CBF5,  ; Decrement timer and go to $CBF5 if non-zero
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C2F7        ; Return
}


;;; $CC57: Instruction list - callable - Golden Torizo - spewing chozo orbs - facing right - left foot forward ;;;
{
$AA:CC57             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        0006,ABEC,
                        0003,AC06,
                        0003,AC20,
                        0003,AC3A,
                        0003,AC54,
                        0006,AC6E,
                        8123,0006   ; Timer = 6
$AA:CC77             dx C610,       ; Queue shot torizo sound effect
                        D4F3,       ; Spawn Golden Torizo's chozo orbs
                        813A,0006,  ; Wait 6 frames
                        8110,CC77,  ; Decrement timer and go to $CC77 if non-zero
                        0003,AC54,
                        0003,AC3A,
                        0003,AC20,
                        0003,AC06,
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C2F7        ; Return
}


;;; $CC99: Instruction list - callable - Golden Torizo - spewing chozo orbs - facing right - right foot forward ;;;
{
$AA:CC99             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        0006,AC88,
                        0003,ACA2,
                        0003,ACBC,
                        0003,ACD6,
                        0003,ACF0,
                        0006,AD0A,
                        8123,0006   ; Timer = 6
$AA:CCB9             dx C610,       ; Queue shot torizo sound effect
                        D4F3,       ; Spawn Golden Torizo's chozo orbs
                        813A,0006,  ; Wait 6 frames
                        8110,CCB9,  ; Decrement timer and go to $CCB9 if non-zero
                        0003,ACF0,
                        0003,ACD6,
                        0003,ACBC,
                        0003,ACA2,
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C2F7        ; Return
}


;;; $CCDB: Instruction list - callable - Golden Torizo - sonic booms - facing right - left foot forward ;;;
{
$AA:CCDB             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        8123,0004   ; Timer = 4
$AA:CCE3             dx 0003,ABEC,
                        0003,AD24,
                        0003,AD3E,
                        0003,AD60,
                        0003,AD82,
                        0003,ADA4,
                        0001,AD82,
                        0001,AD60,
                        C5F2,0000,  ; Spawn Golden Torizo sonic boom with parameter 0
                        0001,AD3E,
                        0004,AD24,
                        0003,ABEC,
                        0003,ADC6,
                        0003,ADE8,
                        0003,AE0A,
                        0003,AE2C,
                        0003,AE4E,
                        0001,AE2C,
                        0001,AE0A,
                        C5F2,0001,  ; Spawn Golden Torizo sonic boom with parameter 1
                        0001,ADE8,
                        0004,ADC6,
                        8110,CCE3,  ; Decrement timer and go to $CCE3 if non-zero
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C2F7        ; Return
}


;;; $CD45: Instruction list - callable - Golden Torizo - sonic booms - facing right - right foot forward ;;;
{
$AA:CD45             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        8123,0004   ; Timer = 4
$AA:CD4D             dx 0003,AC88,
                        0003,AE70,
                        0003,AE8A,
                        0003,AEA4,
                        0003,AEBE,
                        0003,AED8,
                        0001,AEBE,
                        0001,AEA4,
                        C5F2,0000,  ; Spawn Golden Torizo sonic boom with parameter 0
                        0001,AE8A,
                        0004,AE70,
                        0003,AC88,
                        0003,AEF2,
                        0003,AF14,
                        0003,AF36,
                        0003,AF58,
                        0003,AF7A,
                        0001,AF58,
                        0001,AF36,
                        C5F2,0001,  ; Spawn Golden Torizo sonic boom with parameter 1
                        0001,AF14,
                        0004,AEF2,
                        8110,CD4D,  ; Decrement timer and go to $CD4D if non-zero
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C2F7        ; Return
}


;;; $CDAF: Instruction list - Golden Torizo - landed from backwards jump - facing left - left foot forward ;;;
{
$AA:CDAF             dx D526,CB41,CBED, ; Call $CB41 (spewing orbs) or $CBED (sonic booms) for Golden Torizo attack
                        80ED,D20D       ; Go to $D20D (walking left - right leg moving)
}


;;; $CDB9: Instruction list - Golden Torizo - landed from backwards jump - facing left - right foot forward ;;;
{
$AA:CDB9             dx D526,CAFF,CB83, ; Call $CAFF (spewing orbs) or $CB83 (sonic booms) for Golden Torizo attack
                        80ED,D259       ; Go to $D259 (walking left - left leg moving)
}


;;; $CDC3: Instruction list - Golden Torizo - landed from backwards jump - facing right - right foot forward ;;;
{
$AA:CDC3             dx D526,CC99,CD45, ; Call $CC99 (spewing orbs) or $CD45 (sonic booms) for Golden Torizo attack
                        80ED,D2C9       ; Go to $D2C9 (walking right - left leg moving)
}


;;; $CDCD: Instruction list - Golden Torizo - landed from backwards jump - facing right - left foot forward ;;;
{
$AA:CDCD             dx D526,CC57,CCDB, ; Call $CC57 (spewing orbs) or $CCDB (sonic booms) for Golden Torizo attack
                        80ED,D315       ; Go to $D315 (walking right - right leg moving)
}


;;; $CDD7: Instruction - clear torizo caught super missile flag ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:CDD7 BD B6 0F    LDA $0FB6,x
$AA:CDDA 29 FF EF    AND #$EFFF
$AA:CDDD 9D B6 0F    STA $0FB6,x
$AA:CDE0 6B          RTL
}


;;; $CDE1: Instruction list - caught super missile - facing left - left leg forward ;;;
{
$AA:CDE1             dx D39F,       ; Queue torizo sonic boom sound effect
                        B09C,D5DF,  ; Enemy function = $D5DF (simple movement)
                        0001,A6EA,
                        0001,A8D2,
                        0001,A8EC,
                        0001,A906,
                        0001,A920,
                        0001,A93A,
                        0001,A920,
                        0001,A906,
                        0001,A8EC,
                        0001,A8D2,
                        0002,A8D2,
                        0002,A8EC,
                        0002,A906,
                        0002,A920,
                        D3E0,       ; Spawn Golden Torizo super missile
                        0030,A93A,
                        0002,A920,
                        0002,A906,
                        0002,A8EC,
                        0002,A8D2,
                        0002,A6EA,
                        0010,A954,
                        CDD7,       ; Clear torizo caught super missile flag
                        80ED,D20D   ; Go to $D20D (Golden Torizo - walking left - right leg moving)
}


;;; $CE43: Instruction list - caught super missile - facing left - right leg forward ;;;
{
$AA:CE43             dx D39F,       ; Queue torizo sonic boom sound effect
                        B09C,D5DF,  ; Enemy function = $D5DF (simple movement)
                        0001,A64E,
                        0001,A786,
                        0001,A7A0,
                        0001,A7C2,
                        0001,A7E4,
                        0001,A806,
                        0001,A7E4,
                        0001,A7C2,
                        0001,A7A0,
                        0001,A786,
                        0002,A786,
                        0002,A7A0,
                        0002,A7C2,
                        0002,A7E4,
                        D3E0,       ; Spawn Golden Torizo super missile
                        0030,A806,
                        0002,A7E4,
                        0002,A7C2,
                        0002,A7A0,
                        0002,A786,
                        0002,A64E,
                        0010,A828,
                        CDD7,       ; Clear torizo caught super missile flag
                        80ED,D259   ; Go to $D259 (Golden Torizo - walking left - left leg moving)
}


;;; $CEA5: Instruction list - caught super missile - facing right - right leg forward ;;;
{
$AA:CEA5             dx D39F,       ; Queue torizo sonic boom sound effect
                        B09C,D5DF,  ; Enemy function = $D5DF (simple movement)
                        0001,AC88,
                        0001,AE70,
                        0001,AE8A,
                        0001,AEA4,
                        0001,AEBE,
                        0001,AED8,
                        0001,AEBE,
                        0001,AEA4,
                        0001,AE8A,
                        0002,AE8A,
                        0002,AEA4,
                        0002,AEBE,
                        D3E0,       ; Spawn Golden Torizo super missile
                        0030,AED8,
                        0002,AEBE,
                        0002,AEA4,
                        0002,AE8A,
                        0002,AE70,
                        0002,AC88,
                        0010,AEF2,
                        CDD7,       ; Clear torizo caught super missile flag
                        80ED,D2C9   ; Go to $D2C9 (Golden Torizo - walking right - left leg moving)
}


;;; $CEFF: Instruction list - caught super missile - facing right - left leg forward ;;;
{
$AA:CEFF             dx D39F,       ; Queue torizo sonic boom sound effect
                        B09C,D5DF,  ; Enemy function = $D5DF (simple movement)
                        0001,ABEC,
                        0001,AD24,
                        0001,AD3E,
                        0001,AD60,
                        0001,AD82,
                        0001,ADA4,
                        0001,AD82,
                        0001,AD60,
                        0001,AD3E,
                        0002,AD3E,
                        0002,AD60,
                        0002,AD82,
                        D3E0,       ; Spawn Golden Torizo super missile
                        0030,ADA4,
                        0002,AD82,
                        0002,AD60,
                        0002,AD3E,
                        0002,AD24,
                        0002,ABEC,
                        0010,ADC6,
                        CDD7,       ; Clear torizo caught super missile flag
                        80ED,D315   ; Go to $D315 (Golden Torizo - walking right - right leg moving)
}


;;; $CF59: Instruction list - sit down attack - facing left ;;;
{
$AA:CF59             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        0008,AA5E,
                        C41E,000A,  ; Sitting down movement - index Ah
                        0008,AA4C,
                        C41E,0008,  ; Sitting down movement - index 8
                        0006,AA3A,
                        C41E,0006,  ; Sitting down movement - index 6
                        0006,AA30,
                        C41E,0004,  ; Sitting down movement - index 4
                        0004,AA26,
                        C41E,0002,  ; Sitting down movement - index 2
                        0004,AA1C,
                        C41E,0000,  ; Sitting down movement - index 0
                        0008,AA12,
                        C3CC,0000,  ; Standing up movement - index 0
                        0008,AA1C,
                        C3CC,0002,  ; Standing up movement - index 2
                        0008,AA26,
                        C3CC,0004,  ; Standing up movement - index 4
                        0008,AA30,
                        C3CC,0006,  ; Standing up movement - index 6
                        000A,AA3A,
                        C3CC,0008,  ; Standing up movement - index 8
                        000A,AA4C,
                        C3CC,000A,  ; Standing up movement - index Ah
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        80ED,D259   ; Go to $D259 (Golden Torizo - walking left - left leg moving)
}


;;; $CFC5: Instruction list - sit down attack - facing right ;;;
{
$AA:CFC5             dx 806B,D5ED,  ; Enemy movement function = $D5ED (attacking)
                        0008,AFE8,
                        C41E,001A,  ; Sitting down movement - index 1Ah
                        0008,AFD6,
                        C41E,0018,  ; Sitting down movement - index 18h
                        0006,AFC4,
                        C41E,0016,  ; Sitting down movement - index 16h
                        0006,AFBA,
                        C41E,0014,  ; Sitting down movement - index 14h
                        0004,AFB0,
                        C41E,0012,  ; Sitting down movement - index 12h
                        0004,AFA6,
                        C41E,0010,  ; Sitting down movement - index 10h
                        0008,AF9C,
                        C3CC,0010,  ; Standing up movement - index 10h
                        0008,AFA6,
                        C3CC,0012,  ; Standing up movement - index 12h
                        0008,AFB0,
                        C3CC,0014,  ; Standing up movement - index 14h
                        0008,AFBA,
                        C3CC,0016,  ; Standing up movement - index 16h
                        000A,AFC4,
                        C3CC,0018,  ; Standing up movement - index 18h
                        000A,AFD6,
                        C3CC,001A,  ; Standing up movement - index 1Ah
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        80ED,D315   ; Go to $D315 (Golden Torizo - walking right - right leg moving)
}


;;; $D031: Instruction list - callable - release Golden Torizo eggs ;;;
{
$AA:D031             dx 806B,D5ED,              ; Enemy movement function = $D5ED (attacking)
                        814B,0040,AAB4F9,7300,  ; Transfer 40h bytes from $AA:B479 + 80h  to VRAM $7300
                        814B,0040,AAB6F9,7400,  ; Transfer 40h bytes from $AA:B479 + 280h to VRAM $7400
                        813A,0008,              ; Wait 8 frames
                        814B,0040,AAB539,7300,  ; Transfer 40h bytes from $AA:B479 + C0h  to VRAM $7300
                        814B,0040,AAB739,7400,  ; Transfer 40h bytes from $AA:B479 + 2C0h to VRAM $7400
                        813A,0008,              ; Wait 8 frames
                        814B,0040,AAB579,7300,  ; Transfer 40h bytes from $AA:B479 + 100h to VRAM $7300
                        814B,0040,AAB779,7400,  ; Transfer 40h bytes from $AA:B479 + 300h to VRAM $7400
                        813A,0010,              ; Wait 10h frames
                        8123,0006               ; Timer = 6
$AA:D07B             dx D38F,                   ; Queue Golden Torizo egg released sound effect
                        D0E9,                   ; Spawn Golden Torizo egg
                        813A,0008,              ; Wait 8 frames
                        8110,D07B               ; Decrement timer and go to $D07B if non-zero
$AA:D087             dx 813A,0001,              ; Wait 1 frame
                        D0F3,D087,              ; Go to $D087 if Golden Torizo egg is active
                        814B,0040,AAB579,7300,  ; Transfer 40h bytes from $AA:B479 + 100h to VRAM $7300
                        814B,0040,AAB779,7400,  ; Transfer 40h bytes from $AA:B479 + 300h to VRAM $7400
                        813A,0008,              ; Wait 8 frames
                        814B,0040,AAB539,7300,  ; Transfer 40h bytes from $AA:B479 + C0h  to VRAM $7300
                        814B,0040,AAB739,7400,  ; Transfer 40h bytes from $AA:B479 + 2C0h to VRAM $7400
                        813A,0008,              ; Wait 8 frames
                        814B,0040,AAB4F9,7300,  ; Transfer 40h bytes from $AA:B479 + 80h  to VRAM $7300
                        814B,0040,AAB6F9,7400,  ; Transfer 40h bytes from $AA:B479 + 280h to VRAM $7400
                        813A,0008,              ; Wait 8 frames
                        814B,0040,AFC800,7300,  ; Transfer 40h bytes from $AF:C800 to VRAM $7300
                        814B,0040,AFCA00,7400,  ; Transfer 40h bytes from $AF:CA00 to VRAM $7400
                        806B,D5F1,              ; Enemy movement function = $D5F1 (walking)
                        C2F7                    ; Return
}


;;; $D0E9: Instruction - spawn Golden Torizo egg ;;;
{
$AA:D0E9 5A          PHY                    ;\
$AA:D0EA A0 C0 B1    LDY #$B1C0             ;|
$AA:D0ED 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Golden Torizo egg enemy projectile
$AA:D0F1 7A          PLY                    ;/
$AA:D0F2 6B          RTL
}


;;; $D0F3: Instruction - go to [[Y]] if Golden Torizo egg is active ;;;
{
;; Parameters:
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:D0F3 DA          PHX
$AA:D0F4 A2 22 00    LDX #$0022             ; X = 22h

; LOOP
$AA:D0F7 BD 97 19    LDA $1997,x            ;\
$AA:D0FA C9 C0 B1    CMP #$B1C0             ;} If [enemy projectile ID] != $B1C0 (Golden Torizo egg):
$AA:D0FD F0 08       BEQ $08    [$D107]     ;/
$AA:D0FF CA          DEX                    ;\
$AA:D100 CA          DEX                    ;} X -= 2
$AA:D101 10 F4       BPL $F4    [$D0F7]     ; If [X] >= 0: go to LOOP
$AA:D103 FA          PLX
$AA:D104 C8          INY                    ;\
$AA:D105 C8          INY                    ;} Y += 2
$AA:D106 6B          RTL                    ; Return

$AA:D107 FA          PLX
$AA:D108 B9 00 00    LDA $0000,y            ;\
$AA:D10B A8          TAY                    ;} Y = [[Y]]
$AA:D10C 6B          RTL
}


;;; $D10D: Instruction list - callable - Golden Torizo eye beam attack ;;;
{
$AA:D10D             dw B09C,D5DF,              ; Enemy function = $D5DF (simple movement)
                        D17B,                   ; Disable eye beam explosions
                        C2C9,                   ; Set animation lock
                        813A,0008,              ; Wait 8 frames
                        8123,0004,              ; Timer = 4
                        D397                    ; Play laser sound effect
$AA:D11F             dw D436,0000,              ; Spawn Golden Torizo eye beam
                        813A,0004,              ; Wait 4 frames
                        8110,D11F,              ; Decrement timer and go to $D11F if non-zero
                        813A,0008,              ; Wait 8 frames
                        8123,0002               ; Timer = 2
$AA:D133             dx 813A,0003,              ; Wait 3 frames
                        814B,0040,AAB279,7D80,  ; Transfer 40h bytes from $AA:B279 to VRAM $7D80
                        813A,0003,              ; Wait 3 frames
                        814B,0040,AAB2B9,7D80,  ; Transfer 40h bytes from $AA:B2B9 to VRAM $7D80
                        813A,0003,              ; Wait 3 frames
                        814B,0040,AAB2F9,7D80,  ; Transfer 40h bytes from $AA:B2F9 to VRAM $7D80
                        813A,0003,              ; Wait 3 frames
                        814B,0040,AAB339,7D80,  ; Transfer 40h bytes from $AA:B339 to VRAM $7D80
                        8110,D133,              ; Decrement timer and go to $D133 if non-zero
                        D187,                   ; Enable eye beam explosions
                        813A,0008,              ; Wait 8 frames
                        D17B,                   ; Disable eye beam explosions
                        C2D1,                   ; Clear animation lock
                        B09C,D5E6,              ; Enemy function = $D5E6 (normal movement)
                        C2F7                    ; Return
}


;;; $D17B: Instruction - disable eye beam explosions ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D17B BF 0C 78 7E LDA $7E780C,x[$7E:780C]
$AA:D17F 29 FF 7F    AND #$7FFF
$AA:D182 9F 0C 78 7E STA $7E780C,x[$7E:780C]
$AA:D186 6B          RTL
}


;;; $D187: Instruction - enable eye beam explosions ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D187 BF 0C 78 7E LDA $7E780C,x[$7E:780C]
$AA:D18B 09 00 80    ORA #$8000
$AA:D18E 9F 0C 78 7E STA $7E780C,x[$7E:780C]
$AA:D192 6B          RTL
}


;;; $D193: Instruction list - callable - stunned ;;;
{
$AA:D193             dx 806B,D5ED,              ; Enemy movement function = $D5ED (attacking)
                        C2C9,                   ; Set animation lock
                        813A,0018,              ; Wait 18h frames
                        8123,0002               ; Timer = 2
$AA:D1A1             dx 813A,0003,              ; Wait 3 frames
                        814B,0040,AAB279,7D80,  ; Transfer 40h bytes from $AA:B279 to VRAM $7D80
                        813A,0003,              ; Wait 3 frames
                        814B,0040,AAB2B9,7D80,  ; Transfer 40h bytes from $AA:B2B9 to VRAM $7D80
                        813A,0003,              ; Wait 3 frames
                        814B,0040,AAB2F9,7D80,  ; Transfer 40h bytes from $AA:B2F9 to VRAM $7D80
                        813A,0003,              ; Wait 3 frames
                        814B,0040,AAB339,7D80,  ; Transfer 40h bytes from $AA:B339 to VRAM $7D80
                        8110,D1A1,              ; Decrement timer and go to $D1A1 if non-zero
                        813A,0010,              ; Wait 10h frames
                        C2D1,                   ; Clear animation lock
                        D1E7,                   ; Unmark Golden Torizo stunned
                        806B,D5F1,              ; Enemy movement function = $D5F1 (walking)
                        C2F7                    ; Return
}


;;; $D1E7: Instruction - unmark Golden Torizo stunned ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D1E7 BD B6 0F    LDA $0FB6,x[$7E:0FB6]
$AA:D1EA 29 FF DF    AND #$DFFF
$AA:D1ED 9D B6 0F    STA $0FB6,x[$7E:0FB6]
$AA:D1F0 6B          RTL
}


;;; $D1F1: Instruction list - Golden Torizo - dodge - turning left ;;;
{
$AA:D1F1             dx B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        C2C9,       ; Set animation lock
                        C36D,       ; Set torizo turning around flag
                        0018,A4F0,
                        C2D1,       ; Clear animation lock
                        80ED,D20D   ; Go to $D20D (Golden Torizo - walking left - right leg moving)
}


;;; $D203: Instruction list - Golden Torizo - turning left ;;;
{
$AA:D203             dx B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        C36D,       ; Set torizo turning around flag
                        0008,A4F0
}


;;; $D20D: Instruction list - Golden Torizo - walking left - right leg moving ;;;
{
$AA:D20D             dx C377,       ; Set stepped left with left foot state
                        B09C,D5E6,  ; Enemy function = $D5E6 (normal movement)
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C618,       ; Queue torizo footsteps sound effect
                        0008,A4FA,
                        D4BA,BC60,  ; Go to $BC60 (jumping forwards) and jump forwards if Samus is at least 70h pixels in front of Golden Torizo
                        D4FD,BC96,  ; Go to $BC96 (jumping backwards) and jump backwards if Samus is less than 20h pixels in front of Golden Torizo
                        D49B,D193,  ; Call $D193 (stunned) if health >= 10800 and stunned
                        D445,D10D,  ; Call $D10D (eye beam attack) with 25% chance if Samus is a medium distance in front of torizo
                        D54D,0002,  ; Golden Torizo walking movement - index 2
                        0004,A51C,
                        D54D,0004,  ; Golden Torizo walking movement - index 4
                        0004,A53E,
                        D474,D031,  ; Call $D031 (release Golden Torizo eggs) with 25% chance if health <= 1928
                        D4FD,BC96,  ; Go to $BC96 (jumping backwards) and jump backwards if Samus is less than 20h pixels in front of Golden Torizo
                        D54D,0006,  ; Golden Torizo walking movement - index 6
                        0004,A560,
                        D54D,0008,  ; Golden Torizo walking movement - index 8
                        0004,A582,
                        D54D,000A   ; Golden Torizo walking movement - index Ah
}


;;; $D259: Instruction list - Golden Torizo - walking left - left leg moving ;;;
{
$AA:D259             dx C3A0,       ; Set stepped left with right foot state
                        B09C,D5E6,  ; Enemy function = $D5E6 (normal movement)
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C618,       ; Queue torizo footsteps sound effect
                        0008,A5A4,
                        D3EA,CF59,  ; Go to $CF59 (sit down attack) if Samus is a medium distance behind torizo and morphed
                        D4BA,BC60,  ; Go to $BC60 (jumping forwards) and jump forwards if Samus is at least 70h pixels in front of Golden Torizo
                        D4FD,BCD2,  ; Go to $BCD2 (jumping backwards) and jump backwards if Samus is less than 20h pixels in front of Golden Torizo
                        D49B,D193,  ; Call $D193 (stunned) if health >= 10800 and stunned
                        D445,D10D,  ; Call $D10D (eye beam attack) with 25% chance if Samus is a medium distance in front of torizo
                        D54D,000C,  ; Golden Torizo walking movement - index Ch
                        0004,A5C6,
                        D54D,000E,  ; Golden Torizo walking movement - index Eh
                        0004,A5E8,
                        D474,D031,  ; Call $D031 (release Golden Torizo eggs) with 25% chance if health <= 1928
                        D4FD,BCD2,  ; Go to $BCD2 (jumping backwards) and jump backwards if Samus is less than 20h pixels in front of Golden Torizo
                        D54D,0010,  ; Golden Torizo walking movement - index 10h
                        0004,A60A,
                        D54D,0012,  ; Golden Torizo walking movement - index 12h
                        0004,A62C,
                        D54D,0000,  ; Golden Torizo walking movement - index 0
                        80ED,D20D   ; Go to $D20D (Golden Torizo - walking left - right leg moving)
}


;;; $D2AD: Instruction list - Golden Torizo - dodge - turning right ;;;
{
$AA:D2AD             dx B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        C2C9,       ; Set animation lock
                        C36D,       ; Set torizo turning around flag
                        0018,A4F0,
                        C2D1,       ; Clear animation lock
                        80ED,D2C9   ; Go to $D2C9 (Golden Torizo - walking right - left leg moving)
}


;;; $D2BF: Instruction list - Golden Torizo - turning right ;;;
{
$AA:D2BF             dx B09C,C6BF,  ; Enemy function = $C6BF (simple movement)
                        C36D,       ; Set torizo turning around flag
                        0008,A4F0
}


;;; $D2C9: Instruction list - Golden Torizo - walking right - left leg moving ;;;
{
$AA:D2C9             dx C38A,       ; Set stepped right with right foot state
                        B09C,D5E6,  ; Enemy function = $D5E6 (normal movement)
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C618,       ; Queue torizo footsteps sound effect
                        0008,AA98,
                        D4BA,C0DA,  ; Go to $C0DA (jumping forwards) and jump forwards if Samus is at least 70h pixels in front of Golden Torizo
                        D4FD,C110,  ; Go to $C110 (jumping backwards) and jump backwards if Samus is less than 20h pixels in front of Golden Torizo
                        D49B,D193,  ; Call $D193 (stunned) if health >= 10800 and stunned
                        D445,D10D,  ; Call $D10D (eye beam attack) with 25% chance if Samus is a medium distance in front of torizo
                        D54D,0016,  ; Golden Torizo walking movement - index 16h
                        0004,AABA,
                        D54D,0018,  ; Golden Torizo walking movement - index 18h
                        0004,AADC,
                        D474,D031,  ; Call $D031 (release Golden Torizo eggs) with 25% chance if health <= 1928
                        D54D,001A,  ; Golden Torizo walking movement - index 1Ah
                        0004,AAFE,
                        D4FD,C110,  ; Go to $C110 (jumping backwards) and jump backwards if Samus is less than 20h pixels in front of Golden Torizo
                        D54D,001C,  ; Golden Torizo walking movement - index 1Ch
                        0004,AB20,
                        D54D,001E   ; Golden Torizo walking movement - index 1Eh
}


;;; $D315: Instruction list - Golden Torizo - walking right - right leg moving ;;;
{
$AA:D315             dx C3B6,       ; Set stepped right with left foot state
                        B09C,D5E6,  ; Enemy function = $D5E6 (normal movement)
                        806B,D5F1,  ; Enemy movement function = $D5F1 (walking)
                        C618,       ; Queue torizo footsteps sound effect
                        0008,AB42,
                        D3EA,CFC5,  ; Go to $CFC5 (sit down attack) if Samus is a medium distance behind torizo and morphed
                        D4BA,C0DA,  ; Go to $C0DA (jumping forwards) and jump forwards if Samus is at least 70h pixels in front of Golden Torizo
                        D4FD,C14C,  ; Go to $C14C (jumping backwards) and jump backwards if Samus is less than 20h pixels in front of Golden Torizo
                        D49B,D193,  ; Call $D193 (stunned) if health >= 10800 and stunned
                        D445,D10D,  ; Call $D10D (eye beam attack) with 25% chance if Samus is a medium distance in front of torizo
                        D54D,0020,  ; Golden Torizo walking movement - index 20h
                        0004,AB64,
                        D54D,0022,  ; Golden Torizo walking movement - index 22h
                        0004,AB86,
                        D474,D031,  ; Call $D031 (release Golden Torizo eggs) with 25% chance if health <= 1928
                        D4FD,C14C,  ; Go to $C14C (jumping backwards) and jump backwards if Samus is less than 20h pixels in front of Golden Torizo
                        D54D,0024,  ; Golden Torizo walking movement - index 24h
                        0004,ABA8,
                        D54D,0026,  ; Golden Torizo walking movement - index 26h
                        0004,ABCA,
                        D54D,0014,  ; Golden Torizo walking movement - index 14h
                        80ED,D2C9   ; Go to $D2C9 (Golden Torizo - walking right - left leg moving)
}
}


;;; $D369: Main AI - enemy $EF7F/$EFBF (Gold Torizo) ;;;
{
$AA:D369 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:D36C AD 1C 0A    LDA $0A1C  [$7E:0A1C]  ;\
$AA:D36F C9 1B 00    CMP #$001B             ;|
$AA:D372 F0 0E       BEQ $0E    [$D382]     ;} If [Samus pose] != space jump:
$AA:D374 C9 1C 00    CMP #$001C             ;|
$AA:D377 F0 09       BEQ $09    [$D382]     ;/
$AA:D379 A9 00 00    LDA #$0000             ;\
$AA:D37C 9F 0E 78 7E STA $7E780E,x[$7E:780E];} Enemy space jump counter = 0
$AA:D380 80 09       BRA $09    [$D38B]

$AA:D382 BF 0E 78 7E LDA $7E780E,x[$7E:780E];\ Else ([Samus pose] = space jump):
$AA:D386 1A          INC A                  ;} Increment enemy space jump counter
$AA:D387 9F 0E 78 7E STA $7E780E,x[$7E:780E];/

$AA:D38B FC B0 0F    JSR ($0FB0,x)[$AA:C6BF]; Execute [enemy function]
$AA:D38E 6B          RTL
}


;;; $D38F..A6: Instructions ;;;
{
;;; $D38F: Instruction - queue Golden Torizo egg released sound effect ;;;
{
$AA:D38F A9 34 00    LDA #$0034             ;\
$AA:D392 22 CB 90 80 JSL $8090CB[$80:90CB]  ;} Queue sound 34h, sound library 2, max queued sounds allowed = 6 (Golden Torizo egg released)
$AA:D396 6B          RTL
}


;;; $D397: Instruction - queue laser sound effect ;;;
{
$AA:D397 A9 67 00    LDA #$0067             ;\
$AA:D39A 22 CB 90 80 JSL $8090CB[$80:90CB]  ;} Queue sound 67h, sound library 2, max queued sounds allowed = 6 (pirate laser)
$AA:D39E 6B          RTL
}


;;; $D39F: Instruction - queue torizo sonic boom sound effect ;;;
{
$AA:D39F A9 48 00    LDA #$0048             ;\
$AA:D3A2 22 CB 90 80 JSL $8090CB[$80:90CB]  ;} Queue sound 48h, sound library 2, max queued sounds allowed = 6 (torizo sonic boom)
$AA:D3A6 6B          RTL
}
}


;;; $D3A7: Check if torizo is facing Samus ;;;
{
;; Parameters:
;;     X: Enemy index
;; Returns:
;;     Negative: Set if torizo is facing away from Samus, clear otherwise

; Facing right: [enemy $0FB4] & 8000h != 0
$AA:D3A7 BD 7A 0F    LDA $0F7A,x[$7E:0F7A]
$AA:D3AA 38          SEC
$AA:D3AB ED F6 0A    SBC $0AF6  [$7E:0AF6]
$AA:D3AE 5D B4 0F    EOR $0FB4,x[$7E:0FB4]
$AA:D3B1 60          RTS
}


;;; $D3B2: Golden Torizo health-based palette handling ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D3B2 BD 8C 0F    LDA $0F8C,x[$7E:0F8C]  ; A = [enemy health]
$AA:D3B5 22 00 80 84 JSL $848000[$84:8000]  ; Golden Torizo health-based palette handling
$AA:D3B9 60          RTS
}


;;; $D3BA: Hurt AI - enemy $EF7F/$EFBF (Golden Torizo) ;;;
{
$AA:D3BA AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:D3BD 20 20 C6    JSR $C620  [$AA:C620]  ; Handle low-health initial drool
$AA:D3C0 BD 9C 0F    LDA $0F9C,x[$7E:0F9C]  ;\
$AA:D3C3 4A          LSR A                  ;} If [enemy flash counter] % 2 = 0:
$AA:D3C4 B0 05       BCS $05    [$D3CB]     ;/
$AA:D3C6 20 B2 D3    JSR $D3B2  [$AA:D3B2]  ; Golden Torizo health-based palette handling
$AA:D3C9 80 14       BRA $14    [$D3DF]     ; Return

$AA:D3CB DA          PHX                    ;\
$AA:D3CC A2 1E 00    LDX #$001E             ;|
                                            ;|
$AA:D3CF A9 FF 7F    LDA #$7FFF             ;|
$AA:D3D2 9F 40 C1 7E STA $7EC140,x[$7E:C15E];|
$AA:D3D6 9F 20 C1 7E STA $7EC120,x[$7E:C13E];} Sprite palette 1/2 = 7FFFh (white)
$AA:D3DA CA          DEX                    ;|
$AA:D3DB CA          DEX                    ;|
$AA:D3DC 10 F1       BPL $F1    [$D3CF]     ;|
$AA:D3DE FA          PLX                    ;/

$AA:D3DF 6B          RTL
}


;;; $D3E0..D5C1: Instructions - Golden Torizo ;;;
{
;;; $D3E0: Instruction - spawn Golden Torizo super missile ;;;
{
$AA:D3E0 5A          PHY                    ;\
$AA:D3E1 A0 1A B3    LDY #$B31A             ;|
$AA:D3E4 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Golden Torizo super missile enemy projectile
$AA:D3E8 7A          PLY                    ;/
$AA:D3E9 6B          RTL
}


;;; $D3EA: Instruction - go to [[Y]] if Samus is a medium distance behind torizo and morphed ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction

; Pose checklist is missing 41h (facing left - morph ball - no springball - on ground) >_<;
$AA:D3EA 20 A7 D3    JSR $D3A7  [$AA:D3A7]  ;\
$AA:D3ED 10 44       BPL $44    [$D433]     ;} If torizo is facing Samus: go to BRANCH_NO_GO_TO
$AA:D3EF A9 04 00    LDA #$0004             ;\
$AA:D3F2 22 9B BB A0 JSL $A0BB9B[$A0:BB9B]  ;} If X distance between enemy and Samus is less than 4: go to BRANCH_NO_GO_TO
$AA:D3F6 90 3B       BCC $3B    [$D433]     ;/
$AA:D3F8 A9 28 00    LDA #$0028             ;\
$AA:D3FB 22 9B BB A0 JSL $A0BB9B[$A0:BB9B]  ;} If X distance between enemy and Samus is at least 28h: go to BRANCH_NO_GO_TO
$AA:D3FF B0 32       BCS $32    [$D433]     ;/
$AA:D401 AD 1C 0A    LDA $0A1C  [$7E:0A1C]  ;\
$AA:D404 C9 1D 00    CMP #$001D             ;} If [Samus pose] != facing right - morph ball - no springball - on ground:
$AA:D407 F0 1E       BEQ $1E    [$D427]     ;/
$AA:D409 C9 1E 00    CMP #$001E             ;\
$AA:D40C F0 19       BEQ $19    [$D427]     ;|
$AA:D40E C9 1F 00    CMP #$001F             ;} If [Samus pose] != moving - morph ball - no springball - on ground:
$AA:D411 F0 14       BEQ $14    [$D427]     ;/
$AA:D413 C9 79 00    CMP #$0079             ;\
$AA:D416 F0 0F       BEQ $0F    [$D427]     ;|
$AA:D418 C9 7A 00    CMP #$007A             ;|
$AA:D41B F0 0A       BEQ $0A    [$D427]     ;|
$AA:D41D C9 7B 00    CMP #$007B             ;} If [Samus pose] != morph ball - spring ball - on ground: go to BRANCH_NO_GO_TO
$AA:D420 F0 05       BEQ $05    [$D427]     ;|
$AA:D422 C9 7C 00    CMP #$007C             ;|
$AA:D425 D0 0C       BNE $0C    [$D433]     ;/

$AA:D427 A9 00 00    LDA #$0000             ;\
$AA:D42A 9F 12 78 7E STA $7E7812,x          ;} Enemy step counter = 0
$AA:D42E B9 00 00    LDA $0000,y            ;\
$AA:D431 A8          TAY                    ;} Y = [[Y]]
$AA:D432 6B          RTL                    ; Return

; BRANCH_NO_GO_TO
$AA:D433 C8          INY                    ;\
$AA:D434 C8          INY                    ;} Y += 2
$AA:D435 6B          RTL
}


;;; $D436: Instruction - spawn Golden Torizo eye beam ;;;
{
;; Parameters:
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:D436 5A          PHY
$AA:D437 B9 00 00    LDA $0000,y[$AA:D121]  ; A = [[Y]] (ignored by enemy projectile)
$AA:D43A A0 28 B4    LDY #$B428             ;\
$AA:D43D 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Golden Torizo eye beam enemy projectile
$AA:D441 7A          PLY
$AA:D442 C8          INY
$AA:D443 C8          INY
$AA:D444 6B          RTL
}


;;; $D445: Instruction - call [[Y]] with 25% chance if Samus is a medium distance in front of torizo ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:D445 20 A7 D3    JSR $D3A7  [$AA:D3A7]  ;\
$AA:D448 30 27       BMI $27    [$D471]     ;} If torizo is facing Samus:
$AA:D44A A9 20 00    LDA #$0020             ;\
$AA:D44D 22 9B BB A0 JSL $A0BB9B[$A0:BB9B]  ;} If X distance between enemy and Samus is at least 20h:
$AA:D451 90 1E       BCC $1E    [$D471]     ;/
$AA:D453 A9 60 00    LDA #$0060             ;\
$AA:D456 22 9B BB A0 JSL $A0BB9B[$A0:BB9B]  ;} If X distance between enemy and Samus is less than 60h:
$AA:D45A B0 15       BCS $15    [$D471]     ;/
$AA:D45C 22 11 81 80 JSL $808111[$80:8111]  ; Generate random number
$AA:D460 29 10 01    AND #$0110             ;\
$AA:D463 D0 0C       BNE $0C    [$D471]     ;} If [random number] & 110h = 0 (25% chance):
$AA:D465 98          TYA                    ;\
$AA:D466 1A          INC A                  ;|
$AA:D467 1A          INC A                  ;} Enemy link instruction = [Y] + 2
$AA:D468 9F 00 78 7E STA $7E7800,x[$7E:7800];/
$AA:D46C B9 00 00    LDA $0000,y[$AA:D27B]  ;\
$AA:D46F A8          TAY                    ;} Y = [[Y]]
$AA:D470 6B          RTL                    ; Return

$AA:D471 C8          INY                    ;\
$AA:D472 C8          INY                    ;} Y += 2
$AA:D473 6B          RTL
}


;;; $D474: Instruction - call [[Y]] with 25% chance if health <= 1928 ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:D474 A9 88 07    LDA #$0788             ;\
$AA:D477 DD 8C 0F    CMP $0F8C,x[$7E:0F8C]  ;} If [enemy health] <= 13500 / 7:
$AA:D47A 90 1C       BCC $1C    [$D498]     ;/
$AA:D47C 22 11 81 80 JSL $808111[$80:8111]  ; Generate random number
$AA:D480 29 02 01    AND #$0102             ;\
$AA:D483 D0 13       BNE $13    [$D498]     ;} If [random number] & 102h = 0 (25%):
$AA:D485 A9 00 00    LDA #$0000             ;\
$AA:D488 9F 12 78 7E STA $7E7812,x          ;} Enemy step counter = 0
$AA:D48C 98          TYA                    ;\
$AA:D48D 1A          INC A                  ;|
$AA:D48E 1A          INC A                  ;} Enemy link instruction = [Y] + 2
$AA:D48F 9F 00 78 7E STA $7E7800,x          ;/
$AA:D493 B9 00 00    LDA $0000,y            ;\
$AA:D496 A8          TAY                    ;} Y = [[Y]]
$AA:D497 6B          RTL                    ; Return

$AA:D498 C8          INY                    ;\
$AA:D499 C8          INY                    ;} Y += 2
$AA:D49A 6B          RTL
}


;;; $D49B: Instruction - call [[Y]] if health >= 10800 and stunned ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:D49B A9 30 2A    LDA #$2A30             ;\
$AA:D49E DD 8C 0F    CMP $0F8C,x[$7E:0F8C]  ;} If [enemy health] > 13500 * 4/5:
$AA:D4A1 B0 14       BCS $14    [$D4B7]     ;/
$AA:D4A3 BD B6 0F    LDA $0FB6,x[$7E:0FB6]  ;\
$AA:D4A6 89 00 20    BIT #$2000             ;} If torizo is stunned:
$AA:D4A9 F0 0C       BEQ $0C    [$D4B7]     ;/
$AA:D4AB 98          TYA                    ;\
$AA:D4AC 1A          INC A                  ;|
$AA:D4AD 1A          INC A                  ;} Enemy link instruction = [Y] + 2
$AA:D4AE 9F 00 78 7E STA $7E7800,x[$7E:7800];/
$AA:D4B2 B9 00 00    LDA $0000,y[$AA:D333]  ;\
$AA:D4B5 A8          TAY                    ;} Y = [[Y]]
$AA:D4B6 6B          RTL                    ; Return

$AA:D4B7 C8          INY                    ;\
$AA:D4B8 C8          INY                    ;} Y += 2
$AA:D4B9 6B          RTL
}


;;; $D4BA: Instruction - go to [[Y]] and jump forwards if Samus is at least 70h pixels in front of Golden Torizo ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction

; Jump at Samus if at least 7 blocks away and:
;     She's been space jumping for over 6 seconds
;     Or the player is pressing left or right with a 75% chance
$AA:D4BA A9 70 00    LDA #$0070             ;\
$AA:D4BD 22 9B BB A0 JSL $A0BB9B[$A0:BB9B]  ;} If X distance between enemy and Samus is less than 70h: go to BRANCH_NO_GO_TO
$AA:D4C1 90 2D       BCC $2D    [$D4F0]     ;/
$AA:D4C3 20 A7 D3    JSR $D3A7  [$AA:D3A7]  ;\
$AA:D4C6 30 28       BMI $28    [$D4F0]     ;} If torizo is facing away from Samus: go to BRANCH_NO_GO_TO
$AA:D4C8 A9 68 01    LDA #$0168             ;\
$AA:D4CB DF 0E 78 7E CMP $7E780E,x[$7E:780E];} If [enemy space jump counter] <= 360:
$AA:D4CF 90 10       BCC $10    [$D4E1]     ;/
$AA:D4D1 A5 8B       LDA $8B    [$7E:008B]  ;\
$AA:D4D3 29 00 03    AND #$0300             ;} If not pressing left or right: go to BRANCH_NO_GO_TO
$AA:D4D6 F0 18       BEQ $18    [$D4F0]     ;/
$AA:D4D8 22 11 81 80 JSL $808111[$80:8111]  ; Generate random number
$AA:D4DC 29 01 01    AND #$0101             ;\
$AA:D4DF F0 0F       BEQ $0F    [$D4F0]     ;} If [random number] & 101h = 0 (25% chance): go to BRANCH_NO_GO_TO

$AA:D4E1 A9 00 00    LDA #$0000             ;\
$AA:D4E4 9F 12 78 7E STA $7E7812,x[$7E:7812];} Enemy step counter = 0
$AA:D4E8 20 0A C2    JSR $C20A  [$AA:C20A]  ; Make torizo jump forwards
$AA:D4EB B9 00 00    LDA $0000,y[$AA:D2DB]  ;\
$AA:D4EE A8          TAY                    ;} Y = [[Y]]
$AA:D4EF 6B          RTL                    ; Return

; BRANCH_NO_GO_TO
$AA:D4F0 C8          INY                    ;\
$AA:D4F1 C8          INY                    ;} Y += 2
$AA:D4F2 6B          RTL
}


;;; $D4F3: Instruction - spawn Golden Torizo's chozo orbs ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D4F3 5A          PHY                    ;\
$AA:D4F4 A0 7A AD    LDY #$AD7A             ;|
$AA:D4F7 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Golden Torizo's chozo orbs enemy projectile
$AA:D4FB 7A          PLY                    ;/
$AA:D4FC 6B          RTL
}


;;; $D4FD: Instruction - go to [[Y]] and jump backwards if Samus is less than 20h pixels in front of Golden Torizo ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:D4FD BF 12 78 7E LDA $7E7812,x[$7E:7812];\
$AA:D501 C9 08 00    CMP #$0008             ;} If [enemy step counter] < 8:
$AA:D504 B0 0E       BCS $0E    [$D514]     ;/
$AA:D506 A9 20 00    LDA #$0020             ;\
$AA:D509 22 9B BB A0 JSL $A0BB9B[$A0:BB9B]  ;} If X distance between enemy and Samus is at least 20h: go to BRANCH_NO_GO_TO
$AA:D50D B0 14       BCS $14    [$D523]     ;/
$AA:D50F 20 A7 D3    JSR $D3A7  [$AA:D3A7]  ;\
$AA:D512 30 0F       BMI $0F    [$D523]     ;} If torizo is facing away from Samus: go to BRANCH_NO_GO_TO

$AA:D514 A9 00 00    LDA #$0000             ;\
$AA:D517 9F 12 78 7E STA $7E7812,x[$7E:7812];} Enemy step counter = 0
$AA:D51B 20 2D C2    JSR $C22D  [$AA:C22D]  ; Make torizo jump backwards
$AA:D51E B9 00 00    LDA $0000,y[$AA:D32F]  ;\
$AA:D521 A8          TAY                    ;} Y = [[Y]]
$AA:D522 6B          RTL

; BRANCH_NO_GO_TO
$AA:D523 C8          INY                    ;\
$AA:D524 C8          INY                    ;} Y += 2
$AA:D525 6B          RTL
}


;;; $D526: Instruction - call [[Y]] or [[Y] + 2] for Golden Torizo attack ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:D526 98          TYA                    ;\
$AA:D527 1A          INC A                  ;|
$AA:D528 1A          INC A                  ;|
$AA:D529 1A          INC A                  ;} Enemy link instruction = [Y] + 4
$AA:D52A 1A          INC A                  ;|
$AA:D52B 9F 00 78 7E STA $7E7800,x[$7E:7800];/
$AA:D52F AD C6 09    LDA $09C6  [$7E:09C6]  ;\
$AA:D532 C9 20 00    CMP #$0020             ;} If [Samus missiles] < 20h: go to BRANCH_SPEW_ORBS
$AA:D535 90 0C       BCC $0C    [$D543]     ;/
$AA:D537 AD F6 0A    LDA $0AF6  [$7E:0AF6]  ;\
$AA:D53A 4A          LSR A                  ;|
$AA:D53B 6D B6 05    ADC $05B6  [$7E:05B6]  ;} If [Samus X position] / 2 + [frame counter] & 8 = 0: go to BRANCH_SONIC_BOOMS
$AA:D53E 29 08 00    AND #$0008             ;|
$AA:D541 F0 05       BEQ $05    [$D548]     ;/

; BRANCH_SPEW_ORBS
$AA:D543 B9 00 00    LDA $0000,y[$AA:CDCF]  ; Y = [[Y]]
$AA:D546 80 03       BRA $03    [$D54B]     ; Return

; BRANCH_SONIC_BOOMS
$AA:D548 B9 02 00    LDA $0002,y[$AA:CDD1]  ; Y = [[Y] + 2]

$AA:D54B A8          TAY
$AA:D54C 6B          RTL
}


;;; $D54D: Instruction - Golden Torizo walking movement - index [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:D54D 5A          PHY
$AA:D54E 64 12       STZ $12    [$7E:0012]
$AA:D550 B9 00 00    LDA $0000,y[$AA:D27F]  ;\
$AA:D553 A8          TAY                    ;|
$AA:D554 B9 9A D5    LDA $D59A,y[$AA:D5A6]  ;} Enemy X velocity = [$C4BD + [[Y]]]
$AA:D557 85 14       STA $14    [$7E:0014]  ;|
$AA:D559 9D A8 0F    STA $0FA8,x[$7E:0FA8]  ;/
$AA:D55C 22 AB C6 A0 JSL $A0C6AB[$A0:C6AB]  ; Move enemy right by [enemy X velocity]
$AA:D560 7A          PLY
$AA:D561 90 14       BCC $14    [$D577]     ; If not collided with wall: go to BRANCH_NO_COLLISION
$AA:D563 A9 00 00    LDA #$0000             ;\
$AA:D566 9F 06 78 7E STA $7E7806,x[$7E:7806];} Enemy turn around timer = 0
$AA:D56A BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:D56D 30 04       BMI $04    [$D573]     ;} If torizo is facing left:
$AA:D56F A0 BF D2    LDY #$D2BF             ; Y = $D2BF (Golden Torizo - turning right)
$AA:D572 6B          RTL                    ; Return

$AA:D573 A0 03 D2    LDY #$D203             ; Y = $D203 (Golden Torizo - turning left)
$AA:D576 6B          RTL                    ; Return

; BRANCH_NO_COLLISION
$AA:D577 22 AD C8 A0 JSL $A0C8AD[$A0:C8AD]  ; Align enemy Y position with non-square slope
$AA:D57B AD F6 0A    LDA $0AF6  [$7E:0AF6]  ;\
$AA:D57E 38          SEC                    ;|
$AA:D57F FD 7A 0F    SBC $0F7A,x[$7E:0F7A]  ;} If torizo is facing Samus:
$AA:D582 5D B4 0F    EOR $0FB4,x[$7E:0FB4]  ;|
$AA:D585 10 03       BPL $03    [$D58A]     ;/
$AA:D587 C8          INY                    ;\
$AA:D588 C8          INY                    ;} Y += 2
$AA:D589 6B          RTL                    ; Return

$AA:D58A BF 06 78 7E LDA $7E7806,x[$7E:7806];\
$AA:D58E D0 07       BNE $07    [$D597]     ;} If [enemy turn around timer] = 0:
$AA:D590 A9 10 00    LDA #$0010             ;\
$AA:D593 9F 06 78 7E STA $7E7806,x[$7E:7806];} Enemy turn around timer = 10h

$AA:D597 C8          INY                    ;\
$AA:D598 C8          INY                    ;} Y += 2
$AA:D599 6B          RTL

$AA:D59A             dw FFFB, 0000, FFFB, FFED, FFF0, FFF9, 0000, FFF9, FFEF, FFEE, 0005, 0000, 0005, 0013, 0010, 0007,
                        0000, 0007, 0011, 0012
}
}


;;; $D5C2: Torizo function - Golden Torizo - wake enemy if Samus is below and right of target position ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D5C2 A9 40 01    LDA #$0140             ;\
$AA:D5C5 CD FA 0A    CMP $0AFA  [$7E:0AFA]  ;} If [Samus Y position] > 140h:
$AA:D5C8 B0 14       BCS $14    [$D5DE]     ;/
$AA:D5CA A9 70 01    LDA #$0170             ;\
$AA:D5CD CD F6 0A    CMP $0AF6  [$7E:0AF6]  ;} If [Samus X position] > 170h:
$AA:D5D0 B0 0C       BCS $0C    [$D5DE]     ;/
$AA:D5D2 FE 92 0F    INC $0F92,x[$7E:0F92]  ;\
$AA:D5D5 FE 92 0F    INC $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer += 2
$AA:D5D8 A9 01 00    LDA #$0001             ;\
$AA:D5DB 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1

$AA:D5DE 60          RTS
}


;;; $D5DF: Torizo function - Golden Torizo - simple movement ;;;
{
;; Parameters:
;;     X: Enemy index

; Clone of $C6BF
$AA:D5DF 20 20 C6    JSR $C620  [$AA:C620]  ; Handle low-health initial drool
$AA:D5E2 20 43 C6    JSR $C643  [$AA:C643]  ; Handle falling
$AA:D5E5 60          RTS
}


;;; $D5E6: Torizo function - Golden Torizo - normal movement ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D5E6 20 20 C6    JSR $C620  [$AA:C620]  ; Handle low-health initial drool
$AA:D5E9 FC B2 0F    JSR ($0FB2,x)[$AA:D5F1]; Execute [enemy movement function]
$AA:D5EC 60          RTS
}


;;; $D5ED: Torizo movement function - Golden Torizo - attacking ;;;
{
;; Parameters:
;;     X: Enemy index

; Clone of C828
$AA:D5ED 20 43 C6    JSR $C643  [$AA:C643]  ; Handle falling
$AA:D5F0 60          RTS
}


;;; $D5F1: Torizo movement function - Golden Torizo - walking ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D5F1 BF 06 78 7E LDA $7E7806,x[$7E:7806];\
$AA:D5F5 F0 25       BEQ $25    [$D61C]     ;} If [enemy turn around timer] = 0: go to BRANCH_NOT_TURNING
$AA:D5F7 3A          DEC A                  ;\
$AA:D5F8 9F 06 78 7E STA $7E7806,x[$7E:7806];} Decrement enemy turn around timer
$AA:D5FC D0 1E       BNE $1E    [$D61C]     ; If [enemy turn around timer] != 0: go to BRANCH_NOT_TURNING
$AA:D5FE A9 00 00    LDA #$0000             ;\
$AA:D601 9F 06 78 7E STA $7E7806,x[$7E:7806];} >_<;
$AA:D605 BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:D608 30 05       BMI $05    [$D60F]     ;} If torizo is facing left:
$AA:D60A A9 BF D2    LDA #$D2BF             ; Enemy instruction list pointer = $D2BF (Golden Torizo - turning right)
$AA:D60D 80 03       BRA $03    [$D612]
                                            ; Else (torizo is facing right):
$AA:D60F A9 03 D2    LDA #$D203             ; Enemy instruction list pointer = $D203 (Golden Torizo - turning left)

$AA:D612 9D 92 0F    STA $0F92,x[$7E:0F92]
$AA:D615 A9 01 00    LDA #$0001             ;\
$AA:D618 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:D61B 60          RTS                    ; Return

; BRANCH_NOT_TURNING
$AA:D61C 64 12       STZ $12    [$7E:0012]  ;\
$AA:D61E BD A8 0F    LDA $0FA8,x[$7E:0FA8]  ;|
$AA:D621 10 04       BPL $04    [$D627]     ;|
$AA:D623 49 FF FF    EOR #$FFFF             ;|
$AA:D626 1A          INC A                  ;|
                                            ;|
$AA:D627 1A          INC A                  ;} $14.$12 = min(Fh, |[enemy X velocity]| + 1)
$AA:D628 C9 10 00    CMP #$0010             ;|
$AA:D62B 90 03       BCC $03    [$D630]     ;|
$AA:D62D A9 0F 00    LDA #$000F             ;|
                                            ;|
$AA:D630 85 14       STA $14    [$7E:0014]  ;/
$AA:D632 22 86 C7 A0 JSL $A0C786[$A0:C786]  ; Move enemy down by [$14].[$12]
$AA:D636 B0 1F       BCS $1F    [$D657]     ; If collided with block: return
$AA:D638 BD B4 0F    LDA $0FB4,x            ;\
$AA:D63B 30 05       BMI $05    [$D642]     ;} If torizo is facing left:
$AA:D63D A9 78 BC    LDA #$BC78             ; Enemy instruction list pointer = $BC78 (falling - facing left)
$AA:D640 80 03       BRA $03    [$D645]
                                            ; Else (torizo is facing right):
$AA:D642 A9 F2 C0    LDA #$C0F2             ; Enemy instruction list pointer = $C0F2 (falling - facing right)

$AA:D645 9D 92 0F    STA $0F92,x
$AA:D648 A9 01 00    LDA #$0001             ;\
$AA:D64B 9D 94 0F    STA $0F94,x            ;} Enemy instruction timer = 1
$AA:D64E A9 00 01    LDA #$0100             ;\
$AA:D651 9D AA 0F    STA $0FAA,x            ;} Enemy Y velocity = 100h
$AA:D654 9E A8 0F    STZ $0FA8,x            ; Enemy X velocity = 0

$AA:D657 60          RTS
}


;;; $D658: Golden Torizo shot reaction - stand up / sit down ;;;
{
$AA:D658 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:D65B BD 9C 0F    LDA $0F9C,x            ;\
$AA:D65E D0 06       BNE $06    [$D666]     ;} If [enemy flash timer] = 0:
$AA:D660 BF 08 78 7E LDA $7E7808,x          ;\
$AA:D664 F0 40       BEQ $40    [$D6A6]     ;} If [enemy animation lock flag] = 0: go to Golden Torizo shot reaction - damaged

$AA:D666 6B          RTL
}


;;; $D667: Golden Torizo shot reaction - normal ;;;
{
$AA:D667 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:D66A BD 9C 0F    LDA $0F9C,x[$7E:0F9C]  ;\
$AA:D66D D0 0C       BNE $0C    [$D67B]     ;} If [enemy flash timer] != 0: return
$AA:D66F BF 08 78 7E LDA $7E7808,x[$7E:7808];\
$AA:D673 F0 03       BEQ $03    [$D678]     ;} If [enemy animation lock flag] = 0: go to BRANCH
$AA:D675 4C A6 D6    JMP $D6A6  [$AA:D6A6]  ; Go to Golden Torizo shot reaction - damaged

$AA:D678 4C 7C D6    JMP $D67C  [$AA:D67C]

$AA:D67B 6B          RTL

; BRANCH
$AA:D67C BD B6 0F    LDA $0FB6,x[$7E:0FB6]  ;\
$AA:D67F 89 00 10    BIT #$1000             ;} If torizo not caught super missile:
$AA:D682 D0 19       BNE $19    [$D69D]     ;/
$AA:D684 AD A6 18    LDA $18A6  [$7E:18A6]  ;\
$AA:D687 0A          ASL A                  ;} Y = [collided projectile index] * 2
$AA:D688 A8          TAY                    ;/
$AA:D689 B9 18 0C    LDA $0C18,y[$7E:0C18]  ;\
$AA:D68C 29 00 0F    AND #$0F00             ;} Enemy $7E:780A = (projectile type) (never read)
$AA:D68F 9F 0A 78 7E STA $7E780A,x[$7E:780A];/
$AA:D693 C9 00 01    CMP #$0100             ;\
$AA:D696 F0 39       BEQ $39    [$D6D1]     ;} If (projectile type) = missile: go to Golden Torizo shot reaction - normal - missile
$AA:D698 C9 00 02    CMP #$0200             ;\
$AA:D69B F0 5A       BEQ $5A    [$D6F7]     ;} If (projectile type) = super missile: go to Golden Torizo shot reaction - normal - super missile

$AA:D69D BD B6 0F    LDA $0FB6,x[$7E:0FB6]  ;\
$AA:D6A0 09 00 20    ORA #$2000             ;} Mark torizo stunned
$AA:D6A3 9D B6 0F    STA $0FB6,x[$7E:0FB6]  ;/
}


;;; $D6A6: Golden Torizo shot reaction - damaged ;;;
{
$AA:D6A6 22 A7 A6 A0 JSL $A0A6A7[$A0:A6A7]  ; Normal enemy shot AI - no death check, no enemy shot graphic
$AA:D6AA AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:D6AD BD 8C 0F    LDA $0F8C,x[$7E:0F8C]  ;\
$AA:D6B0 D0 1E       BNE $1E    [$D6D0]     ;} If [enemy health] != 0: return
$AA:D6B2 A9 C8 B1    LDA #$B1C8             ;\
$AA:D6B5 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = $B1C8 (torizo death sequence)
$AA:D6B8 A9 01 00    LDA #$0001             ;\
$AA:D6BB 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:D6BE BD B6 0F    LDA $0FB6,x[$7E:0FB6]  ;\
$AA:D6C1 09 00 C0    ORA #$C000             ;} Mark torizo gut and face blown up
$AA:D6C4 9D B6 0F    STA $0FB6,x[$7E:0FB6]  ;/
$AA:D6C7 BD 86 0F    LDA $0F86,x[$7E:0F86]  ;\
$AA:D6CA 09 00 04    ORA #$0400             ;} Set enemy as intangible
$AA:D6CD 9D 86 0F    STA $0F86,x[$7E:0F86]  ;/

$AA:D6D0 6B          RTL
}


;;; $D6D1: Golden Torizo shot reaction - normal - missile ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Projectile index
$AA:D6D1 B9 04 0C    LDA $0C04,y            ;\
$AA:D6D4 29 EF FF    AND #$FFEF             ;} Unflag projectile for deletion(!)
$AA:D6D7 99 04 0C    STA $0C04,y            ;/
$AA:D6DA A9 AB C6    LDA #$C6AB             ;\
$AA:D6DD 9D B0 0F    STA $0FB0,x            ;} Enemy function = RTS
$AA:D6E0 A9 01 00    LDA #$0001             ;\
$AA:D6E3 9D 94 0F    STA $0F94,x            ;} Enemy instruction timer = 1
$AA:D6E6 3C B4 0F    BIT $0FB4,x            ;\
$AA:D6E9 30 05       BMI $05    [$D6F0]     ;} If torizo is facing left:
$AA:D6EB A9 F1 D1    LDA #$D1F1             ; Enemy instruction list pointer = $D1F1 (Golden Torizo - dodge - turning left)
$AA:D6EE 80 03       BRA $03    [$D6F3]
                                            ; Else (torizo is facing right):
$AA:D6F0 A9 AD D2    LDA #$D2AD             ; Enemy instruction list pointer = $D2AD (Golden Torizo - dodge - turning right)

$AA:D6F3 9D 92 0F    STA $0F92,x
$AA:D6F6 6B          RTL
}


;;; $D6F7: Golden Torizo shot reaction - normal - super missile ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Projectile index
$AA:D6F7 20 A7 D3    JSR $D3A7  [$AA:D3A7]  ;\
$AA:D6FA 10 03       BPL $03    [$D6FF]     ;} If torizo is facing away from Samus:
$AA:D6FC 4C A6 D6    JMP $D6A6  [$AA:D6A6]  ; Go to Golden Torizo shot reaction - damaged

$AA:D6FF BD B6 0F    LDA $0FB6,x            ;\
$AA:D702 09 00 10    ORA #$1000             ;} Set torizo caught super missile flag
$AA:D705 9D B6 0F    STA $0FB6,x            ;/
$AA:D708 A9 AB C6    LDA #$C6AB             ;\
$AA:D70B 9D B0 0F    STA $0FB0,x            ;} Enemy function = RTS
$AA:D70E B9 04 0C    LDA $0C04,y            ;\
$AA:D711 09 10 00    ORA #$0010             ;} Flag projectile for deletion
$AA:D714 99 04 0C    STA $0C04,y            ;/
$AA:D717 A9 01 00    LDA #$0001             ;\
$AA:D71A 9D 94 0F    STA $0F94,x            ;} Enemy instruction timer = 1
$AA:D71D BD B4 0F    LDA $0FB4,x            ;\
$AA:D720 89 00 20    BIT #$2000             ;} If torizo background leg forward: go to BRANCH_BACKGROUND_LEG_FORWARD
$AA:D723 D0 0F       BNE $0F    [$D734]     ;/
$AA:D725 3C B4 0F    BIT $0FB4,x            ;\
$AA:D728 30 05       BMI $05    [$D72F]     ;} If torizo is facing left:
$AA:D72A A9 E1 CD    LDA #$CDE1             ; Enemy instruction list pointer = $CDE1 (caught super missile - facing left - left leg forward)
$AA:D72D 80 12       BRA $12    [$D741]     ; Return

$AA:D72F A9 A5 CE    LDA #$CEA5             ; Enemy instruction list pointer = $CEA5 (caught super missile - facing right - right leg forward)
$AA:D732 80 0D       BRA $0D    [$D741]     ; Return

; BRANCH_BACKGROUND_LEG_FORWARD
$AA:D734 3C B4 0F    BIT $0FB4,x            ;\
$AA:D737 30 05       BMI $05    [$D73E]     ;} If torizo is facing left:
$AA:D739 A9 43 CE    LDA #$CE43             ; Enemy instruction list pointer = $CE43 (caught super missile - facing left - right leg forward)
$AA:D73C 80 03       BRA $03    [$D741]     ; Return

$AA:D73E A9 FF CE    LDA #$CEFF             ; Enemy instruction list pointer = $CEFF (caught super missile - facing right - left leg forward)

$AA:D741 9D 92 0F    STA $0F92,x
$AA:D744 6B          RTL
}
}


;;; $D745..D910: Tourian entrance statue ;;;
{
;;; $D745: Tourian entrance statue palettes ;;;
{
; Ridley
$AA:D745             dw 3800, 57FF, 2BFF, 1F3C, 0278, 01B0, 010B, 0087, 0044, 001F, 0012, 0009, 7FFF, 7FFF, 7FFF, 0000 ; Initial. (Sprite palette 1)

; Phantoon
$AA:D765             dw 3800, 57FF, 2BFF, 1F3C, 0278, 01B0, 010B, 0087, 0044, 7FFF, 7FFF, 7FFF, 03FF, 0252, 0129, 0000 ; Sprite palette 2

; Base decoration
$AA:D785             dw 3800, 27F9, 2375, 1AD2, 164E, 11AB, 0D27, 0484, 0000, 7F5F, 7C1F, 5816, 300C, 5294, 39CE, 2108 ; Sprite palette 7
}


;;; $D7A5: Instruction list - Tourian entrance statue - Ridley ;;;
{
$AA:D7A5             dw 807C        ; Delete
$AA:D7A7             dw 7777,D83B,
                        80ED,D7A7   ; Go to $D7A7
}


;;; $D7AF: Instruction list - Tourian entrance statue - Phantoon ;;;
{
$AA:D7AF             dw 807C        ; Delete
$AA:D7B1             dw 7777,D8B0,
                        80ED,D7B1   ; Go to $D7B1
}


;;; $D7B9: Instruction list - Tourian entrance statue - base decoration ;;;
{
$AA:D7B9             dw 807C,       ; Delete
                        0100,D816
$AA:D7BF             dw 7777,D816,
                        80ED,D7BF   ; Go to $D7BF
}


;;; $D7C7: RTL. Main AI - enemy $EFFF (Tourian entrance statue) ;;;
{
$AA:D7C7 6B          RTL
}


;;; $D7C8: Initialisation AI - enemy $EFFF (Tourian entrance statue) ;;;
{
; All the instruction lists this enemy use lead with a delete instruction
; I would have to guess that this statue was originally implemented with enemies and then later moved to enemy projectiles
; The remnant instruction lists and spritemaps are leftover, see $86:B85A / $8D:916D for the real deal

$AA:D7C8 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:D7CB 9E 96 0F    STZ $0F96,x[$7E:0FD6]  ; Enemy palette index = 0
$AA:D7CE A9 01 00    LDA #$0001             ;\
$AA:D7D1 9D 94 0F    STA $0F94,x[$7E:0FD4]  ;} Enemy instruction timer = 1
$AA:D7D4 9E 90 0F    STZ $0F90,x[$7E:0FD0]  ; Enemy timer = 0
$AA:D7D7 BC B4 0F    LDY $0FB4,x[$7E:0FF4]  ;\
$AA:D7DA B9 10 D8    LDA $D810,y[$AA:D810]  ;} Enemy instruction list pointer = [$D810 + [enemy parameter 1]]
$AA:D7DD 9D 92 0F    STA $0F92,x[$7E:0FD2]  ;/
$AA:D7E0 BC B4 0F    LDY $0FB4,x[$7E:0FF4]  ;\
$AA:D7E3 D0 15       BNE $15    [$D7FA]     ;} If [enemy parameter 1] = 0:
$AA:D7E5 A0 BE BA    LDY #$BABE             ;\
$AA:D7E8 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Tourian statue - base decoration enemy projectile
$AA:D7EC A0 A2 BA    LDY #$BAA2             ;\
$AA:D7EF 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Tourian statue - Ridley enemy projectile
$AA:D7F3 A0 B0 BA    LDY #$BAB0             ;\
$AA:D7F6 22 97 80 86 JSL $868097[$86:8097]  ;} Spawn Tourian statue - Phantoon enemy projectile

$AA:D7FA A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:D7FD BD 85 D7    LDA $D785,x[$AA:D7A3]  ;|
$AA:D800 9F E0 C3 7E STA $7EC3E0,x[$7E:C3FE];|
$AA:D804 BD 65 D7    LDA $D765,x[$AA:D783]  ;} Target sprite palette 7 = [$D785..A4] (base decoration)
$AA:D807 9F 40 C3 7E STA $7EC340,x[$7E:C35E];} Target sprite palette 2 = [$D765..84] (Phantoon)
$AA:D80B CA          DEX                    ;|
$AA:D80C CA          DEX                    ;|
$AA:D80D 10 EE       BPL $EE    [$D7FD]     ;/
$AA:D80F 6B          RTL

$AA:D810             dw D7B9, ; Base decoration
                        D7A5, ; Ridley
                        D7AF  ; Phantoon
}


;;; $D816: Unused. Spritemaps - Tourian entrance statue ;;;
{
; Base decoration
$AA:D816             dx 0007, C228,F8,1F9C, C218,F8,1F9A, C208,F8,1F98, C3F8,F8,1F96, C3E8,F8,1F94, C3D8,F8,1F92, C3C8,F8,1F90

; Ridley
$AA:D83B             dx 0017, C3E5,18,2344, C3E5,08,232C, C3F5,18,2346, 000D,20,237D, 000D,18,236D, 0005,18,2348, C215,08,2342, C205,08,2340, C3F5,08,232E, C3D5,08,232A, C215,F8,2328, C205,F8,2326, C3F5,F8,2324, C3E5,F8,2322, C3D5,F8,2320, C215,E8,230E, C205,E8,230C, C3F5,E8,230A, C3E5,E8,2308, C215,D8,2306, C205,D8,2304, C3F5,D8,2302, C3E5,D8,2300

; Phantoon
$AA:D8B0             dx 0013, 0008,1C,2587, 0000,1C,2586, 01F8,1C,2585, 01F0,1C,2584, 0000,04,2583, 0000,FC,2581, 01F8,04,2582, 01F8,FC,2580, C208,EC,2561, C3E8,EC,254D, C208,FC,2565, C208,0C,256B, C3F8,0C,2569, C3E8,0C,2567, C3E8,FC,2563, C200,EC,2560, C3F0,EC,254E, C200,DC,254B, C3F0,DC,2549
}
}


;;; $D911..E2BC: Shaktool ;;;
{
;;; $D911: Palette - enemy $F07F (Shaktool) ;;;
{
$AA:D911             dw 3800, 5755, 4A4F, 1CE4, 0C60, 56B2, 3E0D, 2D68, 2526, 03FF, 02F7, 0210, 0108, 001F, 0018, 000E
}


;;; $D931..E9: Shaktool instructions ;;;
{
;;; $D931: Unused. Instruction - lower enemy 1px away from enemy projectile ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D931 5A          PHY                    ;\
$AA:D932 BC B0 0F    LDY $0FB0,x            ;|
$AA:D935 B9 6E 10    LDA $106E,y            ;} A = [Shaktool head head direction] ^ 80h
$AA:D938 49 80 00    EOR #$0080             ;|
$AA:D93B 7A          PLY                    ;/
$AA:D93C 4C 56 D9    JMP $D956  [$AA:D956]  ; Go to move Shaktool piece 1px
}


;;; $D93F: Unused. Instruction - raise enemy 1px towards enemy projectile ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D93F 5A          PHY                    ;\
$AA:D940 BC B0 0F    LDY $0FB0,x            ;|
$AA:D943 B9 6E 10    LDA $106E,y            ;} A = [Shaktool head head direction]
$AA:D946 7A          PLY                    ;/
$AA:D947 4C 56 D9    JMP $D956  [$AA:D956]  ; Go to move Shaktool piece 1px
}


;;; $D94A: Instruction - lower enemy 1px ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D94A BD A9 0F    LDA $0FA9,x[$7E:0FE9]  ;\
$AA:D94D 49 80 00    EOR #$0080             ;} A = [enemy facing angle] / 100h ^ 80h
$AA:D950 4C 56 D9    JMP $D956  [$AA:D956]  ; Go to move Shaktool piece 1px
}


;;; $D953: Instruction - raise enemy 1px ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D953 BD A9 0F    LDA $0FA9,x[$7E:1069]  ; A = [enemy facing angle] / 100h
}


;;; $D956: Move Shaktool piece 1px ;;;
{
;; Parameters:
;;     A: Angle
;;     X: Enemy index
$AA:D956 DA          PHX
$AA:D957 5A          PHY
$AA:D958 9B          TXY                    ; Y = [X] (enemy index)
$AA:D959 29 FF 00    AND #$00FF             ;\
$AA:D95C 0A          ASL A                  ;} X = [A] % 100h * 2
$AA:D95D AA          TAX                    ;/
$AA:D95E 64 12       STZ $12    [$7E:0012]  ;\
$AA:D960 64 14       STZ $14    [$7E:0014]  ;|
$AA:D962 BF 43 B4 A0 LDA $A0B443,x[$A0:B531];|
$AA:D966 10 02       BPL $02    [$D96A]     ;} $14.$12 = sin([X] / 2 * pi / 80h)
$AA:D968 C6 14       DEC $14    [$7E:0014]  ;|
                                            ;|
$AA:D96A 85 13       STA $13    [$7E:0013]  ;/
$AA:D96C B9 7C 0F    LDA $0F7C,y[$7E:0FBC]  ;\
$AA:D96F 18          CLC                    ;|
$AA:D970 65 12       ADC $12    [$7E:0012]  ;|
$AA:D972 99 7C 0F    STA $0F7C,y[$7E:0FBC]  ;} Enemy X position += [$14].[$12]
$AA:D975 B9 7A 0F    LDA $0F7A,y[$7E:0FBA]  ;|
$AA:D978 65 14       ADC $14    [$7E:0014]  ;|
$AA:D97A 99 7A 0F    STA $0F7A,y[$7E:0FBA]  ;/
$AA:D97D 64 12       STZ $12    [$7E:0012]  ;\
$AA:D97F 64 14       STZ $14    [$7E:0014]  ;|
$AA:D981 BF C3 B3 A0 LDA $A0B3C3,x[$A0:B4B1];|
$AA:D985 10 02       BPL $02    [$D989]     ;} $14.$12 = -cos([X] / 2 * pi / 80h)
$AA:D987 C6 14       DEC $14    [$7E:0014]  ;|
                                            ;|
$AA:D989 85 13       STA $13    [$7E:0013]  ;/
$AA:D98B B9 80 0F    LDA $0F80,y[$7E:0FC0]  ;\
$AA:D98E 18          CLC                    ;|
$AA:D98F 65 12       ADC $12    [$7E:0012]  ;|
$AA:D991 99 80 0F    STA $0F80,y[$7E:0FC0]  ;} Enemy Y position += [$14].[$12]
$AA:D994 B9 7E 0F    LDA $0F7E,y[$7E:0FBE]  ;|
$AA:D997 65 14       ADC $14    [$7E:0014]  ;|
$AA:D999 99 7E 0F    STA $0F7E,y[$7E:0FBE]  ;/
$AA:D99C 7A          PLY
$AA:D99D FA          PLX
$AA:D99E 6B          RTL
}


;;; $D99F: RTL. Instruction - NOP (disabled - spawn Shaktool attack enemy projectiles) ;;;
{
;; Parameters:
;;     X: Enemy index

; This is RTL'd out, but the instruction list that calls this instruction is never used due to $DAE4 being RTS'd out anyway
$AA:D99F 6B          RTL

$AA:D9A0 5A          PHY
$AA:D9A1 A0 25 BE    LDY #$BE25             ;\
$AA:D9A4 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Shaktool's attack - front circle enemy projectile
$AA:D9A8 48          PHA                    ;\
$AA:D9A9 A0 33 BE    LDY #$BE33             ;|
$AA:D9AC 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Shaktool's attack - middle circle enemy projectile
$AA:D9B0 68          PLA                    ;/
$AA:D9B1 A0 41 BE    LDY #$BE41             ;\
$AA:D9B4 22 27 80 86 JSL $868027[$86:8027]  ;} Spawn Shaktool's attack - back circle enemy projectile
$AA:D9B8 7A          PLY
$AA:D9B9 6B          RTL
}


;;; $D9BA: Instruction - reset Shaktool functions ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:D9BA 5A          PHY
$AA:D9BB BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:D9BE AD DB DE    LDA $DEDB  [$AA:DEDB]  ;\
$AA:D9C1 99 B2 0F    STA $0FB2,y[$7E:0FB2]  ;} Shaktool primary piece function = RTS
$AA:D9C4 AD DD DE    LDA $DEDD  [$AA:DEDD]  ;\
$AA:D9C7 99 F2 0F    STA $0FF2,y[$7E:0FF2]  ;} Shaktool rightmost arm piece function = $DCAC
$AA:D9CA AD DF DE    LDA $DEDF  [$AA:DEDF]  ;\
$AA:D9CD 99 32 10    STA $1032,y[$7E:1032]  ;} Shaktool centre right arm piece function = $DCAC
$AA:D9D0 AD E1 DE    LDA $DEE1  [$AA:DEE1]  ;\
$AA:D9D3 99 72 10    STA $1072,y[$7E:1072]  ;} Shaktool head function = $DCD7
$AA:D9D6 AD E3 DE    LDA $DEE3  [$AA:DEE3]  ;\
$AA:D9D9 99 B2 10    STA $10B2,y[$7E:10B2]  ;} Shaktool centre left arm piece function = $DCAC
$AA:D9DC AD E5 DE    LDA $DEE5  [$AA:DEE5]  ;\
$AA:D9DF 99 F2 10    STA $10F2,y[$7E:10F2]  ;} Shaktool leftmost arm piece function = $DCAC
$AA:D9E2 AD E7 DE    LDA $DEE7  [$AA:DEE7]  ;\
$AA:D9E5 99 32 11    STA $1132,y[$7E:1132]  ;} Shaktool final piece function = $DD25
$AA:D9E8 7A          PLY
$AA:D9E9 6B          RTL
}
}


;;; $D9EA..DAE3: Instruction lists - Shaktool ;;;
{
;;; $D9EA..DA2D: Instruction lists - Shaktool saw hand ;;;
{
;;; $D9EA: Unused. Instruction list - Shaktool saw hand - attack - primary piece ;;;
{
$AA:D9EA             dx 813A,0240,  ; Wait 240h frames
                        80ED,DA0E   ; Go to $DA0E (primary piece)
}


;;; $D9F2: Unused. Instruction list - Shaktool saw hand - attack - final piece ;;;
{
$AA:D9F2             dx 813A,0240,  ; Wait 240h frames
                        D9BA,       ; Reset Shaktool functions
                        80ED,DA1E   ; Go to $DA1E (final piece)
}


;;; $D9FC: Instruction list - Shaktool saw hand - head bob - primary piece ;;;
{
$AA:D9FC             dx 813A,0014,  ; Wait 14h frames
                        80ED,DA0E   ; Go to $DA0E (primary piece)
}


;;; $DA04: Instruction list - Shaktool saw hand - head bob - final piece ;;;
{
$AA:DA04             dx 813A,0014,  ; Wait 14h frames
                        D9BA,       ; Reset Shaktool functions
                        80ED,DA1E   ; Go to $DA1E (final piece)
}


;;; $DA0E: Instruction list - Shaktool saw hand - primary piece ;;;
{
; Also used for the final piece before the first collision
$AA:DA0E             dx 000A,E028,
                        000A,E02F,
                        000A,E036,
                        80ED,DA0E   ; Go to $DA0E
}


;;; $DA1E: Instruction list - Shaktool saw hand - final piece ;;;
{
$AA:DA1E             dx 0003,DF5C,
                        0003,DF63,
                        0003,DF6A,
                        80ED,DA1E   ; Go to $DA1E
}
}


;;; $DA2E..79: Instruction lists - Shaktool arm piece ;;;
{
;;; $DA2E: Unused. Instruction list - Shaktool arm piece - attack - back ;;;
{
$AA:DA2E             dx 813A,00C0,  ; Wait C0h frames
                        D931,       ; Lower enemy 1px away from enemy projectile
                        813A,0080,  ; Wait 80h frames
                        D93F,       ; Raise enemy 1px towards enemy projectile
                        813A,0100,  ; Wait 100h frames
                        80ED,DA72   ; Go to $DA72 (normal)
}


;;; $DA42: Unused. Instruction list - Shaktool arm piece - attack - front ;;;
{
$AA:DA42             dx 813A,0100,  ; Wait 100h frames
                        D931,       ; Lower enemy 1px away from enemy projectile
                        813A,0080,  ; Wait 80h frames
                        D93F,       ; Raise enemy 1px towards enemy projectile
                        813A,00C0,  ; Wait C0h frames
                        80ED,DA72   ; Go to $DA72 (normal)
}


;;; $DA56: Instruction list - Shaktool arm piece - head bob - back ;;;
{
$AA:DA56             dx D94A,       ; Lower enemy 1px
                        813A,0014,  ; Wait 14h frames
                        D953,       ; Raise enemy 1px
                        80ED,DA72   ; Go to $DA72 (normal)
}


;;; $DA62: Instruction list - Shaktool arm piece - head bob - front ;;;
{
$AA:DA62             dx 813A,0004,  ; Wait 4 frames
                        D94A,       ; Lower enemy 1px
                        813A,000C,  ; Wait Ch frames
                        D953,       ; Raise enemy 1px
                        813A,0004   ; Wait 4 frames
}


;;; $DA72: Instruction list - Shaktool arm piece - normal ;;;
{
$AA:DA72             dx 0077,DF71,
                        80ED,DA72   ; Go to $DA72
}
}


;;; $DA7A..E3: Instruction lists - Shaktool head ;;;
{
;;; $DA7A: Unused. Instruction list - Shaktool head - attack ;;;
{
$AA:DA7A             dx 813A,0080,  ; Wait 80h frames
                        D931,       ; Lower enemy 1px away from enemy projectile
                        D99F,       ; NOP (disabled - spawn Shaktool attack enemy projectiles)
                        813A,0080,  ; Wait 80h frames
                        D93F,       ; Raise enemy 1px towards enemy projectile
                        813A,0140,  ; Wait 140h frames
                        813A,0001   ; Wait 1 frame
}


;;; $DA90: Instruction list - Shaktool head - head bob ;;;
{
$AA:DA90             dx 813A,0008,  ; Wait 8 frames
                        D94A,       ; Lower enemy 1px
                        813A,0004,  ; Wait 4 frames
                        D953,       ; Raise enemy 1px
                        813A,0008,  ; Wait 8 frames
                        813A,0001   ; Wait 1 frame
}


;;; $DAA4: Instruction list - Shaktool head - aiming left ;;;
{
; Useless observation: the graphical instruction delay is increasing by one for each of these instruction lists ^^;
$AA:DAA4             dx 0774,DF78,
                        80ED,DAA4   ; Go to $DAA4
}


;;; $DAAC: Instruction list - Shaktool head - aiming up-left ;;;
{
$AA:DAAC             dx 0775,DF8E,
                        80ED,DAAC   ; Go to $DAAC
}


;;; $DAB4: Instruction list - Shaktool head - aiming up ;;;
{
$AA:DAB4             dx 0776,DFA4,
                        80ED,DAB4   ; Go to $DAB4
}


;;; $DABC: Instruction list - Shaktool head - aiming up-right ;;;
{
$AA:DABC             dx 0777,DFBA,
                        80ED,DABC   ; Go to $DABC
}


;;; $DAC4: Instruction list - Shaktool head - aiming right ;;;
{
$AA:DAC4             dx 0778,DFD0,
                        80ED,DAC4   ; Go to $DAC4
}


;;; $DACC: Instruction list - Shaktool head - aiming down-right ;;;
{
$AA:DACC             dx 0779,DFE6,
                        80ED,DACC   ; Go to $DACC
}


;;; $DAD4: Instruction list - Shaktool head - aiming down ;;;
{
$AA:DAD4             dx 077A,DFFC,
                        80ED,DAD4   ; Go to $DAD4
}


;;; $DADC: Instruction list - Shaktool head - aiming down-left ;;;
{
$AA:DADC             dx 077B,E012,
                        80ED,DADC   ; Go to $DADC
}
}
}


;;; $DAE4: RTS. Maybe make Shaktool attack ;;;
{
;; Parameters:
;;     X: Enemy index

; RTS'd out
$AA:DAE4 60          RTS

$AA:DAE5 22 11 81 80 JSL $808111[$80:8111]  ; Generate random number
$AA:DAE9 89 31 84    BIT #$8431             ;\
$AA:DAEC D0 1F       BNE $1F    [$DB0D]     ;} If [random number] & 8431h != 0 (1Fh/20h chance): return
$AA:DAEE A0 0C 00    LDY #$000C             ; Y = Ch

; LOOP
$AA:DAF1 A9 AA DC    LDA #$DCAA             ;\
$AA:DAF4 9D B2 0F    STA $0FB2,x            ;} Enemy function = RTS
$AA:DAF7 B9 21 DF    LDA $DF21,y            ;\
$AA:DAFA 9D 92 0F    STA $0F92,x            ;} Enemy instruction list pointer = [$DF21 + [Y]]
$AA:DAFD A9 01 00    LDA #$0001             ;\
$AA:DB00 9D 94 0F    STA $0F94,x            ;} Enemy instruction timer = 1
$AA:DB03 8A          TXA                    ;\
$AA:DB04 38          SEC                    ;|
$AA:DB05 E9 40 00    SBC #$0040             ;} X -= 40h
$AA:DB08 AA          TAX                    ;/
$AA:DB09 88          DEY                    ;\
$AA:DB0A 88          DEY                    ;} Y -= 2
$AA:DB0B 10 E4       BPL $E4    [$DAF1]     ; If [Y] >= 0: go to LOOP

$AA:DB0D 60          RTS
}


;;; $DB0E: Shaktool pieces movement options = [A] ;;;
{
;; Parameters:
;;     A: Movement options
;;     X: Enemy index
$AA:DB0E BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:DB11 99 B4 0F    STA $0FB4,y[$7E:0FB4]  ; Shaktool primary piece movement options = [A]
$AA:DB14 99 F4 0F    STA $0FF4,y[$7E:0FF4]  ; Shaktool rightmost arm piece movement options = [A]
$AA:DB17 99 34 10    STA $1034,y[$7E:1034]  ; Shaktool centre right arm piece movement options = [A]
$AA:DB1A 99 74 10    STA $1074,y[$7E:1074]  ; Shaktool head movement options = [A]
$AA:DB1D 99 B4 10    STA $10B4,y[$7E:10B4]  ; Shaktool centre left arm piece movement options = [A]
$AA:DB20 99 F4 10    STA $10F4,y[$7E:10F4]  ; Shaktool leftmost arm piece movement options = [A]
$AA:DB23 99 34 11    STA $1134,y[$7E:1134]  ; Shaktool final piece movement options = [A]
$AA:DB26 60          RTS
}


;;; $DB27: Shaktool pieces facing angle = [A] ;;;
{
;; Parameters:
;;     A: Facing angle
;;     X: Enemy index
$AA:DB27 BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:DB2A 99 A8 0F    STA $0FA8,y[$7E:0FA8]  ; Shaktool primary piece facing angle = [A]
$AA:DB2D 99 E8 0F    STA $0FE8,y[$7E:0FE8]  ; Shaktool rightmost arm piece facing angle = [A]
$AA:DB30 99 28 10    STA $1028,y[$7E:1028]  ; Shaktool centre right arm piece facing angle = [A]
$AA:DB33 99 68 10    STA $1068,y[$7E:1068]  ; Shaktool head facing angle = [A]
$AA:DB36 99 A8 10    STA $10A8,y[$7E:10A8]  ; Shaktool centre left arm piece facing angle = [A]
$AA:DB39 99 E8 10    STA $10E8,y[$7E:10E8]  ; Shaktool leftmost arm piece facing angle = [A]
$AA:DB3C 99 28 11    STA $1128,y[$7E:1128]  ; Shaktool final piece facing angle = [A]
$AA:DB3F 60          RTS
}


;;; $DB40: Shaktool pieces neighbour angle = [A] ;;;
{
;; Parameters:
;;     A: Neighbour angle
;;     X: Enemy index
$AA:DB40 BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:DB43 99 AA 0F    STA $0FAA,y[$7E:0FAA]  ; Shaktool primary piece neighbour angle = [A]
$AA:DB46 99 EA 0F    STA $0FEA,y[$7E:0FEA]  ; Shaktool rightmost arm piece neighbour angle = [A]
$AA:DB49 99 2A 10    STA $102A,y[$7E:102A]  ; Shaktool centre right arm piece neighbour angle = [A]
$AA:DB4C 99 6A 10    STA $106A,y[$7E:106A]  ; Shaktool head neighbour angle = [A]
$AA:DB4F 99 AA 10    STA $10AA,y[$7E:10AA]  ; Shaktool centre left arm piece neighbour angle = [A]
$AA:DB52 99 EA 10    STA $10EA,y[$7E:10EA]  ; Shaktool leftmost arm piece neighbour angle = [A]
$AA:DB55 99 2A 11    STA $112A,y[$7E:112A]  ; Shaktool final piece neighbour angle = [A]
$AA:DB58 60          RTS
}


;;; $DB59: Flip Shaktool ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:DB59 BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:DB5C B9 6E 10    LDA $106E,y[$7E:106E]  ;\
$AA:DB5F 49 00 80    EOR #$8000             ;} Set Shaktool head as flipped
$AA:DB62 99 6E 10    STA $106E,y[$7E:106E]  ;/
$AA:DB65 BE 2A 11    LDX $112A,y[$7E:112A]  ;\
$AA:DB68 B9 EA 0F    LDA $0FEA,y[$7E:0FEA]  ;|
$AA:DB6B 49 00 80    EOR #$8000             ;|
$AA:DB6E 29 00 FF    AND #$FF00             ;} swap(Shaktool rightmost arm piece neighbour angle, Shaktool final piece neighbour angle)
$AA:DB71 99 2A 11    STA $112A,y[$7E:112A]  ;} Shaktool rightmost arm piece neighbour angle = [Shaktool rightmost arm piece neighbour angle] & FF00h ^ 8000h
$AA:DB74 8A          TXA                    ;} Shaktool final piece neighbour angle = [Shaktool final piece neighbour angle] & FF00h ^ 8000h
$AA:DB75 49 00 80    EOR #$8000             ;|
$AA:DB78 29 00 FF    AND #$FF00             ;|
$AA:DB7B 99 EA 0F    STA $0FEA,y[$7E:0FEA]  ;/
$AA:DB7E BE EA 10    LDX $10EA,y[$7E:10EA]  ;\
$AA:DB81 B9 2A 10    LDA $102A,y[$7E:102A]  ;|
$AA:DB84 49 00 80    EOR #$8000             ;|
$AA:DB87 29 00 FF    AND #$FF00             ;} swap(Shaktool centre right arm piece neighbour angle, Shaktool leftmost arm piece neighbour angle)
$AA:DB8A 99 EA 10    STA $10EA,y[$7E:10EA]  ;} Shaktool centre right arm piece neighbour angle = [Shaktool centre right arm piece neighbour angle] & FF00h ^ 8000h
$AA:DB8D 8A          TXA                    ;} Shaktool leftmost arm piece neighbour angle = [Shaktool leftmost arm piece neighbour angle] & FF00h ^ 8000h
$AA:DB8E 49 00 80    EOR #$8000             ;|
$AA:DB91 29 00 FF    AND #$FF00             ;|
$AA:DB94 99 2A 10    STA $102A,y[$7E:102A]  ;/
$AA:DB97 BE AA 10    LDX $10AA,y[$7E:10AA]  ;\
$AA:DB9A B9 6A 10    LDA $106A,y[$7E:106A]  ;|
$AA:DB9D 49 00 80    EOR #$8000             ;|
$AA:DBA0 29 00 FF    AND #$FF00             ;} swap(Shaktool centre left arm piece neighbour angle, Shaktool head neighbour angle)
$AA:DBA3 99 AA 10    STA $10AA,y[$7E:10AA]  ;} Shaktool centre left arm piece neighbour angle = [Shaktool centre left arm piece neighbour angle] & FF00h ^ 8000h
$AA:DBA6 8A          TXA                    ;} Shaktool head neighbour angle = [Shaktool head neighbour angle] & FF00h ^ 8000h
$AA:DBA7 49 00 80    EOR #$8000             ;|
$AA:DBAA 29 00 FF    AND #$FF00             ;|
$AA:DBAD 99 6A 10    STA $106A,y[$7E:106A]  ;/
$AA:DBB0 BE FC 10    LDX $10FC,y[$7E:10FC]  ;\
$AA:DBB3 B9 7C 0F    LDA $0F7C,y[$7E:0F7C]  ;|
$AA:DBB6 99 FC 10    STA $10FC,y[$7E:10FC]  ;} swap(Shaktool primary piece X subposition, Shaktool final piece X subposition)
$AA:DBB9 8A          TXA                    ;|
$AA:DBBA 99 7C 0F    STA $0F7C,y[$7E:0F7C]  ;/
$AA:DBBD BE 00 11    LDX $1100,y[$7E:1100]  ;\
$AA:DBC0 B9 80 0F    LDA $0F80,y[$7E:0F80]  ;|
$AA:DBC3 99 00 11    STA $1100,y[$7E:1100]  ;} swap(Shaktool primary piece Y subposition, Shaktool final piece Y subposition)
$AA:DBC6 8A          TXA                    ;|
$AA:DBC7 99 80 0F    STA $0F80,y[$7E:0F80]  ;/
$AA:DBCA BE FA 10    LDX $10FA,y[$7E:10FA]  ;\
$AA:DBCD B9 7A 0F    LDA $0F7A,y[$7E:0F7A]  ;|
$AA:DBD0 99 FA 10    STA $10FA,y[$7E:10FA]  ;} swap(Shaktool primary piece X position, Shaktool final piece X position)
$AA:DBD3 8A          TXA                    ;|
$AA:DBD4 99 7A 0F    STA $0F7A,y[$7E:0F7A]  ;/
$AA:DBD7 BE FE 10    LDX $10FE,y[$7E:10FE]  ;\
$AA:DBDA B9 7E 0F    LDA $0F7E,y[$7E:0F7E]  ;|
$AA:DBDD 99 FE 10    STA $10FE,y[$7E:10FE]  ;} swap(Shaktool primary piece Y position, Shaktool final piece Y position)
$AA:DBE0 8A          TXA                    ;|
$AA:DBE1 99 7E 0F    STA $0F7E,y[$7E:0F7E]  ;/
$AA:DBE4 BB          TYX                    ; X = [enemy primary piece enemy index]
$AA:DBE5 A9 00 80    LDA #$8000             ;\
$AA:DBE8 9D BC 0F    STA $0FBC,x[$7E:0FBC]  ;} Shaktool rightmost arm piece X subposition = 8000h
$AA:DBEB 9D FC 0F    STA $0FFC,x[$7E:0FFC]  ; Shaktool centre right arm piece X subposition = 8000h
$AA:DBEE 9D 3C 10    STA $103C,x[$7E:103C]  ; Shaktool head X subposition = 8000h
$AA:DBF1 9D 7C 10    STA $107C,x[$7E:107C]  ; Shaktool centre left arm piece X subposition = 8000h
$AA:DBF4 9D BC 10    STA $10BC,x[$7E:10BC]  ; Shaktool leftmost arm piece X subposition = 8000h
$AA:DBF7 9D C0 0F    STA $0FC0,x[$7E:0FC0]  ; Shaktool rightmost arm piece Y subposition = 8000h
$AA:DBFA 9D 00 10    STA $1000,x[$7E:1000]  ; Shaktool centre right arm piece Y subposition = 8000h
$AA:DBFD 9D 40 10    STA $1040,x[$7E:1040]  ; Shaktool head Y subposition = 8000h
$AA:DC00 9D 80 10    STA $1080,x[$7E:1080]  ; Shaktool centre left arm piece Y subposition = 8000h
$AA:DC03 9D C0 10    STA $10C0,x[$7E:10C0]  ; Shaktool leftmost arm piece Y subposition = 8000h
$AA:DC06 60          RTS
}


;;; $DC07: Set Shaktool piece neighbour angle delta due to block collision ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:DC07 A9 00 00    LDA #$0000
$AA:DC0A 38          SEC
$AA:DC0B 3C B4 0F    BIT $0FB4,x[$7E:1134]  ;\
$AA:DC0E 30 09       BMI $09    [$DC19]     ;} If enemy is moving clockwise:
$AA:DC10 FD AA 0F    SBC $0FAA,x[$7E:112A]  ;\
$AA:DC13 18          CLC                    ;} A = [enemy facing angle] - [enemy neighbour angle]
$AA:DC14 7D A8 0F    ADC $0FA8,x[$7E:1128]  ;/
$AA:DC17 80 07       BRA $07    [$DC20]

$AA:DC19 FD A8 0F    SBC $0FA8,x            ;\ Else (enemy is moving anti-clockwise):
$AA:DC1C 18          CLC                    ;} A = [enemy neighbour angle] - [enemy facing angle]
$AA:DC1D 7D AA 0F    ADC $0FAA,x            ;/

$AA:DC20 EB          XBA                    ;\
$AA:DC21 29 FF 00    AND #$00FF             ;|
$AA:DC24 0A          ASL A                  ;} Enemy neighbour angle delta = [A] / 40h
$AA:DC25 0A          ASL A                  ;|
$AA:DC26 9D AC 0F    STA $0FAC,x[$7E:112C]  ;/
$AA:DC29 60          RTS
}


;;; $DC2A: Position Shaktool piece relative to previous piece ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:DC2A BD AB 0F    LDA $0FAB,x[$7E:0FEB]  ;\
$AA:DC2D 29 FF 00    AND #$00FF             ;|
$AA:DC30 0A          ASL A                  ;} Y = [enemy neighbour angle] / 100h * 2
$AA:DC31 A8          TAY                    ;/
$AA:DC32 64 12       STZ $12    [$7E:0012]  ;\
$AA:DC34 64 14       STZ $14    [$7E:0014]  ;|
$AA:DC36 B9 BD E0    LDA $E0BD,y[$AA:E2AD]  ;|
$AA:DC39 10 02       BPL $02    [$DC3D]     ;} $14.$12 = sin([enemy neighbour angle] * pi / 8000h) * BFFh / 100h
$AA:DC3B C6 14       DEC $14    [$7E:0014]  ;|
                                            ;|
$AA:DC3D 85 13       STA $13    [$7E:0013]  ;/
$AA:DC3F A5 12       LDA $12    [$7E:0012]  ;\
$AA:DC41 18          CLC                    ;|
$AA:DC42 7D 3C 0F    ADC $0F3C,x[$7E:0F7C]  ;|
$AA:DC45 9D 7C 0F    STA $0F7C,x[$7E:0FBC]  ;} Enemy X position = [enemy ([X] - 1) X position] + [$14].[$12]
$AA:DC48 A5 14       LDA $14    [$7E:0014]  ;|
$AA:DC4A 7D 3A 0F    ADC $0F3A,x[$7E:0F7A]  ;|
$AA:DC4D 9D 7A 0F    STA $0F7A,x[$7E:0FBA]  ;/
$AA:DC50 64 12       STZ $12    [$7E:0012]  ;\
$AA:DC52 64 14       STZ $14    [$7E:0014]  ;|
$AA:DC54 B9 3D E0    LDA $E03D,y[$AA:E22D]  ;|
$AA:DC57 10 02       BPL $02    [$DC5B]     ;} $14.$12 = -cos([enemy neighbour angle] * pi / 8000h) * BFFh / 100h
$AA:DC59 C6 14       DEC $14    [$7E:0014]  ;|
                                            ;|
$AA:DC5B 85 13       STA $13    [$7E:0013]  ;/
$AA:DC5D A5 12       LDA $12    [$7E:0012]  ;\
$AA:DC5F 18          CLC                    ;|
$AA:DC60 7D 40 0F    ADC $0F40,x[$7E:0F80]  ;|
$AA:DC63 9D 80 0F    STA $0F80,x[$7E:0FC0]  ;} Enemy Y position = [enemy ([X] - 1) Y position] + [$14].[$12]
$AA:DC66 A5 14       LDA $14    [$7E:0014]  ;|
$AA:DC68 7D 3E 0F    ADC $0F3E,x[$7E:0F7E]  ;|
$AA:DC6B 9D 7E 0F    STA $0F7E,x[$7E:0FBE]  ;/
$AA:DC6E 60          RTS
}


;;; $DC6F: Set Shaktool pieces neighbour angle and angle delta for curling ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:DC6F BD A8 0F    LDA $0FA8,x[$7E:1128]  ;\
$AA:DC72 20 40 DB    JSR $DB40  [$AA:DB40]  ;} Shaktool pieces neighbour angle = [enemy facing angle]
$AA:DC75 BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:DC78 AD E9 DE    LDA $DEE9  [$AA:DEE9]  ;\
$AA:DC7B 99 AC 0F    STA $0FAC,y[$7E:0FAC]  ;} Shaktool primary piece neighbour angle delta = 0
$AA:DC7E AD EB DE    LDA $DEEB  [$AA:DEEB]  ;\
$AA:DC81 99 EC 0F    STA $0FEC,y[$7E:0FEC]  ;} Shaktool rightmost arm piece neighbour angle delta = 20h
$AA:DC84 AD ED DE    LDA $DEED  [$AA:DEED]  ;\
$AA:DC87 99 2C 10    STA $102C,y[$7E:102C]  ;} Shaktool centre right arm piece neighbour angle delta = 60h
$AA:DC8A AD EF DE    LDA $DEEF  [$AA:DEEF]  ;\
$AA:DC8D 99 6C 10    STA $106C,y[$7E:106C]  ;} Shaktool head neighbour angle delta = C0h
$AA:DC90 AD F1 DE    LDA $DEF1  [$AA:DEF1]  ;\
$AA:DC93 99 AC 10    STA $10AC,y[$7E:10AC]  ;} Shaktool centre left arm piece neighbour angle delta = 140h
$AA:DC96 AD F3 DE    LDA $DEF3  [$AA:DEF3]  ;\
$AA:DC99 99 EC 10    STA $10EC,y[$7E:10EC]  ;} Shaktool leftmost arm piece neighbour angle delta = 1A0h
$AA:DC9C AD F5 DE    LDA $DEF5  [$AA:DEF5]  ;\
$AA:DC9F 99 2C 11    STA $112C,y[$7E:112C]  ;} Shaktool final piece neighbour angle delta = 1E0h
$AA:DCA2 60          RTS
}


;;; $DCA3: Main AI / hurt AI - enemy $F07F (Shaktool) ;;;
{
$AA:DCA3 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:DCA6 FC B2 0F    JSR ($0FB2,x)[$AA:DCAB]; Execute [enemy function]
$AA:DCA9 6B          RTL
}


;;; $DCAA: RTS ;;;
{
$AA:DCAA 60          RTS
}


;;; $DCAB: RTS. Shaktool function - primary piece ;;;
{
$AA:DCAB 60          RTS
}


;;; $DCAC: Shaktool function - arm piece. Set position and handle curling ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:DCAC 20 2A DC    JSR $DC2A  [$AA:DC2A]  ; Position Shaktool piece relative to previous piece
$AA:DCAF 3C B4 0F    BIT $0FB4,x[$7E:0FF4]  ;\
$AA:DCB2 50 0F       BVC $0F    [$DCC3]     ;} If enemy is maximally curled:
$AA:DCB4 A9 00 01    LDA #$0100             ;\
$AA:DCB7 18          CLC                    ;|
$AA:DCB8 7D A8 0F    ADC $0FA8,x[$7E:0FE8]  ;} Enemy facing angle += 100h
$AA:DCBB 9D A8 0F    STA $0FA8,x[$7E:0FE8]  ;/
$AA:DCBE A9 00 01    LDA #$0100             ; A = 100h
$AA:DCC1 80 03       BRA $03    [$DCC6]
                                            ; Else (enemy is not maximally curled):
$AA:DCC3 BD AC 0F    LDA $0FAC,x[$7E:0FEC]  ; A = [enemy neighbour angle delta]

$AA:DCC6 3C B4 0F    BIT $0FB4,x[$7E:0FF4]  ;\
$AA:DCC9 10 04       BPL $04    [$DCCF]     ;} If enemy is moving anti-clockwise:
$AA:DCCB 49 FF FF    EOR #$FFFF             ;\
$AA:DCCE 1A          INC A                  ;} A = -[A]

$AA:DCCF 18          CLC                    ;\
$AA:DCD0 7D AA 0F    ADC $0FAA,x[$7E:0FEA]  ;} Enemy neighbour angle += [A]
$AA:DCD3 9D AA 0F    STA $0FAA,x[$7E:0FEA]  ;/
$AA:DCD6 60          RTS
}


;;; $DCD7: Shaktool function - head ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:DCD7 20 AC DC    JSR $DCAC  [$AA:DCAC]  ; Set position and handle curling
$AA:DCDA BD AA 0F    LDA $0FAA,x[$7E:106A]  ;\
$AA:DCDD 49 00 80    EOR #$8000             ;|
$AA:DCE0 85 12       STA $12    [$7E:0012]  ;|
$AA:DCE2 BD EA 0F    LDA $0FEA,x[$7E:10AA]  ;|
$AA:DCE5 38          SEC                    ;} A = midpoint([enemy neighbour angle] ^ 8000h, [enemy ([X] + 1) neighbour angle])
$AA:DCE6 E5 12       SBC $12    [$7E:0012]  ;|
$AA:DCE8 4A          LSR A                  ;|
$AA:DCE9 18          CLC                    ;|
$AA:DCEA 65 12       ADC $12    [$7E:0012]  ;/
$AA:DCEC 3C AE 0F    BIT $0FAE,x[$7E:106E]  ;\
$AA:DCEF 10 03       BPL $03    [$DCF4]     ;} If enemy is flipped:
$AA:DCF1 49 00 80    EOR #$8000             ; A ^= 8000h

$AA:DCF4 EB          XBA                    ;\
$AA:DCF5 18          CLC                    ;|
$AA:DCF6 69 08 00    ADC #$0008             ;} A = ([A] / 100h + 8) / 20h * 20h
$AA:DCF9 29 E0 00    AND #$00E0             ;/
$AA:DCFC E2 20       SEP #$20               ;\
$AA:DCFE 9D AE 0F    STA $0FAE,x[$7E:106E]  ;} Enemy head direction = [A]
$AA:DD01 C2 20       REP #$20               ;/
$AA:DD03 4A          LSR A                  ;\
$AA:DD04 4A          LSR A                  ;|
$AA:DD05 4A          LSR A                  ;|
$AA:DD06 4A          LSR A                  ;} Enemy instruction list pointer = [$DD15 + [enemy head direction] / 20h * 2]
$AA:DD07 A8          TAY                    ;|
$AA:DD08 B9 15 DD    LDA $DD15,y[$AA:DD1D]  ;|
$AA:DD0B 9D 92 0F    STA $0F92,x[$7E:1052]  ;/
$AA:DD0E A9 01 00    LDA #$0001             ;\
$AA:DD11 9D 94 0F    STA $0F94,x[$7E:1054]  ;} Enemy instruction timer = 1
$AA:DD14 60          RTS

$AA:DD15             dw DAB4, DABC, DAC4, DACC, DAD4, DADC, DAA4, DAAC
}


;;; $DD25: Shaktool function - final piece ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:DD25 BD 7E 0F    LDA $0F7E,x[$7E:10FE]  ;\
$AA:DD28 48          PHA                    ;} Save [enemy Y position] (old Y position)
$AA:DD29 BD 7A 0F    LDA $0F7A,x[$7E:10FA]  ;\
$AA:DD2C 48          PHA                    ;} Save [enemy X position] (old X position)
$AA:DD2D 20 AC DC    JSR $DCAC  [$AA:DCAC]  ; Set position and handle curling
$AA:DD30 BD 7E 0F    LDA $0F7E,x[$7E:10FE]  ;\
$AA:DD33 48          PHA                    ;} Save [enemy Y position] (new Y position)
$AA:DD34 BD 7A 0F    LDA $0F7A,x[$7E:10FA]  ;\
$AA:DD37 48          PHA                    ;} Save [enemy X position] (new X position)
$AA:DD38 A3 05       LDA $05,s  [$7E:1FEB]  ;\
$AA:DD3A 9D 7A 0F    STA $0F7A,x[$7E:10FA]  ;} Enemy X position = (old X position)
$AA:DD3D A3 07       LDA $07,s  [$7E:1FED]  ;\
$AA:DD3F 9D 7E 0F    STA $0F7E,x[$7E:10FE]  ;} Enemy Y position = (old Y position)
$AA:DD42 64 12       STZ $12    [$7E:0012]  ;\
$AA:DD44 A3 01       LDA $01,s  [$7E:1FE7]  ;|
$AA:DD46 38          SEC                    ;|
$AA:DD47 E3 05       SBC $05,s  [$7E:1FEB]  ;} Move enemy right by (new X position) - (old X position)
$AA:DD49 85 14       STA $14    [$7E:0014]  ;|
$AA:DD4B 22 AB C6 A0 JSL $A0C6AB[$A0:C6AB]  ;/
$AA:DD4F B0 73       BCS $73    [$DDC4]     ; If collided with block: go to BRANCH_COLLISION
$AA:DD51 A3 07       LDA $07,s  [$7E:1FED]  ;\
$AA:DD53 9D 7E 0F    STA $0F7E,x[$7E:10FE]  ;} Enemy Y position = (old Y position)
$AA:DD56 64 12       STZ $12    [$7E:0012]  ;\
$AA:DD58 A3 03       LDA $03,s  [$7E:1FE9]  ;|
$AA:DD5A 38          SEC                    ;|
$AA:DD5B E3 07       SBC $07,s  [$7E:1FED]  ;} Move enemy down by (new Y position) - (old Y position)
$AA:DD5D 85 14       STA $14    [$7E:0014]  ;|
$AA:DD5F 22 86 C7 A0 JSL $A0C786[$A0:C786]  ;/
$AA:DD63 B0 5F       BCS $5F    [$DDC4]     ; If collided with block: go to BRANCH_COLLISION
$AA:DD65 68          PLA                    ;\
$AA:DD66 9D 7A 0F    STA $0F7A,x[$7E:10FA]  ;} Enemy X position = (new X position)
$AA:DD69 68          PLA                    ;\
$AA:DD6A 9D 7E 0F    STA $0F7E,x[$7E:10FE]  ;} Enemy Y position = (new Y position)
$AA:DD6D 68          PLA
$AA:DD6E 68          PLA
$AA:DD6F 3C B4 0F    BIT $0FB4,x[$7E:1134]  ;\
$AA:DD72 50 0B       BVC $0B    [$DD7F]     ;} If enemy is maximally curled:
$AA:DD74 A9 00 01    LDA #$0100             ;\
$AA:DD77 18          CLC                    ;|
$AA:DD78 7D A8 0F    ADC $0FA8,x[$7E:1128]  ;} Enemy facing angle += 100h
$AA:DD7B 9D A8 0F    STA $0FA8,x[$7E:1128]  ;/
$AA:DD7E 60          RTS                    ; Return

$AA:DD7F BD AA 0F    LDA $0FAA,x[$7E:112A]  ;\
$AA:DD82 5D A8 0F    EOR $0FA8,x[$7E:1128]  ;|
$AA:DD85 29 00 FF    AND #$FF00             ;} If [enemy neighbour angle] / 100h = [enemy facing angle] / 100h:
$AA:DD88 D0 1B       BNE $1B    [$DDA5]     ;/
$AA:DD8A 20 6F DC    JSR $DC6F  [$AA:DC6F]  ; Set Shaktool pieces neighbour angle and angle delta for curling
$AA:DD8D A9 00 78    LDA #$7800             ;\
$AA:DD90 9D AE 0F    STA $0FAE,x[$7E:112E]  ;} Enemy angle curled = 7800h
$AA:DD93 BD B4 0F    LDA $0FB4,x[$7E:1134]  ;\
$AA:DD96 29 FF DF    AND #$DFFF             ;} Set Shaktool pieces as curling
$AA:DD99 20 0E DB    JSR $DB0E  [$AA:DB0E]  ;/
$AA:DD9C BD AE 0F    LDA $0FAE,x[$7E:112E]  ;\
$AA:DD9F 29 00 FF    AND #$FF00             ;} Enemy angle curled &= FF00h
$AA:DDA2 9D AE 0F    STA $0FAE,x[$7E:112E]  ;/

$AA:DDA5 BD AC 0F    LDA $0FAC,x[$7E:112C]  ;\
$AA:DDA8 18          CLC                    ;|
$AA:DDA9 7D AE 0F    ADC $0FAE,x[$7E:112E]  ;} Enemy angle curled += [enemy neighbour angle delta]
$AA:DDAC 9D AE 0F    STA $0FAE,x[$7E:112E]  ;/
$AA:DDAF C9 00 F0    CMP #$F000             ;\
$AA:DDB2 90 0C       BCC $0C    [$DDC0]     ;} If [enemy angle curled] >= F000h:
$AA:DDB4 BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:DDB7 BD B4 0F    LDA $0FB4,x[$7E:1134]  ;\
$AA:DDBA 09 00 40    ORA #$4000             ;} Set Shaktool pieces as maximally curled
$AA:DDBD 20 0E DB    JSR $DB0E  [$AA:DB0E]  ;/

$AA:DDC0 20 E4 DA    JSR $DAE4  [$AA:DAE4]  ; RTS. Maybe make Shaktool attack
$AA:DDC3 60          RTS                    ; Return

; BRANCH_COLLISION
$AA:DDC4 BD B4 0F    LDA $0FB4,x[$7E:1134]  ;\
$AA:DDC7 89 00 20    BIT #$2000             ;} If enemy is uncurling:
$AA:DDCA F0 12       BEQ $12    [$DDDE]     ;/
$AA:DDCC 68          PLA
$AA:DDCD 68          PLA
$AA:DDCE 68          PLA
$AA:DDCF 68          PLA
$AA:DDD0 BD B4 0F    LDA $0FB4,x            ;\
$AA:DDD3 49 00 80    EOR #$8000             ;|
$AA:DDD6 29 FF 8F    AND #$8FFF             ;} Set Shaktool pieces as curling, not maximally curled, and moving in opposite direction
$AA:DDD9 20 0E DB    JSR $DB0E  [$AA:DB0E]  ;/
$AA:DDDC 80 22       BRA $22    [$DE00]

$AA:DDDE 68          PLA                    ; Else (enemy is curling):
$AA:DDDF 68          PLA
$AA:DDE0 68          PLA                    ;\
$AA:DDE1 9D 7A 0F    STA $0F7A,x[$7E:10FA]  ;} Enemy X position = (old X position)
$AA:DDE4 68          PLA                    ;\
$AA:DDE5 9D 7E 0F    STA $0F7E,x[$7E:10FE]  ;} Enemy Y position = (old Y position)
$AA:DDE8 20 59 DB    JSR $DB59  [$AA:DB59]  ; Flip Shaktool
$AA:DDEB AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:DDEE BD B4 0F    LDA $0FB4,x[$7E:1134]  ;\
$AA:DDF1 09 00 20    ORA #$2000             ;} Set Shaktool pieces as uncurling (this first call to $DB0E is redundant)
$AA:DDF4 20 0E DB    JSR $DB0E  [$AA:DB0E]  ;/
$AA:DDF7 BD B4 0F    LDA $0FB4,x[$7E:1134]  ;\
$AA:DDFA 29 FF BF    AND #$BFFF             ;} Set Shaktool pieces as non maximally curled
$AA:DDFD 20 0E DB    JSR $DB0E  [$AA:DB0E]  ;/

$AA:DE00 9E AE 0F    STZ $0FAE,x[$7E:112E]  ; Enemy angle curled = 0
$AA:DE03 BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:DE06 22 96 C0 A0 JSL $A0C096[$A0:C096]  ; A = angle of enemy [X] from enemy [Y]
$AA:DE0A EB          XBA                    ;\
$AA:DE0B 29 00 FF    AND #$FF00             ;} A *= 100h
$AA:DE0E 3C B4 0F    BIT $0FB4,x[$7E:1134]  ;\
$AA:DE11 30 06       BMI $06    [$DE19]     ;} If enemy is moving clockwise:
$AA:DE13 18          CLC                    ;\
$AA:DE14 69 00 40    ADC #$4000             ;} A += 4000h
$AA:DE17 80 04       BRA $04    [$DE1D]

$AA:DE19 38          SEC                    ;\ Else (enemy is moving anti-clockwise):
$AA:DE1A E9 00 40    SBC #$4000             ;} A -= 4000h

$AA:DE1D 20 27 DB    JSR $DB27  [$AA:DB27]  ; Shaktool pieces facing angle = [A]
$AA:DE20 A0 0C 00    LDY #$000C             ; Y = Ch

; LOOP
$AA:DE23 20 07 DC    JSR $DC07  [$AA:DC07]  ; Set Shaktool piece neighbour angle delta due to block collision
$AA:DE26 A9 AA DC    LDA #$DCAA             ;\
$AA:DE29 9D B2 0F    STA $0FB2,x[$7E:1132]  ;} Enemy function = RTS
$AA:DE2C B9 13 DF    LDA $DF13,y[$AA:DF1F]  ;\
$AA:DE2F 9D 92 0F    STA $0F92,x[$7E:1112]  ;} Enemy instruction list pointer = [$DF13 + [Y]] (head bob)
$AA:DE32 A9 01 00    LDA #$0001             ;\
$AA:DE35 9D 94 0F    STA $0F94,x[$7E:1114]  ;} Enemy instruction timer = 1
$AA:DE38 8A          TXA                    ;\
$AA:DE39 38          SEC                    ;|
$AA:DE3A E9 40 00    SBC #$0040             ;} X -= 40h
$AA:DE3D AA          TAX                    ;/
$AA:DE3E 88          DEY                    ;\
$AA:DE3F 88          DEY                    ;} Y -= 2
$AA:DE40 10 E1       BPL $E1    [$DE23]     ; If [Y] >= 0: go to LOOP
$AA:DE42 60          RTS
}


;;; $DE43: Initialisation AI - enemy $F07F (Shaktool) ;;;
{
; Parameter 2 is used for piece index (multiple of 2). Range 0..Ch
; Index identifies pieces starting from the initial rightmost piece and increasing to the initial leftmost piece
$AA:DE43 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:DE46 A9 01 00    LDA #$0001             ;\
$AA:DE49 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:DE4C 9E 90 0F    STZ $0F90,x[$7E:0F90]  ; Enemy timer = 0
$AA:DE4F A9 00 00    LDA #$0000             ;\
$AA:DE52 9D A8 0F    STA $0FA8,x[$7E:0FA8]  ;} Enemy facing angle = 0
$AA:DE55 9D AE 0F    STA $0FAE,x[$7E:0FAE]  ; Enemy head direction / flip flag / angle curled = 0
$AA:DE58 BC B6 0F    LDY $0FB6,x[$7E:0FB6]  ; Y = [enemy parameter 2]
$AA:DE5B BD 86 0F    LDA $0F86,x[$7E:0F86]  ;\
$AA:DE5E 19 95 DE    ORA $DE95,y[$AA:DE95]  ;} Enemy properties |= [$DE95 + [Y]] (process instructions, process whilst off-screen, and maybe intangible)
$AA:DE61 9D 86 0F    STA $0F86,x[$7E:0F86]  ;/
$AA:DE64 8A          TXA                    ;\
$AA:DE65 38          SEC                    ;|
$AA:DE66 F9 A3 DE    SBC $DEA3,y[$AA:DEA3]  ;} Enemy primary piece enemy index = [enemy index] - [$DEA3 + [Y]]
$AA:DE69 9D B0 0F    STA $0FB0,x[$7E:0FB0]  ;/
$AA:DE6C B9 DB DE    LDA $DEDB,y[$AA:DEDB]  ;\
$AA:DE6F 9D B2 0F    STA $0FB2,x[$7E:0FB2]  ;} Enemy function = [$DEDB + [Y]]
$AA:DE72 B9 E9 DE    LDA $DEE9,y[$AA:DEE9]  ;\
$AA:DE75 38          SEC                    ;|
$AA:DE76 F9 F7 DE    SBC $DEF7,y[$AA:DEF7]  ;} Enemy neighbour angle delta = [$DEE9 + [Y]]
$AA:DE79 9D AC 0F    STA $0FAC,x[$7E:0FAC]  ;/
$AA:DE7C B9 B1 DE    LDA $DEB1,y[$AA:DEB1]  ;\
$AA:DE7F 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;} Enemy neighbour angle = [$DEB1 + [Y]]
$AA:DE82 B9 BF DE    LDA $DEBF,y[$AA:DEBF]  ;\
$AA:DE85 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = [$DEBF + [Y]]
$AA:DE88 B9 CD DE    LDA $DECD,y[$AA:DECD]  ;\
$AA:DE8B 9D 9A 0F    STA $0F9A,x[$7E:0F9A]  ;} Enemy layer = [$DECD + [Y]]
$AA:DE8E 98          TYA                    ;\
$AA:DE8F F0 03       BEQ $03    [$DE94]     ;} If [Y] != 0:
$AA:DE91 20 2A DC    JSR $DC2A  [$AA:DC2A]  ; Position Shaktool piece relative to previous piece

$AA:DE94 6B          RTL
}


;;; $DE95: Shaktool piece data ;;;
{
;                        _______________________________________ Initially right saw hand (primary piece)
;                       |      _________________________________ Initially rightmost arm piece
;                       |     |      ___________________________ Initially centre right arm piece
;                       |     |     |      _____________________ Head
;                       |     |     |     |      _______________ Initially centre left arm piece
;                       |     |     |     |     |      _________ Initially leftmost arm piece
;                       |     |     |     |     |     |      ___ Initially left saw hand (final piece)
;                       |     |     |     |     |     |     |
$AA:DE95             dw 2800, 2C00, 2C00, 2C00, 2C00, 2C00, 2800 ; Properties
$AA:DEA3             dw 0000, 0040, 0080, 00C0, 0100, 0140, 0180 ; Enemy RAM offset from primary piece
$AA:DEB1             dw 0000, F800, E800, D000, B000, 9800, 8800 ; Initial neighbour angle
$AA:DEBF             dw DA0E, DA72, DA72, DAD4, DA72, DA72, DA0E ; Initial instruction list pointer
$AA:DECD             dw 0002, 0004, 0004, 0002, 0004, 0004, 0002 ; Layer control
$AA:DEDB             dw DCAB, DCAC, DCAC, DCD7, DCAC, DCAC, DD25 ; Function pointer
$AA:DEE9             dw 0000, 0020, 0060, 00C0, 0140, 01A0, 01E0 ; Initial curling neighbour angle delta
$AA:DEF7             dw 0000, 0000, 0000, 0000, 0000, 0000, 0000 ; Zero
$AA:DF05             dw 0000, 0000, 0002, 0004, 0006, 0008, 000A ; Unused
$AA:DF13             dw D9FC, DA56, DA62, DA90, DA62, DA56, DA04 ; Head bob instruction list pointers
$AA:DF21             dw D9EA, DA2E, DA42, DA7A, DA42, DA2E, D9F2 ; Unused. Attack instruction list pointers
}


;;; $DF2F: Enemy touch - enemy $F07F (Shaktool) ;;;
{
$AA:DF2F 22 77 A4 A0 JSL $A0A477[$A0:A477]  ; Normal enemy touch AI
$AA:DF33 6B          RTL
}


;;; $DF34: Enemy shot - enemy $F07F (Shaktool) ;;;
{
; Bug: when an enemy dies and goes through its death animation, its enemy RAM is cleared,
; so the LDY always loads 0, meaning this only works out if Shaktool is the first enemy in the room

$AA:DF34 22 3D A6 A0 JSL $A0A63D[$A0:A63D]  ; Normal enemy shot AI
$AA:DF38 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:DF3B BD 8C 0F    LDA $0F8C,x[$7E:0F8C]  ;\
$AA:DF3E D0 1B       BNE $1B    [$DF5B]     ;} If [enemy health] != 0: return
$AA:DF40 BC B0 0F    LDY $0FB0,x[$7E:1130]  ; Y = [enemy primary piece enemy index]
$AA:DF43 A9 00 02    LDA #$0200             ;\
$AA:DF46 99 86 0F    STA $0F86,y[$7E:0F86]  ;|
$AA:DF49 99 C6 0F    STA $0FC6,y[$7E:0FC6]  ;|
$AA:DF4C 99 06 10    STA $1006,y[$7E:1006]  ;|
$AA:DF4F 99 46 10    STA $1046,y[$7E:1046]  ;} Set all pieces to delete (ish, see note above)
$AA:DF52 99 86 10    STA $1086,y[$7E:1086]  ;|
$AA:DF55 99 C6 10    STA $10C6,y[$7E:10C6]  ;|
$AA:DF58 99 06 11    STA $1106,y[$7E:1106]  ;/

$AA:DF5B 6B          RTL
}


;;; $DF5C: Spritemaps - Shaktool ;;;
{
; Saw hand - final piece (spins anti-clockwise)
$AA:DF5C             dx 0001, 81F8,F8,2100
$AA:DF63             dx 0001, 81F8,F8,2102
$AA:DF6A             dx 0001, 81F8,F8,2104

; Arm piece
$AA:DF71             dx 0001, 81F8,F8,2106

; Head
$AA:DF78             dx 0004, 81F8,F8,2108, 0001,F6,211F, 0001,02,211F, 01F0,FC,210E
$AA:DF8E             dx 0004, 01F4,F4,210F, 81F8,F8,610C, 0004,FC,211F, 01FC,04,211F
$AA:DFA4             dx 0004, 81F8,F8,210A, 0002,01,211F, 01F6,01,211F, 01FC,F0,211E
$AA:DFBA             dx 0004, 0004,F4,610F, 81F8,F8,210C, 01FC,04,211F, 01F4,FC,211F
$AA:DFD0             dx 0004, 81F8,F8,6108, 01F7,02,211F, 01F7,F6,211F, 0008,FC,610E
$AA:DFE6             dx 0004, 0004,04,E10F, 81F8,F8,A10C, 01F4,FC,211F, 01FC,F4,211F
$AA:DFFC             dx 0004, 81F8,F8,A10A, 0002,F7,211F, 01F6,F7,211F, 01FC,08,A11E
$AA:E012             dx 0004, 01F4,04,A10F, 81F8,F8,E10C, 0004,FC,211F, 01FC,F4,211F

; Saw hand - primary piece (spins clockwise)
$AA:E028             dx 0001, 81F8,F8,6100
$AA:E02F             dx 0001, 81F8,F8,6102
$AA:E036             dx 0001, 81F8,F8,6104
}


;;; $E03D: Sine/cosine tables ;;;
{
; Negative cosine
$AA:E03D              dw F401, F401, F404, F409, F40F, F418, F422, F42E, F43C, F44B, F45D, F470, F485, F49C, F4B4, F4CE, F4EA, F508, F527, F549, F56B, F590, F5B6, F5DD, F606, F631, F65D, F68B, F6BA, F6EA, F71C, F750, F784, F7BA, F7F1, F82A, F864, F89E, F8DA, F918, F956, F995, F9D5, FA16, FA58, FA9B, FADF, FB24, FB69, FBAF, FBF6, FC3D, FC85, FCCD, FD16, FD5F, FDA9, FDF3, FE3E, FE88, FED3, FF1E, FF6A, FFB5

; Sine
$AA:E0BD              dw 0000, 004B, 0096, 00E1, 012D, 0178, 01C2, 020D, 0257, 02A1, 02EA, 0333, 037B, 03C3, 040A, 0451, 0497, 04DC, 0521, 0565, 05A8, 05EA, 062B, 066B, 06AA, 06E8, 0725, 0761, 079C, 07D6, 080F, 0846, 087C, 08B0, 08E4, 0916, 0946, 0975, 09A3, 09CF, 09FA, 0A23, 0A4A, 0A70, 0A95, 0AB7, 0AD9, 0AF8, 0B16, 0B32, 0B4C, 0B64, 0B7B, 0B90, 0BA3, 0BB5, 0BC4, 0BD2, 0BDE, 0BE8, 0BF1, 0BF7, 0BFC, 0BFF

; Cosine
$AA:E13D              dw 0BFF, 0BFF, 0BFC, 0BF7, 0BF1, 0BE8, 0BDE, 0BD2, 0BC4, 0BB5, 0BA3, 0B90, 0B7B, 0B64, 0B4C, 0B32, 0B16, 0AF8, 0AD9, 0AB7, 0A95, 0A70, 0A4A, 0A23, 09FA, 09CF, 09A3, 0975, 0946, 0916, 08E4, 08B0, 087C, 0846, 080F, 07D6, 079C, 0761, 0725, 06E8, 06AA, 066B, 062B, 05EA, 05A8, 0565, 0521, 04DC, 0497, 0451, 040A, 03C3, 037B, 0333, 02EA, 02A1, 0257, 020D, 01C2, 0178, 012D, 00E1, 0096, 004B

; Negative sine
$AA:E1BD              dw 0000, FFB5, FF6A, FF1F, FED3, FE88, FE3E, FDF3, FDA9, FD5F, FD16, FCCD, FC85, FC3D, FBF6, FBAF, FB69, FB24, FADF, FA9B, FA58, FA16, F9D5, F995, F956, F918, F8DB, F89F, F864, F82A, F7F1, F7BA, F784, F750, F71C, F6EA, F6BA, F68B, F65D, F631, F606, F5DD, F5B6, F590, F56B, F549, F527, F508, F4EA, F4CE, F4B4, F49C, F485, F470, F45D, F44B, F43C, F42E, F422, F418, F40F, F409, F404, F401

; Negative cosine
$AA:E23D              dw F401, F401, F404, F409, F40F, F418, F422, F42E, F43C, F44B, F45D, F470, F485, F49C, F4B4, F4CE, F4EA, F508, F527, F549, F56B, F590, F5B6, F5DD, F606, F631, F65D, F68B, F6BA, F6EA, F71C, F750, F784, F7BA, F7F1, F82A, F864, F89E, F8DA, F918, F956, F995, F9D5, FA16, FA58, FA9B, FADF, FB24, FB69, FBAF, FBF6, FC3D, FC85, FCCD, FD16, FD5F, FDA9, FDF3, FE3E, FE88, FED3, FF1E, FF6A, FFB5
}
}


;;; $E2BD..F7D2: n00b tube cracks / chozo statue ;;;
{
;;; $E2BD: n00b tube cracks palettes ;;;
{
; Wow, three copies of the same palette
$AA:E2BD             dw 3800, 7F9C, 7F17, 6E72, 59EE, 456A, 3528, 28E6, 777F, 66FB, 5676, 45F2, 358D, 2509, 1484, 0400 ; Initial. (Sprite palette 7)
$AA:E2DD             dw 3800, 7F9C, 7F17, 6E72, 59EE, 456A, 3528, 28E6, 777F, 66FB, 5676, 45F2, 358D, 2509, 1484, 0400 ; Sprite palette 1
$AA:E2FD             dw 3800, 7F9C, 7F17, 6E72, 59EE, 456A, 3528, 28E6, 777F, 66FB, 5676, 45F2, 358D, 2509, 1484, 0400 ; Sprite palette 2
}


;;; $E31D: Chozo statue palettes ;;;
{
$AA:E31D             dw 3800, 633F, 4A9F, 2DDF, 6739, 4E73, 318C, 18C6, 27FF, 1AF7, 0DCE, 00C6, 3FFF, 2B39, 7FFF, 0000 ; Wrecked Ship - sprite palette 1
$AA:E33D             dw 3800, 633F, 4A9F, 2DDF, 4210, 318C, 2108, 1084, 27FF, 1AF7, 0DCE, 00C6, 3FFF, 2B39, 5294, 0000 ; Wrecked Ship - sprite palette 2
$AA:E35D             dw 3800, 633F, 4A9F, 2DDF, 2F7C, 2295, 118D, 08E8, 27FF, 1AF7, 0DCE, 00C6, 3FFF, 2B39, 73DF, 0043 ; Lower Norfair - sprite palette 1
$AA:E37D             dw 3800, 633F, 4A9F, 2DDF, 2295, 118D, 08E8, 0085, 27FF, 1AF7, 0DCE, 00C6, 3FFF, 2B39, 5294, 0001 ; Lower Norfair - sprite palette 2
}


;;; $E39D..E456: Chozo statue - Lower Norfair ;;;
{
;;; $E39D: Instruction list - chozo statue - Lower Norfair - initial ;;;
{
$AA:E39D             dx 806B,E445,  ; Enemy function = $E445
                        0001,EFD8,
                        812F        ; Sleep
}


;;; $E3A7: Instruction list - chozo statue - Lower Norfair - activated ;;;
{
$AA:E3A7             dx 8074,       ; Enemy function = RTS
                        E5D8,0020,  ; Chozo statue movement - index 20h
                        0020,EFD8,
                        E5D8,0022,  ; Chozo statue movement - index 22h
                        0008,F034,
                        E5D8,0024,  ; Chozo statue movement - index 24h
                        0030,F08B,
                        E57F,       ; Queue chozo grabs Samus sound effect
                        E5D8,0026,  ; Chozo statue movement - index 26h
                        0040,F0E2,
                        0006,F4B4,
                        0008,F510,
                        000A,F56C,
                        000C,F5C8,
                        0060,F624,
                        E429,       ; Start lowering acid
                        8123,0005   ; Timer = 5
$AA:E3E5             dx 000B,F510,
                        0008,F56C,
                        0006,F5C8,
                        0008,F624,
                        0006,F5C8,
                        0008,F56C,
                        8110,E3E5,  ; Decrement timer and go to $E3E5 if non-zero
                        8074,       ; Enemy function = RTS
                        E5D8,0026,  ; Chozo statue movement - index 26h
                        0080,F0E2,
                        E5D8,0024,  ; Chozo statue movement - index 24h
                        0050,F08B,
                        E5D8,0022,  ; Chozo statue movement - index 22h
                        0008,F034,
                        E5D8,0020,  ; Chozo statue movement - index 20h
                        0020,EFD8,
                        E43D,       ; Unlock Samus
                        E436,       ; Set lowered acid position
                        812F        ; Sleep
}


;;; $E429: Instruction - start lowering acid ;;;
{
$AA:E429 A9 20 00    LDA #$0020             ;\
$AA:E42C 8D 80 19    STA $1980  [$7E:1980]  ;} FX timer = 20h
$AA:E42F A9 40 00    LDA #$0040             ;\
$AA:E432 8D 7C 19    STA $197C  [$7E:197C]  ;} FX Y velocity = 0.40h
$AA:E435 6B          RTL
}


;;; $E436: Instruction - set lowered acid position ;;;
{
$AA:E436 A9 D2 02    LDA #$02D2             ;\
$AA:E439 8D 78 19    STA $1978  [$7E:1978]  ;} FX base Y position = 2D2h
$AA:E43C 6B          RTL
}


;;; $E43D: Instruction - unlock Samus ;;;
{
$AA:E43D A9 01 00    LDA #$0001             ;\
$AA:E440 22 84 F0 90 JSL $90F084[$90:F084]  ;} Run Samus command - unlock Samus
$AA:E444 6B          RTL
}


;;; $E445: Chozo statue function - Lower Norfair ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:E445 BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:E448 F0 0C       BEQ $0C    [$E456]     ;} If [enemy activation flag] = 0: return
$AA:E44A A9 A7 E3    LDA #$E3A7             ;\
$AA:E44D 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = $E3A7 (activated)
$AA:E450 A9 01 00    LDA #$0001             ;\
$AA:E453 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1

$AA:E456 60          RTS
}
}


;;; $E457..E715: Chozo statue - Wrecked Ship ;;;
{
;;; $E457: Instruction list - chozo statue - Wrecked Ship - initial ;;;
{
$AA:E457             dx 806B,E7AE,  ; Enemy function = $E7AE
                        0001,E7DD,
                        812F        ; Sleep
}


;;; $E461: Instruction list - chozo statue - Wrecked Ship - activated ;;;
{
$AA:E461             dw 8074,       ; Enemy function = RTS
                        E5D8,0000,  ; Chozo statue movement - index 0
                        0020,E7DD,
                        E5D8,0002,  ; Chozo statue movement - index 2
                        0008,E839,
                        E5D8,0004,  ; Chozo statue movement - index 4
                        0050,E890,
                        E57F,       ; Queue chozo grabs Samus sound effect
                        E5D8,0006,  ; Chozo statue movement - index 6
                        0080,E8E7,
                        0006,ECB9,
                        0008,ED15,
                        000A,ED71,
                        000C,EDCD,
                        0080,EE29,
                        8123,0004   ; Timer = 4
$AA:E49D             dw 000B,ED15,
                        0008,ED71,
                        0006,EDCD,
                        0008,EE29,
                        0006,EDCD,
                        0008,ED71,
                        8110,E49D,  ; Decrement timer and go to $E49D if non-zero
                        806B,E7DA,  ; Enemy function = RTS
                        8123,0010   ; Timer = 10h
$AA:E4C1             dw E5D8,0016,  ; Chozo statue movement - index 16h
                        E58F,FFF8,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -8
                        0008,EC49,
                        E587,       ; Queue chozo footsteps sound effect
                        E5D8,0008,  ; Chozo statue movement - index 8
                        E58F,FFEC,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -14h
                        000B,E943,
                        E5D8,000A,  ; Chozo statue movement - index Ah
                        E58F,FFF0,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -10h
                        0008,E9AE,
                        E5D8,000C,  ; Chozo statue movement - index Ch
                        E58F,0000,  ; Spawn chozo spike clearing footstep enemy projectile with X offset 0
                        0006,EA1E,
                        E5D8,000E,  ; Chozo statue movement - index Eh
                        E58F,FFF8,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -8
                        0008,EA8E,
                        E587,       ; Queue chozo footsteps sound effect
                        E5D8,0010,  ; Chozo statue movement - index 10h
                        E58F,FFEC,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -14h
                        000B,EAFE,
                        E5D8,0012,  ; Chozo statue movement - index 12h
                        E58F,FFF0,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -10h
                        0008,EB69,
                        E5D8,0014,  ; Chozo statue movement - index 14h
                        E58F,0000,  ; Spawn chozo spike clearing footstep enemy projectile with X offset 0
                        0006,EBD9,
                        8110,E4C1,  ; Decrement timer and go to $E4C1 if non-zero
                        E5D8,0016,  ; Chozo statue movement - index 16h
                        E58F,FFF8,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -8
                        0008,EC49,
                        E5D8,0008,  ; Chozo statue movement - index 8
                        E58F,FFEC,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -14h
                        000B,E943,
                        E5D8,000A,  ; Chozo statue movement - index Ah
                        E58F,FFF0,  ; Spawn chozo spike clearing footstep enemy projectile with X offset -10h
                        0008,E9AE,
                        E5D8,000C,  ; Chozo statue movement - index Ch
                        E58F,0000,  ; Spawn chozo spike clearing footstep enemy projectile with X offset 0
                        0006,EA1E,
                        8074,       ; Enemy function = RTS
                        E5D8,0006,  ; Chozo statue movement - index 6
                        0080,E8E7,
                        E5D8,0004,  ; Chozo statue movement - index 4
                        0050,E890,
                        E5D8,0002,  ; Chozo statue movement - index 2
                        0008,E839,
                        E5D8,0000,  ; Chozo statue movement - index 0
                        0020,E7DD,
                        E6F0,       ; Release Samus and block slope access
                        812F        ; Sleep
}


;;; $E57F: Instruction - queue chozo grabs Samus sound effect ;;;
{
$AA:E57F A9 1C 00    LDA #$001C             ;\
$AA:E582 22 CB 90 80 JSL $8090CB[$80:90CB]  ;} Queue sound 1Ch, sound library 2, max queued sounds allowed = 6 (chozo grabs Samus)
$AA:E586 6B          RTL
}


;;; $E587: Instruction - queue chozo footsteps sound effect ;;;
{
$AA:E587 A9 4B 00    LDA #$004B             ;\
$AA:E58A 22 CB 90 80 JSL $8090CB[$80:90CB]  ;} Queue sound 4Bh, sound library 2, max queued sounds allowed = 6 (chozo / torizo footsteps)
$AA:E58E 6B          RTL
}


;;; $E58F: Instruction - spawn chozo spike clearing footstep enemy projectile with X offset [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:E58F DA          PHX
$AA:E590 5A          PHY
$AA:E591 BD 7A 0F    LDA $0F7A,x[$7E:0F7A]  ;\
$AA:E594 18          CLC                    ;|
$AA:E595 79 00 00    ADC $0000,y[$AA:E4C7]  ;|
$AA:E598 48          PHA                    ;|
$AA:E599 BD 7E 0F    LDA $0F7E,x[$7E:0F7E]  ;} Calculate the block containing enemy position + ([[Y]], 1Ch)
$AA:E59C 18          CLC                    ;|
$AA:E59D 69 1C 00    ADC #$001C             ;|
$AA:E5A0 48          PHA                    ;|
$AA:E5A1 22 70 BB A0 JSL $A0BB70[$A0:BB70]  ;/
$AA:E5A5 AD C4 0D    LDA $0DC4  [$7E:0DC4]  ;\
$AA:E5A8 18          CLC                    ;|
$AA:E5A9 6D A5 07    ADC $07A5  [$7E:07A5]  ;|
$AA:E5AC 0A          ASL A                  ;|
$AA:E5AD AA          TAX                    ;} If block one row down is a spike block:
$AA:E5AE BF 02 00 7F LDA $7F0002,x[$7F:14D8];|
$AA:E5B2 29 00 F0    AND #$F000             ;|
$AA:E5B5 C9 00 A0    CMP #$A000             ;|
$AA:E5B8 D0 19       BNE $19    [$E5D3]     ;/
$AA:E5BA 8A          TXA                    ;\
$AA:E5BB 38          SEC                    ;|
$AA:E5BC ED A5 07    SBC $07A5  [$7E:07A5]  ;} >_<;
$AA:E5BF AA          TAX                    ;/
$AA:E5C0 A9 13 D1    LDA #$D113             ;\
$AA:E5C3 22 E7 84 84 JSL $8484E7[$84:84E7]  ;} Spawn PLM $D113 (chozo crumbled block)
$AA:E5C7 7A          PLY
$AA:E5C8 5A          PHY
$AA:E5C9 B9 00 00    LDA $0000,y[$AA:E507]  ;\
$AA:E5CC A0 68 AF    LDY #$AF68             ;} Spawn Wrecked Ship chozo spike clearing footsteps enemy projectile with parameter [[Y]]
$AA:E5CF 22 97 80 86 JSL $868097[$86:8097]  ;/

$AA:E5D3 7A          PLY
$AA:E5D4 FA          PLX
$AA:E5D5 C8          INY                    ;\
$AA:E5D6 C8          INY                    ;} Y += 2
$AA:E5D7 6B          RTL
}


;;; $E5D8: Instruction - chozo statue movement - index [[Y]] ;;;
{
;; Parameters:
;;     X: Enemy index
;;     Y: Pointer to instruction arguments
;; Returns:
;;     Y: Pointer to next instruction
$AA:E5D8 B9 00 00    LDA $0000,y[$AA:E465]  ;\
$AA:E5DB 9D AC 0F    STA $0FAC,x[$7E:0FAC]  ;} Enemy movement index = [[Y]]
$AA:E5DE 5A          PHY
$AA:E5DF 64 12       STZ $12    [$7E:0012]  ;\
$AA:E5E1 64 14       STZ $14    [$7E:0014]  ;|
$AA:E5E3 BC AC 0F    LDY $0FAC,x[$7E:0FAC]  ;|
$AA:E5E6 B9 30 E6    LDA $E630,y[$AA:E630]  ;|
$AA:E5E9 10 02       BPL $02    [$E5ED]     ;} $14.$12 = [$E630 + [enemy movement index]] / 100h
$AA:E5EB C6 14       DEC $14    [$7E:0014]  ;|
                                            ;|
$AA:E5ED 85 13       STA $13    [$7E:0013]  ;/
$AA:E5EF 22 AB C6 A0 JSL $A0C6AB[$A0:C6AB]  ; Move enemy right by [$14].[$12]
$AA:E5F3 B0 00       BCS $00    [$E5F5]     ; >_<;

$AA:E5F5 64 12       STZ $12    [$7E:0012]  ;\
$AA:E5F7 64 14       STZ $14    [$7E:0014]  ;|
$AA:E5F9 BC AC 0F    LDY $0FAC,x[$7E:0FAC]  ;|
$AA:E5FC B9 30 E6    LDA $E630,y[$AA:E630]  ;|
$AA:E5FF 10 04       BPL $04    [$E605]     ;|
$AA:E601 49 FF FF    EOR #$FFFF             ;|
$AA:E604 1A          INC A                  ;} $14.$12 = |[$E630 + [enemy movement index]]| / 100h
                                            ;|
$AA:E605 10 02       BPL $02    [$E609]     ;|
$AA:E607 C6 14       DEC $14    [$7E:0014]  ;|
                                            ;|
$AA:E609 85 13       STA $13    [$7E:0013]  ;/
$AA:E60B 22 86 C7 A0 JSL $A0C786[$A0:C786]  ; Move enemy down by [$14].[$12]
$AA:E60F B0 00       BCS $00    [$E611]     ; >_<;

$AA:E611 22 AD C8 A0 JSL $A0C8AD[$A0:C8AD]  ; Align enemy Y position with non-square slope
$AA:E615 BC AC 0F    LDY $0FAC,x[$7E:0FAC]  ;\
$AA:E618 BD 7A 0F    LDA $0F7A,x[$7E:0F7A]  ;|
$AA:E61B 18          CLC                    ;} Samus X position = [enemy X position] + [$E670 + [enemy movement index]]
$AA:E61C 79 70 E6    ADC $E670,y[$AA:E670]  ;|
$AA:E61F 8D F6 0A    STA $0AF6  [$7E:0AF6]  ;/
$AA:E622 BD 7E 0F    LDA $0F7E,x[$7E:0F7E]  ;\
$AA:E625 18          CLC                    ;|
$AA:E626 79 B0 E6    ADC $E6B0,y[$AA:E6B0]  ;} Samus Y position = [enemy Y position] + [$E6B0 + [enemy movement index]]
$AA:E629 8D FA 0A    STA $0AFA  [$7E:0AFA]  ;/
$AA:E62C 7A          PLY
$AA:E62D C8          INY                    ;\
$AA:E62E C8          INY                    ;} Y += 2
$AA:E62F 6B          RTL

; Enemy X velocity. Unit 1/100h px/frame. Absolute value used for Y velocity
$AA:E630             dw 0000,0000,0000,0000,FE00,FD00,F200,F800,FE00,FD00,F200,F800, 0000,0000,0000,0000, ; 0..1Eh: Wrecked Ship. Only 0..16h used
                        0000,0000,0000,0000, 0200,0300,0E00,0800,0200,0300,0E00,0800,0000,0000,0000,0000  ; 20h..3Eh: Lower Norfair. Only 0..6h used

; Samus X offsets from enemy
$AA:E670             dw FFE4,FFE2,FFE0,FFE0,FFE0,FFE0,FFE0,FFE0,FFE0,FFE0,FFE0,FFE0, FFE0,FFE0,FFE0,FFE0, ; 0..1Eh: Wrecked Ship. Only 0..16h used
                        001C,001E,0020,0020, 0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020  ; 20h..3Eh: Lower Norfair. Only 0..6h used

; Samus Y offsets from enemy
$AA:E6B0             dw FFE0,FFE7,FFE9,FFE9,FFE9,FFE8,FFE7,FFE8,FFE9,FFE8,FFE7,FFE8, FFE9,FFE9,FFE9,FFE9, ; 0..1Eh: Wrecked Ship. Only 0..16h used
                        FFE0,FFE7,FFE9,FFE9, FFE9,FFE8,FFE7,FFE8,FFE9,FFE8,FFE7,FFE8,FFE9,FFE9,FFE9,FFE9  ; 20h..3Eh: Lower Norfair. Only 0..6h used
}


;;; $E6F0: Instruction - release Samus and block slope access ;;;
{
$AA:E6F0 A9 01 00    LDA #$0001             ;\
$AA:E6F3 22 84 F0 90 JSL $90F084[$90:F084]  ;} Run Samus command - unlock Samus
$AA:E6F7 A9 00 00    LDA #$0000             ;\
$AA:E6FA 8F 26 CD 7E STA $7ECD26[$7E:CD26]  ;|
$AA:E6FE 8F 28 CD 7E STA $7ECD28[$7E:CD28]  ;|
$AA:E702 8F 29 CD 7E STA $7ECD29[$7E:CD29]  ;} Scroll 6..Ah,Eh = red, scroll Dh = blue
$AA:E706 A9 01 00    LDA #$0001             ;|
$AA:E709 8F 2D CD 7E STA $7ECD2D[$7E:CD2D]  ;/
$AA:E70D 22 D7 83 84 JSL $8483D7[$84:83D7]  ;\
$AA:E711             dx 17, 1D, D6FC        ;} Block slope access for Wrecked Ship chozo
$AA:E715 6B          RTL
}
}


;;; $E716: Initialisation AI - enemy $F0BF (n00b tube cracks) ;;;
{
$AA:E716 A2 3E 00    LDX #$003E             ;\
                                            ;|
$AA:E719 BD DD E2    LDA $E2DD,x[$AA:E31B]  ;|
$AA:E71C 9F 20 C3 7E STA $7EC320,x[$7E:C35E];} Target sprite palette 1..2 = [$E2DD..E31C]
$AA:E720 CA          DEX                    ;|
$AA:E721 CA          DEX                    ;|
$AA:E722 10 F5       BPL $F5    [$E719]     ;/
$AA:E724 6B          RTL
}


;;; $E725: Initialisation AI - enemy $F0FF (chozo statue) ;;;
{
$AA:E725 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:E728 BD 86 0F    LDA $0F86,x[$7E:0F86]  ;\
$AA:E72B 09 00 A8    ORA #$A800             ;} Set enemy to process whilst off-screen, process instructions, hitbox solid to Samus
$AA:E72E 9D 86 0F    STA $0F86,x[$7E:0F86]  ;/
$AA:E731 A9 4D 80    LDA #$804D             ;\
$AA:E734 9D 8E 0F    STA $0F8E,x[$7E:0F8E]  ;} Enemy spritemap pointer = $804D (no effect)
$AA:E737 A9 01 00    LDA #$0001             ;\
$AA:E73A 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:E73D 9E 90 0F    STZ $0F90,x[$7E:0F90]  ; Enemy timer = 0
$AA:E740 A9 A6 E7    LDA #$E7A6             ;\
$AA:E743 9D B2 0F    STA $0FB2,x[$7E:0FB2]  ;} Enemy function = RTS
$AA:E746 A9 00 00    LDA #$0000             ;\
$AA:E749 9D B4 0F    STA $0FB4,x[$7E:0FB4]  ;} Enemy activation flag = 0
$AA:E74C 9E 96 0F    STZ $0F96,x[$7E:0F96]  ; Enemy palette index = 0
$AA:E74F 9C 9A 0F    STZ $0F9A  [$7E:0F9A]  ; Enemy 0 layer = 0
$AA:E752 BC B6 0F    LDY $0FB6,x[$7E:0FB6]  ;\
$AA:E755 B9 A2 E7    LDA $E7A2,y[$AA:E7A2]  ;} Enemy instruction list pointer = [$E7A2 + [enemy parameter 2]]
$AA:E758 9D 92 0F    STA $0F92,x[$7E:0F92]  ;/
$AA:E75B 98          TYA                    ;\
$AA:E75C D0 26       BNE $26    [$E784]     ;} If [enemy parameter 2] = 0 (Wrecked Ship):
$AA:E75E A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:E761 BD 3D E3    LDA $E33D,x[$AA:E35B]  ;|
$AA:E764 9F 40 C3 7E STA $7EC340,x[$7E:C35E];|
$AA:E768 BD 1D E3    LDA $E31D,x[$AA:E33B]  ;} Target sprite palette 1..2 = [$E31D..5C]
$AA:E76B 9F 20 C3 7E STA $7EC320,x[$7E:C33E];|
$AA:E76F CA          DEX                    ;|
$AA:E770 CA          DEX                    ;|
$AA:E771 10 EE       BPL $EE    [$E761]     ;/
$AA:E773 22 D7 83 84 JSL $8483D7[$84:83D7]  ;\
$AA:E777             dx 4A,17,D6EE          ;} Spawn Wrecked Ship chozo hand PLM
$AA:E77B 22 D7 83 84 JSL $8483D7[$84:83D7]  ;\
$AA:E77F             dx 17,1D,D6FC          ;} Spawn block slope access for Wrecked Ship chozo PLM
$AA:E783 6B          RTL                    ; Return

$AA:E784 A2 1E 00    LDX #$001E             ;\
                                            ;|
$AA:E787 BD 7D E3    LDA $E37D,x[$AA:E39B]  ;|
$AA:E78A 9F 40 C3 7E STA $7EC340,x[$7E:C35E];|
$AA:E78E BD 5D E3    LDA $E35D,x[$AA:E37B]  ;} Target sprite palette 1..2 = [$E35D..9C]
$AA:E791 9F 20 C3 7E STA $7EC320,x[$7E:C33E];|
$AA:E795 CA          DEX                    ;|
$AA:E796 CA          DEX                    ;|
$AA:E797 10 EE       BPL $EE    [$E787]     ;/
$AA:E799 22 D7 83 84 JSL $8483D7[$84:83D7]  ;\
$AA:E79D             dx 0C,1D,D6D6          ;} Spawn Lower Norfair chozo hand PLM
$AA:E7A1 6B          RTL

; Enemy instruction list pointers
$AA:E7A2             dw E457, E39D
}


;;; $E7A6: RTS ;;;
{
$AA:E7A6 60          RTS
}


;;; $E7A7: Main AI - enemy $F0FF (chozo statue) ;;;
{
$AA:E7A7 AE 54 0E    LDX $0E54  [$7E:0E54]
$AA:E7AA FC B2 0F    JSR ($0FB2,x)[$AA:E7A6]; Execute [enemy function]
$AA:E7AD 6B          RTL
}


;;; $E7AE: Chozo statue function - Wrecked Ship ;;;
{
;; Parameters:
;;     X: Enemy index
$AA:E7AE DA          PHX                    ;\
$AA:E7AF AE 9F 07    LDX $079F  [$7E:079F]  ;|
$AA:E7B2 BF 28 D8 7E LDA $7ED828,x[$7E:D82B];|
$AA:E7B6 FA          PLX                    ;} If area boss is alive: return
$AA:E7B7 29 01 00    AND #$0001             ;|
$AA:E7BA F0 1D       BEQ $1D    [$E7D9]     ;/
$AA:E7BC BD B4 0F    LDA $0FB4,x[$7E:0FB4]  ;\
$AA:E7BF F0 18       BEQ $18    [$E7D9]     ;} If [enemy activation flag] = 0: return
$AA:E7C1 A9 61 E4    LDA #$E461             ;\
$AA:E7C4 9D 92 0F    STA $0F92,x[$7E:0F92]  ;} Enemy instruction list pointer = $E461 (activated)
$AA:E7C7 A9 01 00    LDA #$0001             ;\
$AA:E7CA 9D 94 0F    STA $0F94,x[$7E:0F94]  ;} Enemy instruction timer = 1
$AA:E7CD A9 00 FF    LDA #$FF00             ;\
$AA:E7D0 9D A8 0F    STA $0FA8,x[$7E:0FA8]  ;} Enemy $0FA8 = -100h (never read)
$AA:E7D3 A9 00 01    LDA #$0100             ;\
$AA:E7D6 9D AA 0F    STA $0FAA,x[$7E:0FAA]  ;} Enemy $0FAA = 100h (never read)

$AA:E7D9 60          RTS
}


;;; $E7DA: RTS ;;;
{
$AA:E7DA 60          RTS
}


;;; $E7DB: RTL. Enemy touch - enemy $F0FF (chozo statue) ;;;
{
$AA:E7DB 6B          RTL
}


;;; $E7DC: RTL. Enemy shot - enemy $F0FF (chozo statue) ;;;
{
$AA:E7DC 6B          RTL
}


;;; $E7DD: Chozo statue spritemaps ;;;
{
$AA:E7DD             dx 0012, 01FA,DF,237D, C3D6,E7,2320, 01E6,E7,230F, C3E6,EF,2322, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:E839             dx 0011, 01FA,DF,237D, C3E9,ED,232A, C3D9,ED,2328, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:E890             dx 0011, C3E8,ED,2326, C3D8,ED,2324, 01FA,DF,237D, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:E8E7             dx 0012, C3E8,ED,2326, C3D8,E9,232C, 01E0,F9,231F, 01FA,DF,237D, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:E943             dx 0015, 01E0,F9,231F, C3E8,ED,2326, 01FA,DF,2379, C3E9,1B,2371, C3E1,1B,2370, C3EE,10,2358, C3EE,08,2348, C3F4,FD,2344, C3F4,F7,2308, C3FC,F7,2309, C210,15,2575, C204,09,254E, C3FB,FD,6542, C3FB,05,6552, C3D8,E9,232C, C3ED,EC,230D, C3F5,E4,230B, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:E9AE             dx 0016, 01E0,F8,231F, C3E8,EC,2326, 01FA,DE,237A, C3EC,1C,2371, C3E4,1C,2370, C3F1,11,2358, C3F1,09,2348, C3F7,04,2352, C3F7,FC,2342, C3F4,F6,2308, C3FC,F6,2309, C209,16,2575, C3FC,09,254E, C3F9,04,2550, C3F9,FC,2540, C3D8,E8,232C, C3ED,EB,230D, C3F5,E3,230B, C3FC,E6,2306, C3EC,E6,2304, C3FC,D6,2302, C3EC,D6,2300
$AA:EA1E             dx 0016, C3E8,EB,2326, 01E0,F7,231F, 01FA,DD,237B, C3FA,1E,2371, C3F2,1E,2370, C3FA,13,235C, C3FA,0B,234C, C3FD,17,2573, C3F9,03,2350, C3F9,FB,2340, C3FA,08,254E, C3F4,F5,2308, C3FC,F5,2309, C3F7,03,2552, C3F7,FB,2542, C3D8,E7,232C, C3ED,EA,230D, C3F5,E2,230B, C3FC,E5,2306, C3EC,E5,2304, C3FC,D5,2302, C3EC,D5,2300
$AA:EA8E             dx 0016, 01E0,F8,231F, C3E8,EC,2326, 01FA,DE,237C, C201,1D,2371, C3F9,1D,2370, C201,12,2356, C201,0A,2346, C3FB,04,6352, C3FB,FC,6342, C3F2,1B,2573, C3F3,10,2556, C3F3,08,2546, C3F4,F6,2308, C3FC,F6,2309, C3F4,FC,2544, C3D8,E8,232C, C3ED,EB,230D, C3F5,E3,230B, C3FC,E6,2306, C3EC,E6,2304, C3FC,D6,2302, C3EC,D6,2300
$AA:EAFE             dx 0015, C3E8,ED,2326, 01E0,F9,231F, 01FA,DF,2379, C210,15,2375, C204,09,234E, C3FB,05,6352, C3FB,FD,6342, C3F4,F7,2308, C3FC,F7,2309, C3E1,1B,2570, C3E9,1B,2571, C3EE,10,2558, C3EE,08,2548, C3F4,FD,2544, C3D8,E9,232C, C3ED,EC,230D, C3F5,E4,230B, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:EB69             dx 0016, 01E0,F8,231F, C3E8,EC,2326, 01FA,DE,237A, C209,16,2375, C3FC,09,234E, C3F9,04,2350, C3F9,FC,2340, C3D8,E8,232C, C3F5,E3,230B, C3ED,EB,230D, C3F4,F6,2308, C3FC,F6,2309, C3FC,E6,2306, C3EC,E6,2304, C3FC,D6,2302, C3EC,D6,2300, C3E4,1C,2570, C3EC,1C,2571, C3F1,11,2558, C3F1,09,2548, C3F7,04,2552, C3F7,FC,2542
$AA:EBD9             dx 0016, C3E8,EB,2326, 01E0,F7,231F, 01FA,DD,237B, C3FD,17,2373, C3FA,08,234E, C3F7,03,2352, C3F7,FB,2342, C3F2,1E,2570, C3FA,1E,2571, C3FA,13,255C, C3FA,0B,254C, C3F9,03,2550, C3F9,FB,2540, C3D8,E7,232C, C3ED,EA,230D, C3F5,E2,230B, C3F4,F5,2308, C3FC,F5,2309, C3FC,E5,2306, C3EC,E5,2304, C3FC,D5,2302, C3EC,D5,2300
$AA:EC49             dx 0016, 01E0,F8,231F, C3E8,EC,2326, 01FA,DE,237C, C3F2,1B,2373, C3F3,10,2356, C3F3,08,2346, C3F4,FC,2344, C3F9,1D,2570, C201,1D,2571, C201,12,2556, C201,0A,2546, C3F4,F6,2308, C3FC,F6,2309, C3FB,FC,6542, C3FB,04,6552, C3D8,E8,232C, C3ED,EB,230D, C3F5,E3,230B, C3FC,E6,2306, C3EC,E6,2304, C3FC,D6,2302, C3EC,D6,2300
$AA:ECB9             dx 0012, C3E8,ED,2326, 01E0,F9,231F, 01FA,DF,237D, C3D8,E9,232C, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:ED15             dx 0012, 01E0,F9,231F, C3E8,ED,2326, 01FA,DF,237C, C3D8,E9,232C, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:ED71             dx 0012, C3D8,E9,232C, C3E8,ED,2326, 01E0,F9,231F, 01FA,DF,237B, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:EDCD             dx 0012, 01E0,F9,231F, C3E8,ED,2326, 01FA,DF,237A, C3D8,E9,232C, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:EE29             dx 0012, C3D8,E9,232C, 01E0,F9,231F, C3E8,ED,2326, 01FA,DF,2379, C3ED,EC,230D, C3F5,E4,230B, C3F2,1F,2370, C3FA,1F,2371, C3FA,0D,234C, C3FA,15,235C, C3F9,05,2350, C3F9,FD,2340, C3F4,F7,2308, C3FC,F7,2309, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:EE85             dx 002A, C3E0,98,2344, C242,98,234A, C232,A0,2358, C232,98,2348, C222,A0,235C, C222,98,234C, C202,98,234E, C212,A0,2356, C212,98,2346, C201,B8,254E, C211,C0,2556, C211,B8,2546, C241,B8,254A, C231,C0,2558, C231,B8,2548, C221,C0,255C, C221,B8,254C, C3D8,F0,2577, C3C8,F0,2575, C3B8,F0,2573, C3A0,F0,2570, C3A8,F0,2571, C3D8,E0,2377, C3C8,E0,2375, C3B8,E0,2373, C3A8,E0,2371, C3A0,E0,2370, C3D0,A0,2352, C3D0,98,2342, C3B0,A0,6352, C3B0,98,6342, C3C0,A0,2350, C3C0,98,2340, C3A0,98,6344, C3A1,B8,6544, C3B0,B8,6542, C3B0,C0,6552, C3D0,C0,2552, C3C0,C0,2550, C3E0,B8,2544, C3D0,B8,2542, C3C0,B8,2540
$AA:EF59             dx 0019, C238,88,230D, C240,80,230B, 003E,EF,2339, C236,DF,232C, C246,E7,232A, C220,DB,232A, C210,DB,2328, C245,C8,2326, 0045,C0,231F, C235,C0,2324, C211,C0,2320, 0021,C0,230F, C221,C8,2322, C3B7,BD,234C, C3B7,C5,235C, C399,D7,2350, C399,CF,2340, C3DA,CA,2370, C3E2,CA,2371, C3F1,A8,2308, C3F9,A8,2309, C3F9,98,2306, C3E9,98,2304, C3F9,88,2302, C3E9,88,2300
$AA:EFD8             dx 0012, 01FE,DF,637D, C21A,E7,6320, 0012,E7,630F, C20A,EF,6322, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F034             dx 0011, 01FE,DF,637D, C207,ED,632A, C217,ED,6328, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F08B             dx 0011, C208,ED,6326, C218,ED,6324, 01FE,DF,637D, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F0E2             dx 0012, C208,ED,6326, C218,E9,632C, 0018,F9,631F, 01FE,DF,637D, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F13E             dx 0015, 01E0,F9,231F, C3E8,ED,2326, 01FA,DF,2379, C3E9,1B,2371, C3E1,1B,2370, C3EE,10,2358, C3EE,08,2348, C3F4,FD,2344, C3F4,F7,2308, C3FC,F7,2309, C210,15,2575, C204,09,254E, C3FB,FD,6542, C3FB,05,6552, C3D8,E9,232C, C3ED,EC,230D, C3F5,E4,230B, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:F1A9             dx 0016, 01E0,F8,231F, C3E8,EC,2326, 01FA,DE,237A, C3EC,1C,2371, C3E4,1C,2370, C3F1,11,2358, C3F1,09,2348, C3F7,04,2352, C3F7,FC,2342, C3F4,F6,2308, C3FC,F6,2309, C209,16,2575, C3FC,09,254E, C3F9,04,2550, C3F9,FC,2540, C3D8,E8,232C, C3ED,EB,230D, C3F5,E3,230B, C3FC,E6,2306, C3EC,E6,2304, C3FC,D6,2302, C3EC,D6,2300
$AA:F219             dx 0016, C3E8,EB,2326, 01E0,F7,231F, 01FA,DD,237B, C3FA,1E,2371, C3F2,1E,2370, C3FA,13,235C, C3FA,0B,234C, C3FD,17,2573, C3F9,03,2350, C3F9,FB,2340, C3FA,08,254E, C3F4,F5,2308, C3FC,F5,2309, C3F7,03,2552, C3F7,FB,2542, C3D8,E7,232C, C3ED,EA,230D, C3F5,E2,230B, C3FC,E5,2306, C3EC,E5,2304, C3FC,D5,2302, C3EC,D5,2300
$AA:F289             dx 0016, 01E0,F8,231F, C3E8,EC,2326, 01FA,DE,237C, C201,1D,2371, C3F9,1D,2370, C201,12,2356, C201,0A,2346, C3FB,04,6352, C3FB,FC,6342, C3F2,1B,2573, C3F3,10,2556, C3F3,08,2546, C3F4,F6,2308, C3FC,F6,2309, C3F4,FC,2544, C3D8,E8,232C, C3ED,EB,230D, C3F5,E3,230B, C3FC,E6,2306, C3EC,E6,2304, C3FC,D6,2302, C3EC,D6,2300
$AA:F2F9             dx 0015, C3E8,ED,2326, 01E0,F9,231F, 01FA,DF,2379, C210,15,2375, C204,09,234E, C3FB,05,6352, C3FB,FD,6342, C3F4,F7,2308, C3FC,F7,2309, C3E1,1B,2570, C3E9,1B,2571, C3EE,10,2558, C3EE,08,2548, C3F4,FD,2544, C3D8,E9,232C, C3ED,EC,230D, C3F5,E4,230B, C3FC,E7,2306, C3EC,E7,2304, C3FC,D7,2302, C3EC,D7,2300
$AA:F364             dx 0016, 01E0,F8,231F, C3E8,EC,2326, 01FA,DE,237A, C209,16,2375, C3FC,09,234E, C3F9,04,2350, C3F9,FC,2340, C3D8,E8,232C, C3F5,E3,230B, C3ED,EB,230D, C3F4,F6,2308, C3FC,F6,2309, C3FC,E6,2306, C3EC,E6,2304, C3FC,D6,2302, C3EC,D6,2300, C3E4,1C,2570, C3EC,1C,2571, C3F1,11,2558, C3F1,09,2548, C3F7,04,2552, C3F7,FC,2542
$AA:F3D4             dx 0016, C3E8,EB,2326, 01E0,F7,231F, 01FA,DD,237B, C3FD,17,2373, C3FA,08,234E, C3F7,03,2352, C3F7,FB,2342, C3F2,1E,2570, C3FA,1E,2571, C3FA,13,255C, C3FA,0B,254C, C3F9,03,2550, C3F9,FB,2540, C3D8,E7,232C, C3ED,EA,230D, C3F5,E2,230B, C3F4,F5,2308, C3FC,F5,2309, C3FC,E5,2306, C3EC,E5,2304, C3FC,D5,2302, C3EC,D5,2300
$AA:F444             dx 0016, 01E0,F8,231F, C3E8,EC,2326, 01FA,DE,237C, C3F2,1B,2373, C3F3,10,2356, C3F3,08,2346, C3F4,FC,2344, C3F9,1D,2570, C201,1D,2571, C201,12,2556, C201,0A,2546, C3F4,F6,2308, C3FC,F6,2309, C3FB,FC,6542, C3FB,04,6552, C3D8,E8,232C, C3ED,EB,230D, C3F5,E3,230B, C3FC,E6,2306, C3EC,E6,2304, C3FC,D6,2302, C3EC,D6,2300
$AA:F4B4             dx 0012, C208,ED,6326, 0018,F9,631F, 01FE,DF,637D, C218,E9,632C, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F510             dx 0012, 0018,F9,631F, C208,ED,6326, 01FE,DF,637C, C218,E9,632C, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F56C             dx 0012, C218,E9,632C, C208,ED,6326, 0018,F9,631F, 01FE,DF,637B, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F5C8             dx 0012, 0018,F9,631F, C208,ED,6326, 01FE,DF,637A, C218,E9,632C, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F624             dx 0012, C218,E9,632C, 0018,F9,631F, C208,ED,6326, 01FE,DF,6379, C203,EC,630D, C3FB,E4,630B, C3FE,1F,6370, C3F6,1F,6371, C3F6,0D,634C, C3F6,15,635C, C3F7,05,6350, C3F7,FD,6340, C3FC,F7,6308, C3F4,F7,6309, C3F4,E7,6306, C204,E7,6304, C3F4,D7,6302, C204,D7,6300
$AA:F680             dx 002A, C3E0,98,2344, C242,98,234A, C232,A0,2358, C232,98,2348, C222,A0,235C, C222,98,234C, C202,98,234E, C212,A0,2356, C212,98,2346, C201,B8,254E, C211,C0,2556, C211,B8,2546, C241,B8,254A, C231,C0,2558, C231,B8,2548, C221,C0,255C, C221,B8,254C, C3D8,F0,2577, C3C8,F0,2575, C3B8,F0,2573, C3A0,F0,2570, C3A8,F0,2571, C3D8,E0,2377, C3C8,E0,2375, C3B8,E0,2373, C3A8,E0,2371, C3A0,E0,2370, C3D0,A0,2352, C3D0,98,2342, C3B0,A0,6352, C3B0,98,6342, C3C0,A0,2350, C3C0,98,2340, C3A0,98,6344, C3A1,B8,6544, C3B0,B8,6542, C3B0,C0,6552, C3D0,C0,2552, C3C0,C0,2550, C3E0,B8,2544, C3D0,B8,2542, C3C0,B8,2540
$AA:F754             dx 0019, C238,88,230D, C240,80,230B, 003E,EF,2339, C236,DF,232C, C246,E7,232A, C220,DB,232A, C210,DB,2328, C245,C8,2326, 0045,C0,231F, C235,C0,2324, C211,C0,2320, 0021,C0,230F, C221,C8,2322, C3B7,BD,234C, C3B7,C5,235C, C399,D7,2350, C399,CF,2340, C3DA,CA,2370, C3E2,CA,2371, C3F1,A8,2308, C3F9,A8,2309, C3F9,98,2306, C3E9,98,2304, C3F9,88,2302, C3E9,88,2300
}
}


;;; $F7D3: Free space ;;;
{
$AA:F7D3             fillto $AB8000, $FF
}
